/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.test.common;

import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.test.common.PropertyBag;
import org.identityconnectors.test.common.ToListResultsHandler;
import org.identityconnectors.test.common.spi.TestHelpersSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestHelpers {
    private static final Object LOCK = new Object();
    private static final String IMPL_NAME = "org.identityconnectors.framework.impl.test.TestHelpersImpl";
    private static TestHelpersSpi _instance;
    private static final Map<String, PropertyBag> bags;

    private TestHelpers() {
    }

    public static APIConfiguration createTestConfiguration(Class<? extends Connector> clazz, Configuration config) {
        return TestHelpers.getSpi().createTestConfiguration(clazz, config);
    }

    public static void fillConfiguration(Configuration config, Map<String, ? extends Object> configData) {
        TestHelpers.getSpi().fillConfiguration(config, configData);
    }

    public static ConnectorMessages createDummyMessages() {
        return TestHelpers.getSpi().createDummyMessages();
    }

    public static List<ConnectorObject> searchToList(SearchApiOp search, ObjectClass oclass, Filter filter) {
        return TestHelpers.searchToList(search, oclass, filter, null);
    }

    public static List<ConnectorObject> searchToList(SearchApiOp search, ObjectClass oclass, Filter filter, OperationOptions options) {
        ToListResultsHandler handler = new ToListResultsHandler();
        search.search(oclass, filter, handler, options);
        return handler.getObjects();
    }

    public static List<ConnectorObject> searchToList(SearchOp<?> search, ObjectClass oclass, Filter filter) {
        return TestHelpers.searchToList(search, oclass, filter, null);
    }

    public static List<ConnectorObject> searchToList(SearchOp<?> search, ObjectClass oclass, Filter filter, OperationOptions options) {
        ToListResultsHandler handler = new ToListResultsHandler();
        TestHelpers.search(search, oclass, filter, handler, options);
        return handler.getObjects();
    }

    public static void search(SearchOp<?> search, ObjectClass oclass, Filter filter, ResultsHandler handler, OperationOptions options) {
        TestHelpers.getSpi().search(search, oclass, filter, handler, options);
    }

    private static synchronized TestHelpersSpi getSpi() {
        if (_instance == null) {
            try {
                Class<?> clazz = Class.forName(IMPL_NAME);
                Object object = clazz.newInstance();
                _instance = (TestHelpersSpi)TestHelpersSpi.class.cast(object);
            }
            catch (Exception e) {
                throw ConnectorException.wrap(e);
            }
        }
        return _instance;
    }

    public static PropertyBag getProperties(Class<?> clazz) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            throw new IllegalStateException("Thread.currentThread().getContextClassLoader() is null, please set context ClassLoader");
        }
        return TestHelpers.getProperties(clazz, loader);
    }

    static Map<?, ?> loadGroovyConfigFile(URL url) {
        try {
            Class<?> slurper = Class.forName("groovy.util.ConfigSlurper");
            Class<?> configObject = Class.forName("groovy.util.ConfigObject");
            Object slurpInstance = slurper.newInstance();
            Method parse = slurper.getMethod("parse", URL.class);
            Object config = parse.invoke(slurpInstance, url);
            Method toProps = configObject.getMethod("flatten", new Class[0]);
            Object result = toProps.invoke(config, new Object[0]);
            return (Map)result;
        }
        catch (Exception e) {
            throw new ConnectorException(MessageFormat.format("Could not load Groovy config file ''{0}''", url), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PropertyBag getProperties(Class<?> clazz, ClassLoader loader) {
        Object object = LOCK;
        synchronized (object) {
            PropertyBag bag = bags.get(clazz.getName());
            if (bag == null) {
                bag = TestHelpers.loadConnectorConfigurationAsResource(clazz.getName(), loader);
                bags.put(clazz.getName(), bag);
            }
            return bag;
        }
    }

    static PropertyBag loadConnectorConfigurationAsResource(String prefix, ClassLoader loader) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String cfg = System.getProperty("testConfig", null);
        URL url = loader.getResource(prefix + "/config/config.groovy");
        if (url != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url));
        }
        if (StringUtil.isNotBlank(cfg) && !"default".equals(cfg) && (url = loader.getResource(prefix + "/config/" + cfg + "/config.groovy")) != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url));
        }
        if ((url = loader.getResource(prefix + "/config-private/config.groovy")) != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url));
        }
        if (StringUtil.isNotBlank(cfg) && !"default".equals(cfg) && (url = loader.getResource(prefix + "/config-private/" + cfg + "/config.groovy")) != null) {
            TestHelpers.appendProperties(ret, TestHelpers.loadGroovyConfigFile(url));
        }
        return new PropertyBag(ret);
    }

    static void appendProperties(Map<String, Object> ret, Map<?, ?> props) {
        if (props != null) {
            for (Map.Entry<?, ?> entry : props.entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    ret.put((String)key, entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Entry in read properties has not string key : " + entry);
            }
        }
    }

    static {
        bags = new HashMap<String, PropertyBag>();
    }
}

