/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.binary;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.Pair;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.BinaryObjectSerializer;
import org.identityconnectors.framework.impl.serializer.ObjectEncoder;
import org.identityconnectors.framework.impl.serializer.ObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectSerializerRegistry;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryObjectEncoder
implements ObjectEncoder,
BinaryObjectSerializer {
    public static final int ENCODING_VERSION = 1;
    public static final int OBJECT_MAGIC = 64251;
    public static final byte OBJECT_TYPE_NULL = 60;
    public static final byte OBJECT_TYPE_CLASS = 61;
    public static final byte OBJECT_TYPE_ARRAY = 62;
    public static final byte FIELD_TYPE_ANONYMOUS_FIELD = 70;
    public static final byte FIELD_TYPE_NAMED_FIELD = 71;
    public static final byte FIELD_TYPE_END_OBJECT = 72;
    private InternalEncoder _internalEncoder;

    public BinaryObjectEncoder(OutputStream output) {
        this._internalEncoder = new InternalEncoder(new DataOutputStream(new BufferedOutputStream(output, 4096)));
    }

    @Override
    public void flush() {
        try {
            this._internalEncoder._rootOutput.flush();
        }
        catch (IOException e) {
            throw ConnectorException.wrap(e);
        }
    }

    @Override
    public void close() {
        this.flush();
        try {
            this._internalEncoder._rootOutput.close();
        }
        catch (IOException e) {
            throw ConnectorException.wrap(e);
        }
    }

    @Override
    public void writeObject(Object o) {
        this._internalEncoder.writeObject(this, o);
    }

    @Override
    public void writeBooleanContents(boolean v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeBoolean(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeBooleanField(String fieldName, boolean v) {
        this._internalEncoder.startField(fieldName);
        this._internalEncoder.writeBoolean(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeByteArrayContents(byte[] v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeByteArray(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeClassContents(Class<?> v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeClass(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeClassField(String fieldName, Class<?> v) {
        if (v != null) {
            this._internalEncoder.startField(fieldName);
            this._internalEncoder.writeClass(v);
            this._internalEncoder.endField();
        }
    }

    @Override
    public void writeDoubleContents(double v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeDouble(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeDoubleField(String fieldName, double v) {
        this._internalEncoder.startField(fieldName);
        this._internalEncoder.writeDouble(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeFloatContents(float v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeDouble(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeFloatField(String fieldName, float v) {
        this._internalEncoder.startField(fieldName);
        this._internalEncoder.writeDouble(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeIntContents(int v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeInt(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeIntField(String fieldName, int v) {
        this._internalEncoder.startField(fieldName);
        this._internalEncoder.writeInt(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeLongContents(long v) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeLong(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeLongField(String fieldName, long v) {
        this._internalEncoder.startField(fieldName);
        this._internalEncoder.writeLong(v);
        this._internalEncoder.endField();
    }

    @Override
    public void writeObjectContents(Object object) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeObject(this, object);
        this._internalEncoder.endField();
    }

    @Override
    public void writeObjectField(String fieldName, Object object, boolean inline) {
        this._internalEncoder.startField(fieldName);
        this._internalEncoder.writeObject(this, object);
        this._internalEncoder.endField();
    }

    @Override
    public void writeStringContents(String str) {
        this._internalEncoder.startAnonymousField();
        this._internalEncoder.writeString(str, false);
        this._internalEncoder.endField();
    }

    @Override
    public void writeStringField(String fieldName, String v) {
        if (v != null) {
            this._internalEncoder.startField(fieldName);
            this._internalEncoder.writeString(v, false);
            this._internalEncoder.endField();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalEncoder {
        private Map<String, Integer> _constantPool = new HashMap<String, Integer>();
        private List<String> _constantBuffer = new ArrayList<String>();
        private List<OutputBuffer> _outputBufferStack = new ArrayList<OutputBuffer>();
        private DataOutputStream _rootOutput;
        private boolean _firstObject = true;

        public InternalEncoder(DataOutputStream output) {
            this._rootOutput = output;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void writeObject(ObjectEncoder encoder, Object object) {
            if (this._firstObject) {
                this.writeInt(64251);
                this.writeInt(1);
                this._firstObject = false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(baos);
            OutputBuffer objectBuffer = new OutputBuffer(baos, data);
            this._outputBufferStack.add(objectBuffer);
            if (object == null) {
                this.writeByte((byte)60);
            } else {
                Class<?> clazz = object.getClass();
                this.writeClass(clazz);
                ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
                if (handler == null) {
                    if (!clazz.isArray()) throw new ConnectorException("No serializer for class: " + clazz);
                    int length = Array.getLength(object);
                    for (int i = 0; i < length; ++i) {
                        Object val = Array.get(object, i);
                        this.startAnonymousField();
                        this.writeObject(encoder, val);
                        this.endField();
                    }
                } else {
                    handler.serialize(object, encoder);
                }
            }
            this.writeByte((byte)72);
            this._outputBufferStack.remove(this._outputBufferStack.size() - 1);
            if (this._outputBufferStack.size() == 0) {
                this.writeInt(this._constantBuffer.size());
                for (String constant : this._constantBuffer) {
                    this.writeString(constant, false);
                    this.writeInt(this._constantPool.get(constant));
                }
                this._constantBuffer.clear();
            }
            try {
                ((DataOutputStream)objectBuffer.second).close();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
            byte[] bytes = ((ByteArrayOutputStream)objectBuffer.first).toByteArray();
            this.writeBytes(bytes);
        }

        public void writeClass(Class<?> clazz) {
            ObjectSerializationHandler handler = ObjectSerializerRegistry.getHandlerByObjectType(clazz);
            ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperByObjectType(clazz);
            if (handler == null && clazz.isArray()) {
                this.writeByte((byte)62);
                this.writeClass(clazz.getComponentType());
            } else {
                if (mapper == null) {
                    throw new ConnectorException("No serializer for class: " + clazz);
                }
                String typeName = mapper.getHandledSerialType();
                this.writeByte((byte)61);
                this.writeString(typeName, true);
            }
        }

        public void startAnonymousField() {
            this.writeByte((byte)70);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(buf);
            this._outputBufferStack.add(new OutputBuffer(buf, data));
        }

        public void startField(String name) {
            this.writeByte((byte)71);
            this.writeString(name, true);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(buf);
            this._outputBufferStack.add(new OutputBuffer(buf, data));
        }

        public void endField() {
            OutputBuffer buf = this._outputBufferStack.remove(this._outputBufferStack.size() - 1);
            try {
                ((DataOutputStream)buf.second).close();
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
            byte[] bytes = ((ByteArrayOutputStream)buf.first).toByteArray();
            this.writeByteArray(bytes);
        }

        public void writeInt(int v) {
            try {
                this.getCurrentOutput().writeInt(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public void writeLong(long v) {
            try {
                this.getCurrentOutput().writeLong(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public void writeDouble(double l) {
            try {
                this.getCurrentOutput().writeDouble(l);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public void writeByteArray(byte[] v) {
            try {
                this.getCurrentOutput().writeInt(v.length);
                this.getCurrentOutput().write(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public void writeByte(byte b) {
            try {
                this.getCurrentOutput().writeByte(b);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public void writeBoolean(boolean b) {
            try {
                this.getCurrentOutput().writeBoolean(b);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        public void writeString(String str, boolean intern) {
            if (intern) {
                int code = this.internIdentifier(str);
                this.writeInt(code);
                return;
            }
            try {
                byte[] bytes = str.getBytes("UTF8");
                this.writeByteArray(bytes);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        private void writeBytes(byte[] v) {
            try {
                this.getCurrentOutput().write(v);
            }
            catch (IOException e) {
                throw ConnectorException.wrap(e);
            }
        }

        private int internIdentifier(String name) {
            Integer code = this._constantPool.get(name);
            if (code == null) {
                code = this._constantPool.size();
                this._constantPool.put(name, code);
                this._constantBuffer.add(name);
            }
            return code;
        }

        private DataOutputStream getCurrentOutput() {
            if (this._outputBufferStack.size() == 0) {
                return this._rootOutput;
            }
            OutputBuffer buf = this._outputBufferStack.get(this._outputBufferStack.size() - 1);
            return (DataOutputStream)buf.second;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutputBuffer
    extends Pair<ByteArrayOutputStream, DataOutputStream> {
        public OutputBuffer(ByteArrayOutputStream buf, DataOutputStream data) {
            super(buf, data);
        }
    }
}

