/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class TimerCatchIntermediateEventJobHandler
implements JobHandler {
    private static Logger log = Logger.getLogger(TimerCatchIntermediateEventJobHandler.class.getName());
    public static final String TYPE = "timer-intermediate-transition";

    public String getType() {
        return TYPE;
    }

    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext) {
        ActivityImpl intermediateEventActivity = execution.getProcessDefinition().findActivity(configuration);
        if (intermediateEventActivity == null) {
            throw new ActivitiException("Error while firing timer: intermediate event activity " + configuration + " not found");
        }
        try {
            if (!execution.getActivity().getId().equals(intermediateEventActivity.getId())) {
                execution.setActivity(intermediateEventActivity);
            }
            execution.signal(null, null);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw e;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw new ActivitiException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

