/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetryInterceptor
extends CommandInterceptor {
    Logger log = Logger.getLogger(RetryInterceptor.class.getName());
    protected int numOfRetries = 3;
    protected int waitTimeInMs = 50;
    protected int waitIncreaseFactor = 5;

    @Override
    public <T> T execute(Command<T> command) {
        long waitTime = this.waitTimeInMs;
        int failedAttempts = 0;
        while (true) {
            if (failedAttempts > 0) {
                this.log.info("Waiting for " + waitTime + "ms before retrying the command.");
                this.waitBeforeRetry(waitTime);
                waitTime *= (long)this.waitIncreaseFactor;
            }
            try {
                return this.next.execute(command);
            }
            catch (ActivitiOptimisticLockingException e) {
                this.log.log(Level.INFO, "Caught optimistic locking exception: " + e);
                if (++failedAttempts <= this.numOfRetries) continue;
                throw new ActivitiException(this.numOfRetries + " retries failed with ActivitiOptimisticLockingException. Giving up.");
            }
            break;
        }
    }

    protected void waitBeforeRetry(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            this.log.finest("I am interrupted while waiting for a retry.");
        }
    }

    public void setNumOfRetries(int numOfRetries) {
        this.numOfRetries = numOfRetries;
    }

    public void setWaitIncreaseFactor(int waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public void setWaitTimeInMs(int waitTimeInMs) {
        this.waitTimeInMs = waitTimeInMs;
    }

    public int getNumOfRetries() {
        return this.numOfRetries;
    }

    public int getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public int getWaitTimeInMs() {
        return this.waitTimeInMs;
    }
}

