/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.form.StartFormHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubmitStartFormCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected final String businessKey;
    protected Map<String, String> properties;

    public SubmitStartFormCmd(String processDefinitionId, String businessKey, Map<String, String> properties) {
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.properties = properties;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiException("No process definition found for id = '" + this.processDefinitionId + "'");
        }
        ExecutionEntity processInstance = null;
        processInstance = this.businessKey != null ? processDefinition.createProcessInstance(this.businessKey) : processDefinition.createProcessInstance();
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 1) {
            DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
            if (historyLevel >= 2) {
                for (String propertyId : this.properties.keySet()) {
                    String propertyValue = this.properties.get(propertyId);
                    HistoricFormPropertyEntity historicFormProperty = new HistoricFormPropertyEntity(processInstance, propertyId, propertyValue);
                    dbSqlSession.insert(historicFormProperty);
                }
            }
        }
        StartFormHandler startFormHandler = processDefinition.getStartFormHandler();
        startFormHandler.submitFormProperties(this.properties, processInstance);
        processInstance.start();
        return processInstance;
    }
}

