/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap;

import java.util.List;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectClassMappingConfig {
    private final ObjectClass objectClass;
    private List<String> ldapClasses;
    private final boolean container;
    private List<String> shortNameLdapAttributes;
    private final Set<AttributeInfo> operationalAttributes;

    public ObjectClassMappingConfig(ObjectClass objectClass, List<String> ldapClasses, boolean container, List<String> shortNameLdapAttributes, AttributeInfo ... operationalAttributes) {
        assert (objectClass != null);
        this.objectClass = objectClass;
        assert (ldapClasses != null);
        this.setLdapClasses(ldapClasses);
        this.container = container;
        assert (shortNameLdapAttributes != null);
        this.shortNameLdapAttributes = CollectionUtil.newReadOnlyList(shortNameLdapAttributes);
        this.operationalAttributes = CollectionUtil.newSet((Object[])operationalAttributes);
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public List<String> getLdapClasses() {
        return this.ldapClasses;
    }

    public void setLdapClasses(List<String> ldapClasses) {
        this.ldapClasses = CollectionUtil.newReadOnlyList(ldapClasses);
    }

    public boolean isContainer() {
        return this.container;
    }

    public List<String> getShortNameLdapAttributes() {
        return this.shortNameLdapAttributes;
    }

    public void setShortNameLdapAttributes(List<String> shortNameLdapAttributes) {
        this.shortNameLdapAttributes = CollectionUtil.newReadOnlyList(shortNameLdapAttributes);
    }

    public Set<AttributeInfo> getOperationalAttributes() {
        return this.operationalAttributes;
    }

    public int hashCode() {
        return this.objectClass.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectClassMappingConfig) {
            ObjectClassMappingConfig that = (ObjectClassMappingConfig)o;
            if (!this.objectClass.equals((Object)that.objectClass)) {
                return false;
            }
            if (!((Object)this.ldapClasses).equals(that.ldapClasses)) {
                return false;
            }
            if (this.container != that.container) {
                return false;
            }
            if (!((Object)this.shortNameLdapAttributes).equals(that.shortNameLdapAttributes)) {
                return false;
            }
            return ((Object)this.operationalAttributes).equals(that.operationalAttributes);
        }
        return false;
    }
}

