/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.request.cycle.RequestCycle;

public class ThreadContext {
    private Application application;
    private RequestCycle requestCycle;
    private Session session;
    private static ThreadLocal<ThreadContext> threadLocal = new ThreadLocal();

    public static ThreadContext get(boolean createIfDoesNotExist) {
        ThreadContext context = threadLocal.get();
        if (createIfDoesNotExist && context == null) {
            context = new ThreadContext();
            threadLocal.set(context);
        }
        return context;
    }

    public static boolean exists() {
        return ThreadContext.get(false) != null;
    }

    public static Application getApplication() {
        ThreadContext context = ThreadContext.get(false);
        return context != null ? context.application : null;
    }

    public static void setApplication(Application application) {
        ThreadContext context = ThreadContext.get(true);
        context.application = application;
    }

    public static RequestCycle getRequestCycle() {
        ThreadContext context = ThreadContext.get(false);
        return context != null ? context.requestCycle : null;
    }

    public static void setRequestCycle(RequestCycle requestCycle) {
        ThreadContext context = ThreadContext.get(true);
        context.requestCycle = requestCycle;
    }

    public static Session getSession() {
        ThreadContext context = ThreadContext.get(false);
        return context != null ? context.session : null;
    }

    public static void setSession(Session session) {
        ThreadContext context = ThreadContext.get(true);
        context.session = session;
    }

    public static ThreadContext detach() {
        ThreadContext value = threadLocal.get();
        threadLocal.remove();
        return value;
    }

    public static void restore(ThreadContext threadContext) {
        threadLocal.set(threadContext);
    }

    private ThreadContext() {
    }
}

