/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.execution;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.task.api.ClusterStatusInformation;
import com.evolveum.midpoint.task.api.Node;
import com.evolveum.midpoint.task.api.NodeExecutionStatus;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerConfiguration;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.cluster.ClusterManager;
import com.evolveum.midpoint.task.quartzimpl.execution.ExecutionManager;
import com.evolveum.midpoint.task.quartzimpl.execution.JmxClient;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.quartz.core.jmx.QuartzSchedulerMBean;

public class RemoteNodesManager {
    private static final transient Trace LOGGER = TraceManager.getTrace(RemoteNodesManager.class);
    private TaskManagerQuartzImpl taskManager;

    public RemoteNodesManager(TaskManagerQuartzImpl taskManager) {
        this.taskManager = taskManager;
    }

    void addNodeStatusFromRemoteNode(ClusterStatusInformation info, PrismObject<NodeType> node, OperationResult parentResult) {
        MBeanServerConnection mbsc;
        OperationResult result = parentResult.createSubresult(String.valueOf(RemoteNodesManager.class.getName()) + ".addNodeStatusFromRemoteNode");
        result.addParam("node", node);
        String nodeName = ((NodeType)node.asObjectable()).getNodeIdentifier();
        String address = String.valueOf(((NodeType)node.asObjectable()).getHostname()) + ":" + ((NodeType)node.asObjectable()).getJmxPort();
        Node nodeInfo = new Node(node);
        if (!this.taskManager.getClusterManager().isUp((NodeType)node.asObjectable())) {
            nodeInfo.setNodeExecutionStatus(NodeExecutionStatus.DOWN);
            info.addNodeInfo(nodeInfo);
            result.recordStatus(OperationResultStatus.SUCCESS, "Node is down");
            return;
        }
        JMXConnector connector = null;
        try {
            connector = this.connectViaJmx(address);
            mbsc = connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot connect to the remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
            nodeInfo.setNodeExecutionStatus(NodeExecutionStatus.COMMUNICATION_ERROR);
            nodeInfo.setConnectionError("Cannot connect to the remote node: " + e.getMessage());
            info.addNodeInfo(nodeInfo);
            result.recordWarning("Cannot connect to the remote node " + nodeName + " at " + address, (Throwable)e);
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e2) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e2, (Object[])new Object[]{address});
            }
            result.recordSuccessIfUnknown();
            return;
        }
        try {
            try {
                QuartzSchedulerMBean mbeanProxy = this.getMBeanProxy(nodeName, mbsc);
                boolean running = false;
                boolean down = true;
                if (mbeanProxy != null) {
                    try {
                        running = mbeanProxy.isStarted() && !mbeanProxy.isShutdown() && !mbeanProxy.isStandbyMode();
                        down = mbeanProxy.isShutdown();
                    }
                    catch (Exception e) {
                        String message = "Cannot get information from scheduler " + nodeName + " because it does not exist or is shut down.";
                        LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
                        result.recordWarning(message);
                    }
                } else {
                    result.recordWarning("Cannot get information from node " + nodeName + " at " + address + " because the JMX object for scheduler cannot be found on that node.");
                }
                LOGGER.trace(" - scheduler found = " + (mbeanProxy != null) + ", running = " + running + ", shutdown = " + down);
                if (down) {
                    nodeInfo.setNodeExecutionStatus(NodeExecutionStatus.ERROR);
                } else if (running) {
                    nodeInfo.setNodeExecutionStatus(NodeExecutionStatus.RUNNING);
                } else {
                    nodeInfo.setNodeExecutionStatus(NodeExecutionStatus.PAUSED);
                }
                ArrayList<ClusterStatusInformation.TaskInfo> taskInfoList = new ArrayList<ClusterStatusInformation.TaskInfo>();
                if (mbeanProxy != null) {
                    TabularData jobs = mbeanProxy.getCurrentlyExecutingJobs();
                    for (CompositeData job : jobs.values()) {
                        String oid = (String)job.get("jobName");
                        LOGGER.trace(" - task oid = " + oid);
                        taskInfoList.add(new ClusterStatusInformation.TaskInfo(oid));
                    }
                }
                if (result.isUnknown()) {
                    result.recordStatus(OperationResultStatus.SUCCESS, "Node " + nodeName + ": status = " + nodeInfo.getNodeExecutionStatus() + ", # of running tasks: " + taskInfoList.size());
                }
                info.addNodeAndTaskInfo(nodeInfo, taskInfoList);
            }
            catch (Exception e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get information from the remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
                nodeInfo.setNodeExecutionStatus(NodeExecutionStatus.COMMUNICATION_ERROR);
                nodeInfo.setConnectionError("Cannot get information from the remote node: " + e.getMessage());
                result.recordWarning("Cannot get information from the remote node " + nodeName + " at " + address, (Throwable)e);
                info.addNodeInfo(nodeInfo);
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e3) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e3, (Object[])new Object[]{address});
                }
                result.recordSuccessIfUnknown();
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
            }
            result.recordSuccessIfUnknown();
            throw throwable;
        }
        try {
            if (connector != null) {
                connector.close();
            }
        }
        catch (IOException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
        }
        result.recordSuccessIfUnknown();
    }

    private NodeType getNode(String nodeIdentifier, OperationResult result) {
        try {
            return (NodeType)this.taskManager.getClusterManager().getNodeById(nodeIdentifier, result).asObjectable();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            result.recordFatalError("A node with identifier " + nodeIdentifier + " does not exist.");
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public void stopRemoteScheduler(String nodeIdentifier, OperationResult parentResult) {
        JMXConnector connector;
        String address;
        String nodeName;
        OperationResult result;
        block21: {
            MBeanServerConnection mbsc;
            result = parentResult.createSubresult(String.valueOf(RemoteNodesManager.class.getName()) + ".stopRemoteScheduler");
            result.addParam("nodeIdentifier", (Object)nodeIdentifier);
            NodeType node = this.getNode(nodeIdentifier, result);
            if (node == null) {
                return;
            }
            nodeName = node.getNodeIdentifier();
            address = String.valueOf(node.getHostname()) + ":" + node.getJmxPort();
            connector = null;
            try {
                connector = this.connectViaJmx(address);
                mbsc = connector.getMBeanServerConnection();
            }
            catch (IOException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot connect to the remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
                result.recordFatalError("Cannot connect to the remote node " + nodeName + " at " + address + ": " + e.getMessage(), (Throwable)e);
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e2) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e2, (Object[])new Object[]{address});
                }
                return;
            }
            {
                catch (Throwable throwable) {
                    try {
                        if (connector != null) {
                            connector.close();
                        }
                    }
                    catch (IOException e) {
                        LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
                    }
                    throw throwable;
                }
            }
            QuartzSchedulerMBean mbeanProxy = this.getMBeanProxy(nodeName, mbsc);
            if (mbeanProxy != null) {
                mbeanProxy.standby();
                break block21;
            }
            result.recordWarning("Cannot stop the scheduler on node " + nodeName + " at " + address + " because the JMX object for scheduler cannot be found on that node.");
        }
        try {
            if (connector != null) {
                connector.close();
            }
        }
        catch (IOException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
        }
        return;
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot put remote scheduler into standby mode; remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
            result.recordFatalError("Cannot put remote scheduler " + nodeName + " at " + address + " into standby mode: " + e.getMessage());
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e3) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e3, (Object[])new Object[]{address});
            }
            return;
        }
    }

    /*
     * Loose catch block
     */
    void startRemoteScheduler(String nodeIdentifier, OperationResult result) {
        JMXConnector connector;
        String address;
        String nodeName;
        block21: {
            MBeanServerConnection mbsc;
            NodeType node = this.getNode(nodeIdentifier, result);
            if (node == null) {
                return;
            }
            nodeName = node.getNodeIdentifier();
            address = String.valueOf(node.getHostname()) + ":" + node.getJmxPort();
            connector = null;
            try {
                connector = this.connectViaJmx(address);
                mbsc = connector.getMBeanServerConnection();
            }
            catch (IOException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot connect to the remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
                result.recordFatalError("Cannot connect to the remote node " + nodeName + " at " + address + ": " + e.getMessage(), (Throwable)e);
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e2) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e2, (Object[])new Object[]{address});
                }
                return;
            }
            {
                catch (Throwable throwable) {
                    try {
                        if (connector != null) {
                            connector.close();
                        }
                    }
                    catch (IOException e) {
                        LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
                    }
                    throw throwable;
                }
            }
            QuartzSchedulerMBean mbeanProxy = this.getMBeanProxy(nodeName, mbsc);
            if (mbeanProxy != null) {
                mbeanProxy.start();
                result.recordSuccessIfUnknown();
                break block21;
            }
            result.recordFatalError("Cannot start remote scheduler " + nodeName + " at " + address + " because it cannot be found on that node.");
        }
        try {
            if (connector != null) {
                connector.close();
            }
        }
        catch (IOException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
        }
        return;
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot start remote scheduler; remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
            result.recordFatalError("Cannot start remote scheduler " + nodeName + " at " + address + ": " + e.getMessage());
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e3) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e3, (Object[])new Object[]{address});
            }
            return;
        }
    }

    private QuartzSchedulerMBean getMBeanProxy(String nodeName, MBeanServerConnection mbsc) throws MalformedObjectNameException {
        String mbeanNameAsString = "quartz:type=QuartzScheduler,name=midPointScheduler,instance=" + nodeName;
        ObjectName mbeanName = new ObjectName(mbeanNameAsString);
        try {
            if (mbsc.isRegistered(mbeanName)) {
                return JMX.newMBeanProxy(mbsc, mbeanName, QuartzSchedulerMBean.class, true);
            }
            LOGGER.trace("MBean " + mbeanNameAsString + " is not registered at " + nodeName);
            return null;
        }
        catch (IOException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot communicate with remote node via JMX", (Throwable)e, (Object[])new Object[0]);
            return null;
        }
    }

    private JMXConnector connectViaJmx(String address) throws IOException {
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + address + "/jmxrmi");
        HashMap<String, Object> env = new HashMap<String, Object>();
        String[] creds = new String[]{this.taskManager.getConfiguration().getJmxUsername(), this.taskManager.getConfiguration().getJmxPassword()};
        env.put("jmx.remote.credentials", creds);
        return JmxClient.connectWithTimeout(url, env, this.taskManager.getConfiguration().getJmxConnectTimeout(), TimeUnit.SECONDS);
    }

    private TaskManagerConfiguration getConfiguration() {
        return this.taskManager.getConfiguration();
    }

    private ExecutionManager getGlobalExecutionManager() {
        return this.taskManager.getExecutionManager();
    }

    void stopRemoteTaskRun(String oid, Node nodeInfo, OperationResult parentResult) {
        MBeanServerConnection mbsc;
        OperationResult result = parentResult.createSubresult(String.valueOf(RemoteNodesManager.class.getName()) + ".stopRemoteTaskRun");
        result.addParam("oid", (Object)oid);
        result.addParam("nodeInfo", (Object)nodeInfo);
        LOGGER.debug("Interrupting task " + oid + " running at " + this.getClusterManager().dumpNodeInfo(nodeInfo));
        NodeType node = (NodeType)nodeInfo.getNodeType().asObjectable();
        String nodeName = node.getNodeIdentifier();
        String address = String.valueOf(node.getHostname()) + ":" + node.getJmxPort();
        JMXConnector connector = null;
        try {
            try {
                connector = this.connectViaJmx(address);
                mbsc = connector.getMBeanServerConnection();
            }
            catch (IOException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot connect to the remote node {} at {}", (Throwable)e, (Object[])new Object[]{nodeName, address});
                result.recordFatalError("Cannot connect to the remote node " + nodeName + " at " + address + ": " + e.getMessage(), (Throwable)e);
                try {
                    if (connector != null) {
                        connector.close();
                    }
                }
                catch (IOException e2) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e2, (Object[])new Object[]{address});
                }
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (connector != null) {
                    connector.close();
                }
            }
            catch (IOException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
            }
            throw throwable;
        }
        try {
            QuartzSchedulerMBean mbeanProxy = this.getMBeanProxy(nodeName, mbsc);
            if (mbeanProxy != null) {
                mbeanProxy.interruptJob(oid, "DEFAULT");
                result.recordSuccessIfUnknown();
            } else {
                result.recordFatalError("Cannot interrupt job at " + nodeName + " at " + address + " because the JMX object for scheduler cannot be found on that node.");
            }
            LOGGER.debug("Successfully signalled shutdown to task " + oid + " running at " + this.getClusterManager().dumpNodeInfo(nodeInfo));
        }
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot signal task {} interruption to remote node {} at {}", (Throwable)e, (Object[])new Object[]{oid, nodeName, address});
        }
        try {
            if (connector != null) {
                connector.close();
            }
        }
        catch (IOException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close JMX connection to {}", (Throwable)e, (Object[])new Object[]{address});
        }
    }

    private ClusterManager getClusterManager() {
        return this.taskManager.getClusterManager();
    }
}

