/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.repo.sql.SqlRepositoryConfiguration;
import com.evolveum.midpoint.task.api.TaskManagerConfigurationException;
import com.evolveum.midpoint.task.api.UseThreadInterrupt;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class TaskManagerConfiguration {
    private static final transient Trace LOGGER = TraceManager.getTrace(TaskManagerConfiguration.class);
    private static final String TASK_MANAGER_CONFIG_SECTION = "midpoint.taskManager";
    private static final String STOP_ON_INITIALIZATION_FAILURE_CONFIG_ENTRY = "stopOnInitializationFailure";
    private static final String THREADS_CONFIG_ENTRY = "threads";
    private static final String CLUSTERED_CONFIG_ENTRY = "clustered";
    private static final String JDBC_JOB_STORE_CONFIG_ENTRY = "jdbcJobStore";
    private static final String JDBC_DRIVER_CONFIG_ENTRY = "jdbcDriver";
    private static final String JDBC_URL_CONFIG_ENTRY = "jdbcUrl";
    private static final String JDBC_USER_CONFIG = "jdbcUser";
    private static final String JDBC_PASSWORD_CONFIG = "jdbcPassword";
    private static final String SQL_SCHEMA_FILE_CONFIG_ENTRY = "sqlSchemaFile";
    private static final String JDBC_DRIVER_DELEGATE_CLASS_CONFIG_ENTRY = "jdbcDriverDelegateClass";
    private static final String USE_THREAD_INTERRUPT_CONFIG_ENTRY = "useThreadInterrupt";
    private static final String JMX_CONNECT_TIMEOUT_CONFIG_ENTRY = "jmxConnectTimeout";
    private static final String QUARTZ_NODE_REGISTRATION_CYCLE_TIME_CONFIG_ENTRY = "quartzNodeRegistrationCycleTime";
    private static final String NODE_REGISTRATION_CYCLE_TIME_CONFIG_ENTRY = "nodeRegistrationCycleTime";
    private static final String NODE_TIMEOUT_CONFIG_ENTRY = "nodeTimeout";
    private static final String JMX_USERNAME_CONFIG_ENTRY = "jmxUsername";
    private static final String JMX_PASSWORD_CONFIG_ENTRY = "jmxPassword";
    private static final String MIDPOINT_NODE_ID_PROPERTY = "midpoint.nodeId";
    private static final String MIDPOINT_JMX_HOST_NAME_PROPERTY = "midpoint.jmxHostName";
    private static final String JMX_PORT_PROPERTY = "com.sun.management.jmxremote.port";
    private static final String SUREFIRE_PRESENCE_PROPERTY = "surefire.real.class.path";
    private static final boolean STOP_ON_INITIALIZATION_FAILURE_DEFAULT = true;
    private static final int THREADS_DEFAULT = 10;
    private static final boolean CLUSTERED_DEFAULT = false;
    private static final String NODE_ID_DEFAULT = "DefaultNode";
    private static final int JMX_PORT_DEFAULT = 20001;
    private static final int JMX_CONNECT_TIMEOUT_DEFAULT = 5;
    private static final String USE_THREAD_INTERRUPT_DEFAULT = "whenNecessary";
    private static final int QUARTZ_NODE_REGISTRATION_CYCLE_TIME_DEFAULT = 10;
    private static final int NODE_REGISTRATION_CYCLE_TIME_DEFAULT = 10;
    private static final int NODE_TIMEOUT_DEFAULT = 30;
    private static final String JMX_USERNAME_DEFAULT = "midpoint";
    private static final String JMX_PASSWORD_DEFAULT = "secret";
    private boolean stopOnInitializationFailure;
    private int threads;
    private boolean jdbcJobStore;
    private boolean clustered;
    private String nodeId;
    private String jmxHostName;
    private int jmxPort;
    private int jmxConnectTimeout;
    private int quartzNodeRegistrationCycleTime;
    private int nodeRegistrationCycleTime;
    private int nodeTimeout;
    private UseThreadInterrupt useThreadInterrupt;
    private String jmxUsername;
    private String jmxPassword;
    private String sqlSchemaFile;
    private String jdbcDriverDelegateClass;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String hibernateDialect;
    private boolean databaseIsEmbedded;
    private boolean midPointTestMode = false;
    private static final Map<String, String> schemas = new HashMap<String, String>();
    private static final Map<String, String> delegates = new HashMap<String, String>();

    static {
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.H2Dialect", "tables_h2.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.PostgreSQLDialect", "tables_postgres.sql", "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.MySQLDialect", "tables_mysql.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.MySQLInnoDBDialect", "tables_mysql_innodb.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.OracleDialect", "tables_oracle.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.Oracle9Dialect", "tables_oracle.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.Oracle8iDialect", "tables_oracle.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.Oracle9iDialect", "tables_oracle.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.Oracle10gDialect", "tables_oracle.sql", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        TaskManagerConfiguration.addDbInfo("org.hibernate.dialect.SQLServerDialect", "tables_sqlServer.sql", "org.quartz.impl.jdbcjobstore.MSSQLDelegate");
    }

    void setBasicInformation(MidpointConfiguration masterConfig) throws TaskManagerConfigurationException {
        Configuration c = masterConfig.getConfiguration(TASK_MANAGER_CONFIG_SECTION);
        this.stopOnInitializationFailure = c.getBoolean(STOP_ON_INITIALIZATION_FAILURE_CONFIG_ENTRY, true);
        this.threads = c.getInt(THREADS_CONFIG_ENTRY, 10);
        this.clustered = c.getBoolean(CLUSTERED_CONFIG_ENTRY, false);
        this.jdbcJobStore = c.getBoolean(JDBC_JOB_STORE_CONFIG_ENTRY, this.clustered);
        this.nodeId = System.getProperty(MIDPOINT_NODE_ID_PROPERTY);
        if (StringUtils.isEmpty((String)this.nodeId) && !this.clustered) {
            this.nodeId = NODE_ID_DEFAULT;
        }
        this.jmxHostName = System.getProperty(MIDPOINT_JMX_HOST_NAME_PROPERTY);
        String portString = System.getProperty(JMX_PORT_PROPERTY);
        if (StringUtils.isEmpty((String)portString)) {
            this.jmxPort = 20001;
        } else {
            try {
                this.jmxPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException nfe) {
                throw new TaskManagerConfigurationException("Cannot get JMX management port - invalid integer value of " + portString, (Throwable)nfe);
            }
        }
        this.jmxConnectTimeout = c.getInt(JMX_CONNECT_TIMEOUT_CONFIG_ENTRY, 5);
        Properties sp = System.getProperties();
        if (sp.containsKey(SUREFIRE_PRESENCE_PROPERTY)) {
            LOGGER.info("Determined to run in a test environment, setting midPointTestMode to 'true'.");
            this.midPointTestMode = true;
        }
        String useTI = c.getString(USE_THREAD_INTERRUPT_CONFIG_ENTRY, USE_THREAD_INTERRUPT_DEFAULT);
        try {
            this.useThreadInterrupt = UseThreadInterrupt.fromValue((String)useTI);
        }
        catch (IllegalArgumentException e) {
            throw new TaskManagerConfigurationException("Illegal value for useThreadInterrupt: " + useTI, (Throwable)e);
        }
        this.quartzNodeRegistrationCycleTime = c.getInt(QUARTZ_NODE_REGISTRATION_CYCLE_TIME_CONFIG_ENTRY, 10);
        this.nodeRegistrationCycleTime = c.getInt(NODE_REGISTRATION_CYCLE_TIME_CONFIG_ENTRY, 10);
        this.nodeTimeout = c.getInt(NODE_TIMEOUT_CONFIG_ENTRY, 30);
        this.jmxUsername = c.getString(JMX_USERNAME_CONFIG_ENTRY, JMX_USERNAME_DEFAULT);
        this.jmxPassword = c.getString(JMX_PASSWORD_CONFIG_ENTRY, JMX_PASSWORD_DEFAULT);
    }

    static void addDbInfo(String dialect, String schema, String delegate) {
        schemas.put(dialect, schema);
        delegates.put(dialect, delegate);
    }

    void setJdbcJobStoreInformation(MidpointConfiguration masterConfig, SqlRepositoryConfiguration sqlConfig) {
        Configuration c = masterConfig.getConfiguration(TASK_MANAGER_CONFIG_SECTION);
        this.jdbcDriver = c.getString(JDBC_DRIVER_CONFIG_ENTRY, sqlConfig != null ? sqlConfig.getDriverClassName() : null);
        this.jdbcUrl = c.getString(JDBC_URL_CONFIG_ENTRY, sqlConfig != null ? sqlConfig.getJdbcUrl() : null);
        this.jdbcUser = c.getString(JDBC_USER_CONFIG, sqlConfig != null ? sqlConfig.getJdbcUsername() : null);
        this.jdbcPassword = c.getString(JDBC_PASSWORD_CONFIG, sqlConfig != null ? sqlConfig.getJdbcPassword() : null);
        this.hibernateDialect = sqlConfig != null ? sqlConfig.getHibernateDialect() : "";
        String defaultSqlSchemaFile = schemas.get(this.hibernateDialect);
        String defaultDriverDelegate = delegates.get(this.hibernateDialect);
        this.sqlSchemaFile = c.getString(SQL_SCHEMA_FILE_CONFIG_ENTRY, defaultSqlSchemaFile);
        this.jdbcDriverDelegateClass = c.getString(JDBC_DRIVER_DELEGATE_CLASS_CONFIG_ENTRY, defaultDriverDelegate);
    }

    void validateBasicInformation() throws TaskManagerConfigurationException {
        if (this.threads < 1) {
            LOGGER.warn("The configured number of threads is too low, setting it to 5.");
            this.threads = 5;
        }
        if (this.clustered) {
            this.mustBeTrue(this.jdbcJobStore, "Clustered task manager requires JDBC Quartz job store.");
        }
        this.notEmpty(this.nodeId, "Node identifier must be set when run in clustered mode.");
        this.mustBeFalse(this.clustered && this.jmxPort == 0, "JMX port number must be known when run in clustered mode.");
        this.mustBeTrue(this.quartzNodeRegistrationCycleTime > 1 && this.quartzNodeRegistrationCycleTime <= 600, "Quartz node registration cycle time must be between 1 and 600 seconds");
        this.mustBeTrue(this.nodeRegistrationCycleTime > 1 && this.nodeRegistrationCycleTime <= 600, "Node registration cycle time must be between 1 and 600 seconds");
        this.mustBeTrue(this.nodeTimeout > 5 && this.nodeTimeout <= 3600, "Node timeout must be between 5 and 3600 seconds");
    }

    void validateJdbcJobStoreInformation() throws TaskManagerConfigurationException {
        this.notEmpty(this.jdbcDriver, "JDBC driver must be specified (either explicitly or in SQL repository configuration)");
        this.notEmpty(this.jdbcUrl, "JDBC URL must be specified (either explicitly or in SQL repository configuration).");
        this.notNull(this.jdbcUser, "JDBC user name must be specified (either explicitly or in SQL repository configuration).");
        this.notNull(this.jdbcPassword, "JDBC password must be specified (either explicitly or in SQL repository configuration).");
        this.notEmpty(this.jdbcDriverDelegateClass, "JDBC driver delegate class must be specified (either explicitly or through one of supported Hibernate dialects).");
        this.notEmpty(this.sqlSchemaFile, "SQL schema file must be specified (either explicitly or through one of supported Hibernate dialects).");
    }

    private void notEmpty(String value, String message) throws TaskManagerConfigurationException {
        if (StringUtils.isEmpty((String)value)) {
            throw new TaskManagerConfigurationException(message);
        }
    }

    private void notNull(String value, String message) throws TaskManagerConfigurationException {
        if (value == null) {
            throw new TaskManagerConfigurationException(message);
        }
    }

    private void mustBeTrue(boolean condition, String message) throws TaskManagerConfigurationException {
        if (!condition) {
            throw new TaskManagerConfigurationException(message);
        }
    }

    private void mustBeFalse(boolean condition, String message) throws TaskManagerConfigurationException {
        if (condition) {
            throw new TaskManagerConfigurationException(message);
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public boolean isJdbcJobStore() {
        return this.jdbcJobStore;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public String getSqlSchemaFile() {
        return this.sqlSchemaFile;
    }

    public String getJdbcDriverDelegateClass() {
        return this.jdbcDriverDelegateClass;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public boolean isTestMode() {
        return this.midPointTestMode;
    }

    public UseThreadInterrupt getUseThreadInterrupt() {
        return this.useThreadInterrupt;
    }

    public int getJmxConnectTimeout() {
        return this.jmxConnectTimeout;
    }

    public boolean isStopOnInitializationFailure() {
        return this.stopOnInitializationFailure;
    }

    public boolean isDatabaseIsEmbedded() {
        return this.databaseIsEmbedded;
    }

    public int getNodeTimeout() {
        return this.nodeTimeout;
    }

    public int getNodeRegistrationCycleTime() {
        return this.nodeRegistrationCycleTime;
    }

    public int getQuartzNodeRegistrationCycleTime() {
        return this.quartzNodeRegistrationCycleTime;
    }

    public String getJmxUsername() {
        return this.jmxUsername;
    }

    public String getJmxPassword() {
        return this.jmxPassword;
    }

    public String getJmxHostName() {
        return this.jmxHostName;
    }
}

