/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.ListIterator;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.CommandParser;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Replace;
import org.basex.query.QueryException;
import org.basex.server.LocalQuery;
import org.basex.server.Query;
import org.basex.server.Session;
import org.basex.util.Util;
import org.xml.sax.InputSource;

public final class LocalSession
extends Session {
    private final Context ctx;
    private final LinkedList<LocalQuery> queries;

    public LocalSession(Context context) {
        this(context, null);
    }

    public LocalSession(Context context, OutputStream output) {
        super(output);
        this.ctx = new Context(context, null);
        this.ctx.user = context.user;
        this.queries = new LinkedList();
    }

    @Override
    public void create(String name, InputStream input) throws BaseXException {
        this.info = CreateDB.create(name, input, this.ctx);
    }

    @Override
    public void add(String name, String target, InputStream input) throws BaseXException {
        this.info = Add.add(name, target, new InputSource(input), this.ctx, null, true);
    }

    @Override
    public void replace(String path, InputStream input) throws BaseXException {
        this.info = Replace.replace(path, new InputSource(input), this.ctx, true);
    }

    @Override
    public Query query(String query) throws BaseXException {
        LocalQuery q = this.out == null ? new LocalQuery(this, query, this.ctx) : new LocalQuery(this, query, this.ctx, this.out);
        this.queries.add(q);
        return q;
    }

    @Override
    public void close() {
        try {
            ListIterator i = this.queries.listIterator();
            while (i.hasNext()) {
                ((LocalQuery)i.next()).closeListener();
                i.remove();
            }
        }
        catch (BaseXException ex) {
            Util.debug(ex);
        }
    }

    @Override
    protected void execute(String str, OutputStream os) throws BaseXException {
        try {
            this.execute(new CommandParser(str, this.ctx).parseSingle(), os);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    protected void execute(Command cmd, OutputStream os) throws BaseXException {
        cmd.execute(this.ctx, os);
        this.info = cmd.info();
    }

    void removeQuery(LocalQuery q) {
        this.queries.remove(q);
    }
}

