/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.query.QueryContext;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.DBNodeSeq;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.Test;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

final class DocTest
extends Test {
    final Nodes nodes;

    private DocTest(Nodes n) {
        this.type = NodeType.DOC;
        this.nodes = n;
    }

    static Test get(QueryContext ctx, Data data) {
        Item it;
        if (data.single()) {
            return Test.DOC;
        }
        if (ctx.value instanceof DBNodeSeq) {
            DBNodeSeq seq = (DBNodeSeq)ctx.value;
            if (seq.complete) {
                return Test.DOC;
            }
            return new DocTest(new Nodes(seq.pres, data));
        }
        IntList il = new IntList((int)ctx.value.size());
        ValueIter ir = ctx.value.iter();
        while ((it = ir.next()) != null) {
            il.add(((DBNode)it).pre);
        }
        return new DocTest(new Nodes(il.toArray(), data));
    }

    @Override
    public boolean eval(ANode node) {
        if (node.type != this.type || !(node instanceof DBNode)) {
            return false;
        }
        DBNode db = (DBNode)node;
        return this.nodes.data == db.data && this.nodes.contains(db.pre);
    }

    public String toString() {
        return new TokenBuilder(NodeType.DOC.nam()).add("(...)").toString();
    }
}

