/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Date;
import org.basex.query.item.Dur;
import org.basex.query.item.Item;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class DTd
extends Dur {
    private static final Pattern DUR = Pattern.compile("(-?)P(([0-9]+)D)?(T(([0-9]+)H)?(([0-9]+)M)?(([0-9]+(\\.[0-9]+)?)?S)?)?");

    DTd(Dur d) {
        super(AtomType.DTD);
        this.sc = d.sc == null ? BigDecimal.valueOf(0L) : d.sc;
    }

    public DTd(int shift) {
        super(AtomType.DTD);
        this.sc = BigDecimal.valueOf((long)shift * 60L);
    }

    public DTd(DTd it, DTd a, boolean p) {
        this(it);
        this.sc = p ? this.sc.add(a.sc) : this.sc.subtract(a.sc);
    }

    public DTd(Dur it, double f, boolean m, InputInfo ii) throws QueryException {
        this(it);
        if (Double.isNaN(f)) {
            Err.DATECALC.thrw(ii, this.desc(), f);
        }
        if (m ? f == Double.POSITIVE_INFINITY || f == Double.NEGATIVE_INFINITY : f == 0.0) {
            Err.DATEZERO.thrw(ii, this.desc());
        }
        this.sc = this.sc.multiply(BigDecimal.valueOf(m ? f : 1.0 / f));
        if (Math.abs(this.sc.doubleValue()) < 1.0E-13) {
            this.sc = BigDecimal.valueOf(0L);
        }
    }

    public DTd(Date dat, Date sub) {
        super(AtomType.DTD);
        long d1 = dat.days();
        BigDecimal s1 = dat.seconds();
        long d2 = sub.days();
        BigDecimal s2 = sub.seconds();
        this.sc = BigDecimal.valueOf((d1 - d2) * 86400L).add(s1.subtract(s2));
    }

    DTd(byte[] v, InputInfo ii) throws QueryException {
        super(AtomType.DTD);
        String val = Token.string(v).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || val.endsWith("P") || val.endsWith("T")) {
            this.dateErr(v, "P23DT12M34S", ii);
        }
        long d = mt.group(2) != null ? Token.toInt(mt.group(3)) : 0;
        long h = mt.group(5) != null ? Token.toInt(mt.group(6)) : 0;
        long n = mt.group(7) != null ? Token.toInt(mt.group(8)) : 0;
        double s = mt.group(9) != null ? Token.toDouble(Token.token(mt.group(10))) : 0.0;
        this.sc = BigDecimal.valueOf(d * 86400L + h * 3600L + n * 60L);
        this.sc = this.sc.add(BigDecimal.valueOf(s));
        if (!mt.group(1).isEmpty()) {
            this.sc = this.sc.negate();
        }
    }

    public BigDecimal dtd() {
        return this.sc;
    }

    @Override
    public byte[] atom(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        if (this.sc.signum() < 0) {
            tb.add(45);
        }
        tb.add(80);
        if (this.day() != 0L) {
            tb.addLong(Math.abs(this.day()));
            tb.add(68);
        }
        if (this.sc.remainder(BigDecimal.valueOf(86400L)).signum() != 0) {
            tb.add(84);
            if (this.hou() != 0L) {
                tb.addLong(Math.abs(this.hou()));
                tb.add(72);
            }
            if (this.min() != 0L) {
                tb.addLong(Math.abs(this.min()));
                tb.add(77);
            }
            if (this.sec().signum() != 0) {
                tb.add(this.sc());
                tb.add(83);
            }
        }
        if (this.sc.signum() == 0) {
            tb.add("T0S");
        }
        return tb.finish();
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        if (it.type != this.type) {
            Err.diff(ii, it, this);
        }
        return this.sc.subtract(((Dur)it).sc).signum();
    }
}

