/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.SortedMap;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.io.serial.SerializerProp;

public final class DialogExport
extends Dialog {
    private static final String[] ENCODINGS;
    private final BaseXTextField path;
    private final BaseXLabel info;
    private final BaseXLabel out;
    private final BaseXCheckBox format;
    private final BaseXCombo encoding;
    private final BaseXBack buttons;

    static {
        SortedMap<String, Charset> cs = Charset.availableCharsets();
        ENCODINGS = cs.keySet().toArray(new String[cs.size()]);
    }

    public DialogExport(GUI main) {
        super(main, Text.GUIEXPORT);
        String s;
        BaseXBack pp = new BaseXBack(new TableLayout(3, 1, 0, 4));
        BaseXBack p = new BaseXBack(new TableLayout(2, 2, 8, 0));
        this.out = new BaseXLabel(String.valueOf(Text.OUTDIR) + ":", true, true).border(0, 0, 4, 0);
        p.add(this.out);
        p.add(new BaseXLabel());
        String dir = new IOFile(this.gui.context.data.meta.original).dir();
        this.path = new BaseXTextField(dir, this);
        this.path.addKeyListener(this.keys);
        p.add(this.path);
        BaseXButton browse = new BaseXButton(Text.BUTTONBROWSE, this);
        browse.setMnemonic();
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogExport.this.choose();
            }
        });
        p.add(browse);
        pp.add(p);
        p = new BaseXBack(new TableLayout(2, 1));
        p.add(new BaseXLabel(String.valueOf(Text.INFOENCODING) + ":", true, true).border(0, 0, 4, 0));
        Prop prop = this.gui.context.prop;
        SerializerProp sp = null;
        try {
            sp = new SerializerProp(prop.get(Prop.EXPORTER));
        }
        catch (IOException ex) {
            sp = new SerializerProp();
        }
        this.encoding = new BaseXCombo(this, ENCODINGS);
        String enc = this.gui.context.data.meta.encoding;
        boolean f = false;
        String[] stringArray = ENCODINGS;
        int n = ENCODINGS.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            f |= s.equals(enc);
            ++n2;
        }
        if (!f) {
            enc = enc.toUpperCase();
            stringArray = ENCODINGS;
            n = ENCODINGS.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                f |= s.equals(enc);
                ++n2;
            }
        }
        this.encoding.setSelectedItem(f ? enc : sp.get(SerializerProp.S_ENCODING));
        this.encoding.addKeyListener(this.keys);
        BaseXLayout.setWidth(this.encoding, 280);
        p.add(this.encoding);
        pp.add(p);
        this.format = new BaseXCheckBox(Text.OUTINDENT, sp.get(SerializerProp.S_INDENT).equals("yes"), 0, this);
        pp.add(this.format);
        this.set(pp, "Center");
        p = new BaseXBack(new BorderLayout());
        this.info = new BaseXLabel(" ").border(18, 0, 0, 0);
        p.add((Component)this.info, "West");
        this.buttons = DialogExport.okCancel(this);
        p.add((Component)this.buttons, "East");
        this.set(p, "South");
        this.action(null);
        this.finish(null);
    }

    static BaseXCombo encoding(Dialog dialog, String encoding) {
        String s;
        BaseXCombo cb = new BaseXCombo(dialog, ENCODINGS);
        boolean f = false;
        String enc = encoding;
        String[] stringArray = ENCODINGS;
        int n = ENCODINGS.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            f |= s.equals(enc);
            ++n2;
        }
        if (!f) {
            enc = enc.toUpperCase();
            stringArray = ENCODINGS;
            n = ENCODINGS.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray[n2];
                f |= s.equals(enc);
                ++n2;
            }
        }
        cb.setSelectedItem(enc);
        cb.addKeyListener(dialog.keys);
        return cb;
    }

    void choose() {
        IOFile io = new BaseXFileChooser(Text.DIALOGFC, this.path.getText(), this.gui).select(BaseXFileChooser.Mode.DOPEN);
        if (io != null) {
            this.path.setText(io.path());
        }
    }

    public String path() {
        return this.path.getText().trim();
    }

    @Override
    public void action(Object cmp) {
        IOFile io = new IOFile(this.path());
        this.ok = !this.path().isEmpty();
        this.info.setText(io.children().length > 0 ? Text.OVERFILE : null, this.ok ? GUIConstants.Msg.WARN : GUIConstants.Msg.ERROR);
        DialogExport.enableOK(this.buttons, Text.BUTTONOK, this.ok);
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        boolean indent = this.format.isSelected();
        this.gui.set(Prop.EXPORTER, SerializerProp.S_INDENT[0] + "=" + (indent ? "yes" : "no") + "," + SerializerProp.S_ENCODING[0] + "=" + this.encoding.getSelectedItem() + "," + SerializerProp.S_OMIT_XML_DECLARATION[0] + "=" + "no");
    }
}

