/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.index.IndexToken;
import org.basex.util.Util;

public final class DropIndex
extends ACreate {
    public DropIndex(Object type) {
        super(514, type.toString());
    }

    @Override
    protected boolean run() {
        Data data = this.context.data;
        if (data instanceof MemData) {
            return this.error(Text.PROCMM, new Object[0]);
        }
        Commands.CmdIndex ci = this.getOption(Commands.CmdIndex.class);
        if (ci == null) {
            return this.error(Text.CMDUNKNOWN, this);
        }
        switch (ci) {
            case TEXT: {
                data.meta.textindex = false;
                return this.drop(IndexToken.IndexType.TEXT, "txt");
            }
            case ATTRIBUTE: {
                data.meta.attrindex = false;
                return this.drop(IndexToken.IndexType.ATTRIBUTE, "atv");
            }
            case FULLTEXT: {
                data.meta.ftindex = false;
                return this.drop(IndexToken.IndexType.FULLTEXT, "ftx");
            }
            case PATH: {
                data.meta.pathindex = false;
                data.pthindex.init();
                data.meta.dirty = true;
                data.flush();
                return this.info(Text.INDDROP, this.perf);
            }
        }
        return false;
    }

    private boolean drop(IndexToken.IndexType index, String pat) {
        try {
            Data data = this.context.data;
            data.closeIndex(index);
            data.meta.dirty = true;
            data.flush();
            return data.meta.drop(String.valueOf(pat) + '.') ? this.info(Text.INDDROP, new Object[]{index, this.perf}) : this.error(Text.INDDROPERROR, new Object[]{index});
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.INDEX)).args();
    }
}

