/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricScopeInstanceEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.ClockUtil;

public class HistoricTaskInstanceEntity
extends HistoricScopeInstanceEntity
implements HistoricTaskInstance,
PersistentObject {
    protected String executionId;
    protected String name;
    protected String parentTaskId;
    protected String description;
    protected String owner;
    protected String assignee;
    protected String taskDefinitionKey;
    protected int priority;
    protected Date dueDate;

    public HistoricTaskInstanceEntity() {
    }

    public HistoricTaskInstanceEntity(TaskEntity task, ExecutionEntity execution) {
        this.id = task.getId();
        if (execution != null) {
            this.processDefinitionId = execution.getProcessDefinitionId();
            this.processInstanceId = execution.getProcessInstanceId();
            this.executionId = execution.getId();
        }
        this.name = task.getName();
        this.parentTaskId = task.getParentTaskId();
        this.description = task.getDescription();
        this.owner = task.getOwner();
        this.assignee = task.getAssignee();
        this.startTime = ClockUtil.getCurrentTime();
        this.taskDefinitionKey = task.getTaskDefinitionKey();
        this.setPriority(task.getPriority());
    }

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("name", this.name);
        persistentState.put("owner", this.owner);
        persistentState.put("assignee", this.assignee);
        persistentState.put("endTime", this.endTime);
        persistentState.put("durationInMillis", this.durationInMillis);
        persistentState.put("description", this.description);
        persistentState.put("deleteReason", this.deleteReason);
        persistentState.put("taskDefinitionKey", this.taskDefinitionKey);
        persistentState.put("priority", this.priority);
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.dueDate != null) {
            persistentState.put("dueDate", this.dueDate);
        }
        return persistentState;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }
}

