/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.form.AbstractFormType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumFormType
extends AbstractFormType {
    protected Map<String, String> values;

    public EnumFormType(Map<String, String> values) {
        this.values = values;
    }

    @Override
    public String getName() {
        return "enum";
    }

    @Override
    public Object getInformation(String key) {
        if (key.equals("values")) {
            return this.values;
        }
        return null;
    }

    @Override
    public Object convertFormValueToModelValue(String propertyValue) {
        this.validateValue(propertyValue);
        return propertyValue;
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue != null) {
            if (!(modelValue instanceof String)) {
                throw new ActivitiException("Model value should be a String");
            }
            this.validateValue((String)modelValue);
        }
        return null;
    }

    protected void validateValue(String value) {
        if (value != null && this.values != null && !this.values.containsKey(value)) {
            throw new ActivitiException("Invalid value for enum form property: " + value);
        }
    }
}

