/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnActivityBehavior {
    private static Logger log = Logger.getLogger(BpmnActivityBehavior.class.getName());

    public void performDefaultOutgoingBehavior(ActivityExecution activityExceution) {
        this.performOutgoingBehavior(activityExceution, true, false, null);
    }

    public void performIgnoreConditionsOutgoingBehavior(ActivityExecution activityExecution) {
        this.performOutgoingBehavior(activityExecution, false, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performOutgoingBehavior(ActivityExecution execution, boolean checkConditions, boolean throwExceptionIfExecutionStuck, List<ActivityExecution> reusableExecutions) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Leaving activity '" + execution.getActivity().getId() + "'");
        }
        String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
        ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        for (PvmTransition outgoingTransition : outgoingTransitions) {
            Condition condition;
            if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && checkConditions && !condition.evaluate(execution)) continue;
            transitionsToTake.add(outgoingTransition);
        }
        if (transitionsToTake.size() == 1) {
            execution.take((PvmTransition)transitionsToTake.get(0));
            return;
        } else if (transitionsToTake.size() >= 1) {
            execution.inactivate();
            if (reusableExecutions == null || reusableExecutions.isEmpty()) {
                execution.takeAll(transitionsToTake, Arrays.asList(execution));
                return;
            } else {
                execution.takeAll(transitionsToTake, reusableExecutions);
            }
            return;
        } else if (defaultSequenceFlow != null) {
            PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
            if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' could not be not found");
            execution.take(defaultTransition);
            return;
        } else {
            Object isForCompensation = execution.getActivity().getProperty("isForCompensation");
            if (isForCompensation != null && ((Boolean)isForCompensation).booleanValue()) {
                InterpretableExecution parentExecution = (InterpretableExecution)execution.getParent();
                ((InterpretableExecution)execution).remove();
                parentExecution.signal("compensationDone", null);
                return;
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No outgoing sequence flow found for " + execution.getActivity().getId() + ". Ending execution.");
                }
                execution.end();
                if (!throwExceptionIfExecutionStuck) return;
                throw new ActivitiException("No outgoing sequence flow of the inclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
            }
        }
    }
}

