/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MicroMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_ENTRIES = 1;
    private K key;
    private V value;

    public MicroMap() {
    }

    public MicroMap(K key, V value) {
        this.put(key, value);
    }

    public boolean isFull() {
        return this.size() == 1;
    }

    @Override
    public int size() {
        return this.key != null ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return key.equals(this.key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value.equals(this.value);
    }

    @Override
    public V get(Object key) {
        if (key.equals(this.key)) {
            return this.value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key.equals(this.key)) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
        if (this.size() < 1) {
            this.key = key;
            this.value = value;
            return null;
        }
        throw new IllegalStateException("Map full");
    }

    @Override
    public V remove(Object key) {
        if (key.equals(this.key)) {
            V oldValue = this.value;
            this.key = null;
            this.value = null;
            return oldValue;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map.size() > 1) {
            throw new IllegalStateException("Map full.  Cannot add " + map.size() + " entries");
        }
        Map.Entry<K, V> e = map.entrySet().iterator().next();
        this.put(e.getKey(), e.getValue());
    }

    @Override
    public void clear() {
        this.key = null;
        this.value = null;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < MicroMap.this.size();
                    }

                    @Override
                    public K next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return MicroMap.this.key;
                    }

                    @Override
                    public void remove() {
                        MicroMap.this.clear();
                    }
                };
            }

            @Override
            public int size() {
                return MicroMap.this.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                if (index > this.size() - 1) {
                    throw new IndexOutOfBoundsException();
                }
                return MicroMap.this.value;
            }

            @Override
            public int size() {
                return MicroMap.this.size();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MicroMap.this.size();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.index;
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return MicroMap.this.key;
                            }

                            @Override
                            public V getValue() {
                                return MicroMap.this.value;
                            }

                            @Override
                            public V setValue(V value) {
                                Object oldValue = MicroMap.this.value;
                                MicroMap.this.value = value;
                                return oldValue;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.clear();
                    }
                };
            }

            @Override
            public int size() {
                return MicroMap.this.size();
            }
        };
    }
}

