/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.util;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.provisioning.ucf.impl.ConnectorFactoryIcfImpl;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.holder.XPathSegment;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainer;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ActivationCapabilityType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShadowCacheUtil {
    private static final Trace LOGGER = TraceManager.getTrace(ShadowCacheUtil.class);

    public static <T extends ResourceObjectShadowType> T completeShadow(T resourceShadow, T repoShadow, ResourceType resource, OperationResult parentResult) throws SchemaException {
        if (repoShadow == null) {
            PrismObject repoPrism = resourceShadow.asPrismObject().clone();
            repoShadow = (ResourceObjectShadowType)repoPrism.asObjectable();
        }
        ResourceAttributeContainer resourceAttributesContainer = ResourceObjectShadowUtil.getAttributesContainer(resourceShadow);
        ResourceAttributeContainer repoAttributesContainer = ResourceObjectShadowUtil.getAttributesContainer(repoShadow);
        if (repoShadow.getObjectClass() == null) {
            repoShadow.setObjectClass(resourceAttributesContainer.getDefinition().getTypeName());
        }
        if (repoShadow.getName() == null) {
            repoShadow.setName(ShadowCacheUtil.determineShadowName(resourceShadow));
        }
        if (repoShadow.getResource() == null) {
            repoShadow.setResourceRef(ObjectTypeUtil.createObjectRef((ObjectType)resource));
        }
        if (repoShadow != resourceShadow) {
            repoAttributesContainer.getValue().clear();
            for (ResourceAttribute resourceAttribute : resourceAttributesContainer.getAttributes()) {
                if (ShadowCacheUtil.isSimulatedActivationAttribute(resourceAttribute, resourceShadow, resource)) continue;
                repoAttributesContainer.add(resourceAttribute);
            }
        }
        if (resourceShadow.getActivation() != null || ResourceTypeUtil.hasActivationCapability((ResourceType)resource)) {
            ActivationType activationType = ShadowCacheUtil.completeActivation(resourceShadow, resource, parentResult);
            LOGGER.trace("Determined activation: {}", activationType == null ? "null activationType" : activationType.isEnabled());
            repoShadow.setActivation(activationType);
        } else {
            repoShadow.setActivation(null);
        }
        if (repoShadow instanceof AccountShadowType) {
            AccountShadowType repoAccountShadow = (AccountShadowType)repoShadow;
            AccountShadowType resourceAccountShadow = (AccountShadowType)resourceShadow;
            repoAccountShadow.setCredentials(resourceAccountShadow.getCredentials());
        }
        repoShadow.asPrismObject().checkConsistence();
        return repoShadow;
    }

    private static boolean isSimulatedActivationAttribute(ResourceAttribute attribute, ResourceObjectShadowType shadow, ResourceType resource) {
        if (!ResourceTypeUtil.hasResourceNativeActivationCapability((ResourceType)resource)) {
            ActivationCapabilityType activationCapability = (ActivationCapabilityType)ResourceTypeUtil.getEffectiveCapability((ResourceType)resource, ActivationCapabilityType.class);
            if (activationCapability == null) {
                return false;
            }
            ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((ResourceObjectShadowType)shadow);
            ResourceAttribute activationProperty = attributesContainer.findAttribute(activationCapability.getEnableDisable().getAttribute());
            if (activationProperty != null && activationProperty.equals((Object)attribute)) {
                return true;
            }
        }
        return false;
    }

    public static <T extends ResourceObjectShadowType> void normalizeShadow(T shadow, OperationResult result) throws SchemaException {
        if (shadow.getAttemptNumber() != null) {
            shadow.setAttemptNumber(null);
        }
        if (shadow.getFailedOperationType() != null) {
            shadow.setFailedOperationType(null);
        }
        if (shadow.getObjectChange() != null) {
            shadow.setObjectChange(null);
        }
        if (shadow.getResult() != null) {
            shadow.setResult(null);
        }
        if (shadow instanceof AccountShadowType && ((AccountShadowType)shadow).getCredentials() != null) {
            ((AccountShadowType)shadow).setCredentials(null);
        }
        ResourceAttributeContainer normalizedContainer = ResourceObjectShadowUtil.getAttributesContainer(shadow);
        ResourceAttributeContainer oldContainer = normalizedContainer.clone();
        normalizedContainer.clear();
        Collection identifiers = oldContainer.getIdentifiers();
        for (PrismProperty p : identifiers) {
            normalizedContainer.getValue().add((Item)p);
        }
        Collection secondaryIdentifiers = oldContainer.getSecondaryIdentifiers();
        for (PrismProperty p : secondaryIdentifiers) {
            normalizedContainer.getValue().add((Item)p);
        }
    }

    public static ActivationType completeActivation(ResourceObjectShadowType shadow, ResourceType resource, OperationResult parentResult) {
        if (resource == null) {
            return shadow.getActivation();
        }
        if (ResourceTypeUtil.hasResourceNativeActivationCapability((ResourceType)resource)) {
            return shadow.getActivation();
        }
        if (ResourceTypeUtil.hasActivationCapability((ResourceType)resource)) {
            return ShadowCacheUtil.convertFromSimulatedActivationAttributes(shadow, resource, parentResult);
        }
        return null;
    }

    private static ActivationType convertFromSimulatedActivationAttributes(ResourceObjectShadowType shadow, ResourceType resource, OperationResult parentResult) {
        ActivationCapabilityType activationCapability = (ActivationCapabilityType)ResourceTypeUtil.getEffectiveCapability((ResourceType)resource, ActivationCapabilityType.class);
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((ResourceObjectShadowType)shadow);
        ResourceAttribute activationProperty = attributesContainer.findAttribute(activationCapability.getEnableDisable().getAttribute());
        Collection values = null;
        if (activationProperty != null) {
            values = activationProperty.getRealValues(Object.class);
        }
        ActivationType activation = ShadowCacheUtil.convertFromSimulatedActivationValues(resource, values, parentResult);
        LOGGER.debug("Detected simulated activation attribute {} on {} with value {}, resolved into {}", new Object[]{SchemaDebugUtil.prettyPrint((QName)activationCapability.getEnableDisable().getAttribute()), ObjectTypeUtil.toShortString((ObjectType)resource), values, activation == null ? "null" : activation.isEnabled()});
        return activation;
    }

    private static ActivationType convertFromSimulatedActivationAttributes(ResourceType resource, AccountShadowType shadow, OperationResult parentResult) {
        ActivationCapabilityType activationCapability = (ActivationCapabilityType)ResourceTypeUtil.getEffectiveCapability((ResourceType)resource, ActivationCapabilityType.class);
        QName enableDisableAttribute = activationCapability.getEnableDisable().getAttribute();
        List values = ResourceObjectShadowUtil.getAttributeValues((ResourceObjectShadowType)shadow, (QName)enableDisableAttribute);
        ActivationType activation = ShadowCacheUtil.convertFromSimulatedActivationValues(resource, values, parentResult);
        LOGGER.debug("Detected simulated activation attribute {} on {} with value {}, resolved into {}", new Object[]{SchemaDebugUtil.prettyPrint((QName)activationCapability.getEnableDisable().getAttribute()), ObjectTypeUtil.toShortString((ObjectType)resource), values, activation == null ? "null" : activation.isEnabled()});
        return activation;
    }

    private static ActivationType convertFromSimulatedActivationValues(ResourceType resource, Collection<Object> activationValues, OperationResult parentResult) {
        ActivationCapabilityType activationCapability = (ActivationCapabilityType)ResourceTypeUtil.getEffectiveCapability((ResourceType)resource, ActivationCapabilityType.class);
        if (activationCapability == null) {
            return null;
        }
        List disableValues = activationCapability.getEnableDisable().getDisableValue();
        List enableValues = activationCapability.getEnableDisable().getEnableValue();
        ActivationType activationType = new ActivationType();
        if (ShadowCacheUtil.isNoValue(activationValues)) {
            if (ShadowCacheUtil.hasNoValue(disableValues)) {
                activationType.setEnabled(Boolean.valueOf(false));
                return activationType;
            }
            if (ShadowCacheUtil.hasNoValue(enableValues)) {
                activationType.setEnabled(Boolean.valueOf(true));
                return activationType;
            }
            LOGGER.warn("The {} does not provide definition for null value of simulated activation attribute", (Object)ObjectTypeUtil.toShortString((ObjectType)resource));
            if (parentResult != null) {
                parentResult.recordPartialError("The " + ObjectTypeUtil.toShortString((ObjectType)resource) + " has native activation capability but noes not provide value for DISABLE attribute");
            }
            return null;
        }
        if (activationValues.size() > 1) {
            LOGGER.warn("The {} provides {} values for DISABLE attribute, expecting just one value", (Object)disableValues.size(), (Object)ObjectTypeUtil.toShortString((ObjectType)resource));
            if (parentResult != null) {
                parentResult.recordPartialError("The " + ObjectTypeUtil.toShortString((ObjectType)resource) + " provides " + disableValues.size() + " values for DISABLE attribute, expecting just one value");
            }
        }
        Object disableObj = activationValues.iterator().next();
        for (String disable : disableValues) {
            if (!disable.equals(String.valueOf(disableObj))) continue;
            activationType.setEnabled(Boolean.valueOf(false));
            return activationType;
        }
        for (String enable : enableValues) {
            if (!"".equals(enable) && !enable.equals(String.valueOf(disableObj))) continue;
            activationType.setEnabled(Boolean.valueOf(true));
            return activationType;
        }
        return null;
    }

    private static boolean isNoValue(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        if (collection.isEmpty()) {
            return true;
        }
        for (Object val : collection) {
            if (val == null || val instanceof String && ((String)val).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNoValue(Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        if (collection.isEmpty()) {
            return true;
        }
        for (Object val : collection) {
            if (val == null) {
                return true;
            }
            if (!(val instanceof String) || !((String)val).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static String determineShadowName(ResourceObjectShadowType shadow) throws SchemaException {
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((ResourceObjectShadowType)shadow);
        if (attributesContainer.getNamingAttribute() == null) {
            Collection identifiers = attributesContainer.getIdentifiers();
            if (identifiers.size() == 1) {
                PrismPropertyValue value;
                PrismProperty identifier = (PrismProperty)identifiers.iterator().next();
                Collection values = identifier.getValues();
                if (values.size() == 1 && (value = (PrismPropertyValue)values.iterator().next()).getValue() instanceof String) {
                    return (String)value.getValue();
                }
            } else {
                return (String)attributesContainer.findAttribute(ConnectorFactoryIcfImpl.ICFS_NAME).getValue(String.class).getValue();
            }
            throw new SchemaException("No naming attribute defined (and identifier not usable)");
        }
        return (String)attributesContainer.getNamingAttribute().getValue().getValue();
    }

    public static <T extends ResourceObjectShadowType> T createRepositoryShadow(T shadowType, ResourceType resource) throws SchemaException {
        PrismObject shadow = shadowType.asPrismObject();
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((PrismObject)shadow);
        PrismObject repoShadow = shadow.clone();
        ResourceAttributeContainer repoAttributesContainer = ResourceObjectShadowUtil.getAttributesContainer((PrismObject)repoShadow);
        repoAttributesContainer.getValue().clear();
        Collection identifiers = attributesContainer.getIdentifiers();
        for (PrismProperty p : identifiers) {
            repoAttributesContainer.getValue().add((Item)p);
        }
        Collection secondaryIdentifiers = attributesContainer.getSecondaryIdentifiers();
        for (PrismProperty p : secondaryIdentifiers) {
            repoAttributesContainer.getValue().add((Item)p);
        }
        ResourceObjectShadowType repoShadowType = (ResourceObjectShadowType)repoShadow.asObjectable();
        if (repoShadowType instanceof AccountShadowType) {
            ((AccountShadowType)repoShadowType).setCredentials(null);
        }
        if (repoShadowType.getResource() != null) {
            repoShadowType.setResource(null);
            repoShadowType.setResourceRef(ObjectTypeUtil.createObjectRef((ObjectType)resource));
        }
        if (repoShadowType.getResourceRef() == null) {
            repoShadowType.setResourceRef(ObjectTypeUtil.createObjectRef((ObjectType)resource));
        }
        if (repoShadowType.getName() == null) {
            repoShadowType.setName(ShadowCacheUtil.determineShadowName(shadowType));
        }
        if (repoShadowType.getObjectClass() == null) {
            repoShadowType.setObjectClass(attributesContainer.getDefinition().getTypeName());
        }
        return (T)repoShadowType;
    }

    public static QueryType createSearchShadowQuery(Collection<ResourceAttribute<?>> identifiers, PrismContext prismContext, OperationResult parentResult) throws SchemaException {
        Element filter;
        XPathHolder xpath = ShadowCacheUtil.createXpathHolder();
        Document doc = DOMUtil.getDocument();
        ArrayList values = new ArrayList();
        for (PrismProperty prismProperty : identifiers) {
            List elements = prismContext.getPrismDomProcessor().serializeItemToDom((Item)prismProperty, doc);
            values.addAll(elements);
        }
        if (values.size() > 1) {
            throw new UnsupportedOperationException("More than one identifier not supported yet.");
        }
        Object e = values.get(0);
        try {
            filter = QueryUtil.createEqualFilter((Document)doc, (XPathHolder)xpath, e);
        }
        catch (SchemaException e2) {
            parentResult.recordFatalError((Throwable)e2);
            throw e2;
        }
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    public static QueryType createSearchShadowQuery(ResourceObjectShadowType resourceShadow, ResourceType resource, PrismContext prismContext, OperationResult parentResult) throws SchemaException {
        Element filter;
        XPathHolder xpath = ShadowCacheUtil.createXpathHolder();
        ResourceAttributeContainer attributesContainer = ResourceObjectShadowUtil.getAttributesContainer((ResourceObjectShadowType)resourceShadow);
        PrismProperty identifier = attributesContainer.getIdentifier();
        Collection idValues = identifier.getValues();
        if (idValues.size() > 1) {
            throw new IllegalArgumentException("More than one identifier value is not supported");
        }
        if (idValues.size() < 1) {
            throw new IllegalArgumentException("The identifier has no value");
        }
        Document doc = DOMUtil.getDocument();
        List identifierElements = prismContext.getPrismDomProcessor().serializeItemToDom((Item)identifier, doc);
        try {
            filter = QueryUtil.createAndFilter((Document)doc, (Element[])new Element[]{QueryUtil.createEqualRefFilter((Document)doc, null, (QName)SchemaConstants.I_RESOURCE_REF, (String)resource.getOid()), QueryUtil.createEqualFilterFromElements((Document)doc, (XPathHolder)xpath, (List)identifierElements, (PrismContext)resourceShadow.asPrismObject().getPrismContext())});
        }
        catch (SchemaException e) {
            throw new SchemaException("Schema error while creating search filter: " + e.getMessage(), (Throwable)e);
        }
        QueryType query = new QueryType();
        query.setFilter(filter);
        return query;
    }

    private static XPathHolder createXpathHolder() {
        XPathSegment xpathSegment = new XPathSegment(SchemaConstants.I_ATTRIBUTES);
        ArrayList<XPathSegment> xpathSegments = new ArrayList<XPathSegment>();
        xpathSegments.add(xpathSegment);
        XPathHolder xpath = new XPathHolder(xpathSegments);
        return xpath;
    }

    public static PrismObjectDefinition<ResourceObjectShadowType> getResourceObjectShadowDefinition(PrismContext prismContext) {
        return prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(ResourceObjectShadowType.class);
    }
}

