/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf.activiti;

import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.activiti.Activiti2Idm;
import com.evolveum.midpoint.wf.activiti.ActivitiEngine;
import com.evolveum.midpoint.wf.activiti.IdmExecutionListenerProxy;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceStartedEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessVariable;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfQueryProcessInstanceCommandType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfStartProcessInstanceCommandType;
import java.util.HashMap;
import java.util.TreeMap;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.history.HistoricDetailQuery;
import org.activiti.engine.history.HistoricFormProperty;
import org.activiti.engine.history.HistoricVariableUpdate;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Idm2Activiti {
    @Autowired(required=true)
    ActivitiEngine activitiEngine;
    @Autowired(required=true)
    Activiti2Idm activiti2Idm;
    private static final Trace LOGGER = TraceManager.getTrace(Idm2Activiti.class);

    public void idm2activiti(Object o) {
        LOGGER.trace(" *** A message from midPoint has arrived; class = " + o.getClass().getName() + " ***");
        if (o instanceof WfQueryProcessInstanceCommandType) {
            WfQueryProcessInstanceCommandType qpic = (WfQueryProcessInstanceCommandType)o;
            String id = qpic.getWfProcessInstanceId();
            LOGGER.trace("Querying process instance id = " + id);
            HistoryService hs = this.activitiEngine.getHistoryService();
            HistoricDetailQuery hdq = (HistoricDetailQuery)hs.createHistoricDetailQuery().variableUpdates().processInstanceId(id).orderByVariableRevision().desc();
            TreeMap<String, String> variables = new TreeMap<String, String>();
            for (HistoricDetail hd : hdq.list()) {
                HistoricVariableUpdate hvu = (HistoricVariableUpdate)hd;
                String varname = hvu.getVariableName();
                Object value = hvu.getValue();
                String varvalue = value == null ? null : value.toString();
                LOGGER.trace("hvu: " + varname + " <- " + varvalue);
                System.out.println("Variable: " + varname + " <- " + varvalue);
                if (variables.containsKey(varname)) continue;
                variables.put(varname, varvalue);
            }
            HistoricDetailQuery hdq2 = (HistoricDetailQuery)hs.createHistoricDetailQuery().formProperties().processInstanceId(id).orderByVariableRevision().desc();
            for (HistoricDetail hd : hdq2.list()) {
                HistoricFormProperty hfp = (HistoricFormProperty)hd;
                String varname = hfp.getPropertyId();
                String value = hfp.getPropertyValue();
                String varvalue = value == null ? null : value.toString();
                LOGGER.trace("form-property: " + varname + " <- " + varvalue);
                System.out.println("form-property: " + varname + " <- " + varvalue);
                if (variables.containsKey(varname)) continue;
                variables.put(varname, varvalue);
            }
            WfProcessInstanceEventType event = new WfProcessInstanceEventType();
            event.setMidpointTaskOid(qpic.getMidpointTaskOid());
            event.setWfProcessInstanceId(id);
            event.setAnswerToQuery(Boolean.valueOf(true));
            for (String v : variables.keySet()) {
                WfProcessVariable pv = new WfProcessVariable();
                pv.setName(v);
                pv.setValue((String)variables.get(v));
                event.getWfProcessVariable().add(pv);
            }
            LOGGER.trace("Event to be sent to IDM: " + event);
            this.activiti2Idm.onWorkflowMessage(event);
        } else if (o instanceof WfStartProcessInstanceCommandType) {
            WfStartProcessInstanceCommandType spic = (WfStartProcessInstanceCommandType)o;
            HashMap<String, Object> map = new HashMap<String, Object>();
            LOGGER.trace("midpointTaskOid = " + spic.getMidpointTaskOid());
            map.put("midpointTaskOid", spic.getMidpointTaskOid());
            map.put("midpointListener", new IdmExecutionListenerProxy());
            for (WfProcessVariable var : spic.getWfProcessVariable()) {
                LOGGER.trace("process variable: " + var.getName() + " = " + var.getValue());
                map.put(var.getName(), var.getValue());
            }
            LOGGER.trace("process name = " + spic.getWfProcessName());
            RuntimeService rs = ProcessEngines.getDefaultProcessEngine().getRuntimeService();
            ProcessInstance pi = rs.startProcessInstanceByKey(spic.getWfProcessName(), map);
            if (spic.isSendStartConfirmation()) {
                WfProcessInstanceStartedEventType event = new WfProcessInstanceStartedEventType();
                event.setMidpointTaskOid(spic.getMidpointTaskOid());
                event.setWfProcessInstanceId(pi.getProcessInstanceId());
                event.getWfProcessVariable().addAll(spic.getWfProcessVariable());
                LOGGER.info("Event to be sent to IDM: " + event);
                this.activiti2Idm.onWorkflowMessage(event);
            }
        } else {
            String message = "Unknown incoming message type: " + o.getClass().getName();
            LOGGER.error(message);
        }
    }
}

