/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xjc;

import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.Validate;

public abstract class PrismReferenceArrayList<T>
extends AbstractList<T> {
    private PrismReference reference;

    public PrismReferenceArrayList(PrismReference reference) {
        Validate.notNull((Object)reference, (String)"Prism reference must not be null.");
        this.reference = reference;
    }

    protected PrismReference getReference() {
        return this.reference;
    }

    @Override
    public T get(int i) {
        this.testIndex(i);
        return this.createItem(this.getReference().getValues().get(i));
    }

    @Override
    public int size() {
        return this.reference.getValues().size();
    }

    protected abstract T createItem(PrismReferenceValue var1);

    protected abstract PrismReferenceValue getValueFrom(T var1);

    private void testIndex(int i) {
        if (i < 0 || i >= this.getReference().getValues().size()) {
            throw new IndexOutOfBoundsException("Can't get index '" + i + "', values size is '" + this.getReference().getValues().size() + "'.");
        }
    }

    @Override
    public T remove(int i) {
        this.testIndex(i);
        PrismReferenceValue value = this.reference.getValues().get(i);
        this.reference.getValues().remove(i);
        return this.createItem(value);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object object : objects) {
            if (!changed) {
                changed = this.remove(object);
                continue;
            }
            this.remove(object);
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        Object t = o;
        PrismReferenceValue value = this.getValueFrom(t);
        return this.reference.getValues().remove(value);
    }

    @Override
    public boolean add(T t) {
        PrismReferenceValue value = this.getValueFrom(t);
        return this.reference.merge(value);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        boolean changed = false;
        for (T t : ts) {
            if (!changed) {
                changed = this.add(t);
                continue;
            }
            this.add(t);
        }
        return changed;
    }

    @Override
    public void clear() {
        List<PrismReferenceValue> values = this.reference.getValues();
        if (values == null) {
            return;
        }
        Iterator<PrismReferenceValue> iterator = values.iterator();
        while (iterator.hasNext()) {
            PrismReferenceValue value = iterator.next();
            if (!this.willClear(value)) continue;
            iterator.remove();
        }
    }

    protected abstract boolean willClear(PrismReferenceValue var1);

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

