/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.IOException;
import java.text.MessageFormat;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaHandler
implements ErrorHandler,
EntityResolver {
    private static final Trace LOGGER = TraceManager.getTrace(SchemaHandler.class);
    private EntityResolver entityResolver;

    public SchemaHandler(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.print("[Warning]", e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.print("[Error]", e);
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.print("[Fatal]", e);
        throw e;
    }

    private void print(String header, SAXParseException e) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error occured during schema parsing: ");
        builder.append(header);
        builder.append(" ");
        builder.append(MessageFormat.format("on line {0} at {1}, {2}", Integer.toString(e.getLineNumber()), e.getSystemId(), e.getPublicId()));
        builder.append(" ");
        builder.append(e.getMessage());
        LOGGER.error(builder.toString());
        LOGGER.trace(builder.toString(), (Throwable)e);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.entityResolver == null) {
            throw new IllegalStateException("Entity resolver is not set");
        }
        try {
            InputSource source = this.entityResolver.resolveEntity(publicId, systemId);
            LOGGER.trace("Resolved entity '{}', '{}': '{}' (resolver: {})", new Object[]{publicId, systemId, source, this.entityResolver});
            return source;
        }
        catch (SAXException e) {
            LOGGER.error("XML error resolving entity '{}', '{}': '{}'", new Object[]{publicId, systemId, e.getMessage(), e});
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("IO error resolving entity '{}', '{}': '{}'", new Object[]{publicId, systemId, e.getMessage(), e});
            throw e;
        }
    }
}

