/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.prism.polystring.PolyStringNormalizer;
import com.evolveum.midpoint.prism.polystring.PrismDefaultPolyStringNormalizer;
import com.evolveum.midpoint.prism.schema.SchemaDefinitionFactory;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class PrismContext {
    private static final Trace LOGGER = TraceManager.getTrace(PrismContext.class);
    private SchemaRegistry schemaRegistry;
    private PrismJaxbProcessor prismJaxbProcessor;
    private PrismDomProcessor prismDomProcessor;
    private SchemaDefinitionFactory definitionFactory;
    private PolyStringNormalizer defaultPolyStringNormalizer;

    private PrismContext() {
    }

    public static PrismContext create(SchemaRegistry schemaRegistry) {
        PrismContext prismContext = new PrismContext();
        prismContext.schemaRegistry = schemaRegistry;
        schemaRegistry.setPrismContext(prismContext);
        PrismJaxbProcessor prismJaxbProcessor = new PrismJaxbProcessor(prismContext);
        prismJaxbProcessor.initialize();
        prismContext.prismJaxbProcessor = prismJaxbProcessor;
        PrismDomProcessor prismDomProcessor = new PrismDomProcessor(schemaRegistry);
        prismDomProcessor.setPrismContext(prismContext);
        prismContext.prismDomProcessor = prismDomProcessor;
        return prismContext;
    }

    public void initialize() throws SchemaException, SAXException, IOException {
        this.schemaRegistry.initialize();
        if (this.defaultPolyStringNormalizer == null) {
            this.defaultPolyStringNormalizer = new PrismDefaultPolyStringNormalizer();
        }
    }

    public SchemaRegistry getSchemaRegistry() {
        return this.schemaRegistry;
    }

    public void setSchemaRegistry(SchemaRegistry schemaRegistry) {
        this.schemaRegistry = schemaRegistry;
    }

    public PrismJaxbProcessor getPrismJaxbProcessor() {
        return this.prismJaxbProcessor;
    }

    public void setPrismJaxbProcessor(PrismJaxbProcessor prismJaxbProcessor) {
        this.prismJaxbProcessor = prismJaxbProcessor;
    }

    public PrismDomProcessor getPrismDomProcessor() {
        return this.prismDomProcessor;
    }

    public void setPrismDomProcessor(PrismDomProcessor prismDomProcessor) {
        this.prismDomProcessor = prismDomProcessor;
    }

    public SchemaDefinitionFactory getDefinitionFactory() {
        if (this.definitionFactory == null) {
            this.definitionFactory = new SchemaDefinitionFactory();
        }
        return this.definitionFactory;
    }

    public void setDefinitionFactory(SchemaDefinitionFactory definitionFactory) {
        this.definitionFactory = definitionFactory;
    }

    public PolyStringNormalizer getDefaultPolyStringNormalizer() {
        return this.defaultPolyStringNormalizer;
    }

    public void setDefaultPolyStringNormalizer(PolyStringNormalizer defaultPolyStringNormalizer) {
        this.defaultPolyStringNormalizer = defaultPolyStringNormalizer;
    }

    public <T extends Objectable> PrismObject<T> parseObject(Element objectElement) throws SchemaException {
        return this.prismDomProcessor.parseObject(objectElement);
    }

    public <T extends Objectable> PrismObject<T> parseObject(File file) throws SchemaException {
        return this.prismDomProcessor.parseObject(file);
    }

    public <T extends Objectable> PrismObject<T> parseObject(String xmlString) throws SchemaException {
        return this.prismDomProcessor.parseObject(xmlString);
    }

    public <T extends Objectable> void adopt(PrismObject<T> object, Class<T> declaredType) throws SchemaException {
        object.revive(this);
        this.getSchemaRegistry().applyDefinition(object, declaredType, false);
    }

    public void adopt(Objectable objectable) throws SchemaException {
        this.adopt(objectable.asPrismObject(), objectable.getClass());
    }

    public String silentMarshalObject(Object object) {
        String xml = null;
        try {
            QName fakeQName = new QName("http://prism.evolveum.com/xml/ns/public/debug", "debugPrintObject");
            if (object instanceof Objectable) {
                xml = this.prismDomProcessor.serializeObjectToString(((Objectable)object).asPrismObject());
            } else if (object instanceof Containerable) {
                Element fakeParent = DOMUtil.createElement((Document)DOMUtil.getDocument(), (QName)fakeQName);
                xml = this.prismDomProcessor.serializeObjectToString(((Containerable)object).asPrismContainerValue(), fakeParent);
            } else {
                xml = this.prismJaxbProcessor.marshalElementToString(new JAXBElement(fakeQName, Object.class, object));
            }
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't marshal element to string {}", (Throwable)ex, (Object[])new Object[]{object});
        }
        return xml;
    }
}

