/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.api;

import com.evolveum.midpoint.task.api.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterStatusInformation {
    private Map<Node, List<TaskInfo>> tasks = new HashMap<Node, List<TaskInfo>>();

    public Set<TaskInfo> getTasks() {
        HashSet<TaskInfo> retval = new HashSet<TaskInfo>();
        for (List<TaskInfo> tasksOnNode : this.tasks.values()) {
            retval.addAll(tasksOnNode);
        }
        return retval;
    }

    public Map<Node, List<TaskInfo>> getTasksOnNodes() {
        return this.tasks;
    }

    public Set<TaskInfo> getTasksOnNodes(Collection<String> nodeIdList) {
        HashSet<TaskInfo> retval = new HashSet<TaskInfo>();
        for (String nodeId : nodeIdList) {
            retval.addAll(this.getTasksOnNode(nodeId));
        }
        return retval;
    }

    public List<TaskInfo> getTasksOnNode(Node node) {
        return this.tasks.get(node);
    }

    public List<TaskInfo> getTasksOnNode(String nodeId) {
        return this.getTasksOnNode(this.findNodeById(nodeId));
    }

    public Node findNodeInfoForTask(String oid) {
        for (Map.Entry<Node, List<TaskInfo>> entry : this.tasks.entrySet()) {
            for (TaskInfo ti : entry.getValue()) {
                if (!oid.equals(ti.getOid())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public Set<Node> getNodes() {
        return this.tasks.keySet();
    }

    public void addNodeInfo(Node node) {
        this.tasks.put(node, new ArrayList());
    }

    public void addNodeAndTaskInfo(Node node, List<TaskInfo> taskInfoList) {
        this.tasks.put(node, taskInfoList);
    }

    public Node findNodeById(String nodeIdentifier) {
        for (Node node : this.tasks.keySet()) {
            if (!node.getNodeIdentifier().equals(nodeIdentifier)) continue;
            return node;
        }
        return null;
    }

    public String dump() {
        StringBuffer retval = new StringBuffer();
        for (Map.Entry<Node, List<TaskInfo>> nodeListEntry : this.tasks.entrySet()) {
            retval.append(nodeListEntry.getKey().toString());
            retval.append(": ");
            retval.append(nodeListEntry.getValue().toString());
        }
        return retval.toString();
    }

    public static class TaskInfo {
        private String oid;

        public TaskInfo(String taskOid) {
            this.oid = taskOid;
        }

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String toString() {
            return this.oid;
        }
    }
}

