/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.BytecodeInstruction;
import org.codehaus.groovy.classgen.BytecodeSequence;
import org.codehaus.groovy.classgen.InnerClassVisitorHelper;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class InnerClassCompletionVisitor
extends InnerClassVisitorHelper
implements Opcodes {
    private final SourceUnit sourceUnit;

    public InnerClassCompletionVisitor(CompilationUnit cu, SourceUnit su) {
        this.sourceUnit = su;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visitClass(ClassNode node) {
        InnerClassNode innerClass = null;
        if (!node.isEnum() && !node.isInterface() && node instanceof InnerClassNode) {
            innerClass = (InnerClassNode)node;
        }
        super.visitClass(node);
        if (node.isEnum() || node.isInterface()) {
            return;
        }
        if (innerClass == null) {
            return;
        }
        this.addDefaultMethods(innerClass);
    }

    private String getTypeDescriptor(ClassNode node, boolean isStatic) {
        return BytecodeHelper.getTypeDescription(this.getClassNode(node, isStatic));
    }

    private String getInternalName(ClassNode node, boolean isStatic) {
        return BytecodeHelper.getClassInternalName(this.getClassNode(node, isStatic));
    }

    private void addDefaultMethods(InnerClassNode node) {
        boolean isStatic = this.isStatic(node);
        final String classInternalName = BytecodeHelper.getClassInternalName(node);
        final String outerClassInternalName = this.getInternalName(node.getOuterClass(), isStatic);
        final String outerClassDescriptor = this.getTypeDescriptor(node.getOuterClass(), isStatic);
        final int objectDistance = this.getObjectDistance(node.getOuterClass());
        Parameter[] parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "args")};
        MethodNode method = node.addSyntheticMethod("methodMissing", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        BlockStatement block = new BlockStatement();
        if (isStatic) {
            this.setMethodDispatcherCode(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$invoke$" + objectDistance, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;");
                    mv.visitInsn(176);
                }
            }));
        }
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name"), new Parameter(ClassHelper.OBJECT_TYPE, "val")};
        method = node.addSyntheticMethod("propertyMissing", 1, ClassHelper.VOID_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        if (isStatic) {
            this.setPropertySetterDispatcher(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitVarInsn(25, 2);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$set$" + objectDistance, "(Ljava/lang/String;Ljava/lang/Object;)V");
                    mv.visitInsn(177);
                }
            }));
        }
        method.setCode(block);
        parameters = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE, "name")};
        method = node.addSyntheticMethod("propertyMissing", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, null);
        block = new BlockStatement();
        if (isStatic) {
            this.setPropertyGetterDispatcher(block, new ClassExpression(node.getOuterClass()), parameters);
        } else {
            block.addStatement(new BytecodeSequence(new BytecodeInstruction(){

                public void visit(MethodVisitor mv) {
                    mv.visitVarInsn(25, 0);
                    mv.visitFieldInsn(180, classInternalName, "this$0", outerClassDescriptor);
                    mv.visitVarInsn(25, 1);
                    mv.visitMethodInsn(182, outerClassInternalName, "this$dist$get$" + objectDistance, "(Ljava/lang/String;)Ljava/lang/Object;");
                    mv.visitInsn(176);
                }
            }));
        }
        method.setCode(block);
    }
}

