/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.exception.SystemException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DOMUtil {
    public static final String W3C_XML_SCHEMA_XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String W3C_XML_SCHEMA_XMLNS_PREFIX = "xmlns";
    public static final String W3C_XML_XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String W3C_XML_XML_PREFIX = "xml";
    public static final String NS_W3C_XSI_PREFIX = "xsi";
    public static final QName XSI_TYPE = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");
    public static final QName XML_ID_ATTRIBUTE = new QName("http://www.w3.org/XML/1998/namespace", "id", "xml");
    public static final String NS_W3C_XML_SCHEMA_PREFIX = "xsd";
    public static final QName XSD_SCHEMA_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "schema", "xsd");
    public static final QName XSD_ANNOTATION_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "annotation", "xsd");
    public static final QName XSD_APPINFO_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "appinfo", "xsd");
    public static final QName XSD_ATTR_TARGET_NAMESPACE = new QName("http://www.w3.org/2001/XMLSchema", "targetNamespace", "xsd");
    public static final QName XSD_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd");
    public static final QName XSD_INTEGER = new QName("http://www.w3.org/2001/XMLSchema", "integer", "xsd");
    public static final QName XSD_INT = new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd");
    public static final QName XSD_LONG = new QName("http://www.w3.org/2001/XMLSchema", "long", "xsd");
    public static final QName XSD_SHORT = new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd");
    public static final QName XSD_FLOAT = new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd");
    public static final QName XSD_DOUBLE = new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd");
    public static final QName XSD_BOOLEAN = new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd");
    public static final QName XSD_BASE64BINARY = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary", "xsd");
    public static final QName XSD_DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime", "xsd");
    public static final QName XSD_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "QName", "xsd");
    public static final QName XSD_ANYURI = new QName("http://www.w3.org/2001/XMLSchema", "anyURI", "xsd");
    public static final QName XSD_ANY = new QName("http://www.w3.org/2001/XMLSchema", "any", "xsd");
    public static final String NS_XML_ENC = "http://www.w3.org/2001/04/xmlenc#";
    public static final String NS_XML_DSIG = "http://www.w3.org/2000/09/xmldsig#";
    private static final String RANDOM_ATTR_PREFIX_PREFIX = "qn";
    private static final int RANDOM_ATTR_PREFIX_RND = 1000;
    private static Random rnd = new Random();
    private static final DocumentBuilder loader;

    static {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            loader = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error creating XML document " + ex.getMessage());
        }
    }

    public static String serializeDOMToString(Node node) {
        return DOMUtil.printDom(node).toString();
    }

    public static Document getDocument(Node node) {
        if (node instanceof Document) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Document getDocument() {
        return loader.newDocument();
    }

    public static Document parseDocument(String doc) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return loader.parse(IOUtils.toInputStream((String)doc, (String)"utf-8"));
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
    }

    public static Document parseFile(String filePath) {
        return DOMUtil.parseFile(new File(filePath));
    }

    public static Document parseFile(File file) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return loader.parse(file);
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
    }

    public static Document parse(InputStream inputStream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            DocumentBuilder loader = factory.newDocumentBuilder();
            return loader.parse(inputStream);
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Error parsing XML document " + ex.getMessage(), ex);
        }
    }

    public static String showDom(List<Element> elements) {
        StringBuilder sb = new StringBuilder();
        for (Element element : elements) {
            DOMUtil.showDomNode(element, sb, 0);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static StringBuffer printDom(Node node) {
        Transformer trans;
        StringWriter writer = new StringWriter();
        TransformerFactory transfac = TransformerFactory.newInstance();
        try {
            trans = transfac.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new SystemException("Error in XML configuration: " + e.getMessage(), e);
        }
        trans.setOutputProperty("indent", "yes");
        trans.setParameter("encoding", "utf-8");
        trans.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(node);
        try {
            trans.transform(source, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new SystemException("Error in XML transformation: " + e.getMessage(), e);
        }
        return writer.getBuffer();
    }

    private static void showDomNode(Node node, StringBuilder sb, int level) {
        if (sb == null) {
            return;
        }
        int i = 0;
        while (i < level) {
            sb.append("  ");
            ++i;
        }
        if (node == null) {
            sb.append("null\n");
        } else {
            sb.append(node.getNodeName());
            sb.append(" (");
            NamedNodeMap attributes = node.getAttributes();
            boolean broken = false;
            if (attributes != null) {
                int ii = 0;
                while (ii < attributes.getLength()) {
                    Node attribute = attributes.item(ii);
                    sb.append(attribute.getPrefix());
                    sb.append(":");
                    sb.append(attribute.getLocalName());
                    sb.append("='");
                    sb.append(attribute.getNodeValue());
                    sb.append("',");
                    if (attribute.getPrefix() == null && attribute.getLocalName().equals(W3C_XML_SCHEMA_XMLNS_PREFIX) && (attribute.getNodeValue() == null || attribute.getNodeValue().isEmpty())) {
                        broken = true;
                    }
                    ++ii;
                }
            }
            sb.append(")");
            if (broken) {
                sb.append(" *** WARNING: empty default namespace");
            }
            sb.append("\n");
            NodeList childNodes = node.getChildNodes();
            int ii = 0;
            while (ii < childNodes.getLength()) {
                Node subnode = childNodes.item(ii);
                DOMUtil.showDomNode(subnode, sb, level + 1);
                ++ii;
            }
        }
    }

    public static Node getNextSiblingElement(Node node) {
        if (node == null || node.getParentNode() == null) {
            return null;
        }
        Node parent = node.getParentNode();
        NodeList nodes = parent.getChildNodes();
        if (nodes == null) {
            return null;
        }
        boolean found = false;
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            if (child.equals(node)) {
                found = true;
            } else if (found && child.getNodeType() == 1) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static Element getFirstChildElement(Node parent) {
        if (parent == null || parent.getChildNodes() == null) {
            return null;
        }
        NodeList nodes = parent.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    public static Element getLastChildElement(Node parent) {
        if (parent == null || parent.getChildNodes() == null) {
            return null;
        }
        NodeList nodes = parent.getChildNodes();
        int i = nodes.getLength() - 1;
        while (i >= 0) {
            Node child = nodes.item(i);
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            --i;
        }
        return null;
    }

    public static List<Element> listChildElements(Node node) {
        ArrayList<Element> subelements = new ArrayList<Element>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                subelements.add((Element)childNode);
            }
            ++i;
        }
        return subelements;
    }

    public static boolean hasChildElements(Node node) {
        List<Element> childElements = DOMUtil.listChildElements(node);
        return !childElements.isEmpty();
    }

    public static QName resolveQName(Element element) {
        return DOMUtil.resolveQName(element, element.getTextContent());
    }

    public static QName resolveQName(Node domNode, String prefixNotation) {
        return DOMUtil.resolveQName(domNode, prefixNotation, null);
    }

    public static QName resolveQName(Node domNode, String prefixNotation, String defaultNamespacePrefix) {
        QName qname;
        if (StringUtils.isBlank((String)prefixNotation)) {
            return null;
        }
        String[] qnameArray = prefixNotation.split(":");
        if (qnameArray.length > 2) {
            throw new IllegalArgumentException("Unsupported format: more than one colon in Qname: " + prefixNotation);
        }
        if (qnameArray.length == 1 || qnameArray[1] == null || qnameArray[1].isEmpty()) {
            String namespace = DOMUtil.findNamespace(domNode, null);
            qname = defaultNamespacePrefix != null ? new QName(namespace, qnameArray[0], defaultNamespacePrefix) : new QName(namespace, qnameArray[0]);
        } else {
            String namespace = DOMUtil.findNamespace(domNode, qnameArray[0]);
            qname = new QName(namespace, qnameArray[1], qnameArray[0]);
        }
        return qname;
    }

    public static String findNamespace(Node domNode, String prefix) {
        String ns = null;
        if (domNode != null && (ns = prefix == null || prefix.isEmpty() ? domNode.lookupNamespaceURI(null) : domNode.lookupNamespaceURI(prefix)) != null) {
            return ns;
        }
        return ns;
    }

    public static QName resolveXsiType(Element element) {
        return DOMUtil.resolveXsiType(element, null);
    }

    public static QName resolveXsiType(Element element, String defaultNamespacePrefix) {
        String xsiType = element.getAttributeNS(XSI_TYPE.getNamespaceURI(), XSI_TYPE.getLocalPart());
        if (xsiType == null || xsiType.isEmpty()) {
            return null;
        }
        return DOMUtil.resolveQName(element, xsiType, defaultNamespacePrefix);
    }

    public static boolean hasXsiType(Element element) {
        String xsiType = element.getAttributeNS(XSI_TYPE.getNamespaceURI(), XSI_TYPE.getLocalPart());
        return xsiType != null && !xsiType.isEmpty();
    }

    public static void setXsiType(Element element, QName type) {
        if (DOMUtil.hasXsiType(element)) {
            throw new IllegalArgumentException("Element already has a type");
        }
        DOMUtil.setQNameAttribute(element, XSI_TYPE, type);
    }

    public static void setQNameAttribute(Element element, QName attributeName, QName attributeValue) {
        Document doc = element.getOwnerDocument();
        Attr attr = doc.createAttributeNS(attributeName.getNamespaceURI(), attributeName.getLocalPart());
        String namePrefix = DOMUtil.lookupOrCreateNamespaceDeclaration(element, attributeName.getNamespaceURI(), attributeName.getPrefix());
        attr.setPrefix(namePrefix);
        DOMUtil.setQNameAttribute(element, attr, attributeValue, element);
    }

    public static void setQNameAttribute(Element element, String attributeName, QName attributeValue) {
        Document doc = element.getOwnerDocument();
        Attr attr = doc.createAttribute(attributeName);
        DOMUtil.setQNameAttribute(element, attr, attributeValue, element);
    }

    public static void setQNameAttribute(Element element, QName attributeName, QName attributeValue, Element definitionElement) {
        Document doc = element.getOwnerDocument();
        Attr attr = doc.createAttributeNS(attributeName.getNamespaceURI(), attributeName.getLocalPart());
        String namePrefix = DOMUtil.lookupOrCreateNamespaceDeclaration(element, attributeName.getNamespaceURI(), attributeName.getPrefix());
        attr.setPrefix(namePrefix);
        DOMUtil.setQNameAttribute(element, attr, attributeValue, definitionElement);
    }

    public static void setQNameAttribute(Element element, String attributeName, QName attributeValue, Element definitionElement) {
        Document doc = element.getOwnerDocument();
        Attr attr = doc.createAttribute(attributeName);
        DOMUtil.setQNameAttribute(element, attr, attributeValue, definitionElement);
    }

    private static void setQNameAttribute(Element element, Attr attr, QName attributeValue, Element definitionElement) {
        if (attributeValue.getNamespaceURI() == null || attributeValue.getNamespaceURI().isEmpty()) {
            throw new IllegalArgumentException("Namespace of XML attribute value " + attributeValue + " is empty");
        }
        String valuePrefix = DOMUtil.lookupOrCreateNamespaceDeclaration(element, attributeValue.getNamespaceURI(), attributeValue.getPrefix(), definitionElement);
        String attrValue = null;
        attrValue = valuePrefix == null || valuePrefix.isEmpty() ? attributeValue.getLocalPart() : String.valueOf(valuePrefix) + ":" + attributeValue.getLocalPart();
        NamedNodeMap attributes = element.getAttributes();
        attr.setValue(attrValue);
        attributes.setNamedItem(attr);
    }

    public static void setQNameValue(Element element, QName elementValue) {
        String valuePrefix = DOMUtil.lookupOrCreateNamespaceDeclaration(element, elementValue.getNamespaceURI(), elementValue.getPrefix());
        String stringValue = null;
        stringValue = valuePrefix == null || valuePrefix.isEmpty() ? elementValue.getLocalPart() : String.valueOf(valuePrefix) + ":" + elementValue.getLocalPart();
        element.setTextContent(stringValue);
    }

    public static String lookupOrCreateNamespaceDeclaration(Element element, String namespaceUri, String preferredPrefix) {
        return DOMUtil.lookupOrCreateNamespaceDeclaration(element, namespaceUri, preferredPrefix, element);
    }

    public static String lookupOrCreateNamespaceDeclaration(Element element, String namespaceUri, String preferredPrefix, Element definitionElement) {
        if (!StringUtils.isBlank((String)preferredPrefix)) {
            String namespaceForPreferredPrefix = element.lookupNamespaceURI(preferredPrefix);
            if (namespaceForPreferredPrefix == null) {
                DOMUtil.setNamespaceDeclaration(definitionElement, preferredPrefix, namespaceUri);
                return preferredPrefix;
            }
            if (namespaceForPreferredPrefix.equals(namespaceUri)) {
                return preferredPrefix;
            }
        }
        if (element.isDefaultNamespace(namespaceUri)) {
            return "";
        }
        String prefix = element.lookupPrefix(namespaceUri);
        if (prefix == null) {
            prefix = preferredPrefix;
            if (prefix != null) {
                String namespaceDefinedForPreferredPrefix = element.lookupNamespaceURI(prefix);
                if (namespaceDefinedForPreferredPrefix == null || namespaceDefinedForPreferredPrefix.isEmpty()) {
                    if (prefix.isEmpty()) {
                        prefix = null;
                    } else {
                        DOMUtil.setNamespaceDeclaration(definitionElement, prefix, namespaceUri);
                    }
                } else if (!namespaceUri.equals(namespaceDefinedForPreferredPrefix)) {
                    prefix = null;
                }
            }
            if (prefix == null) {
                prefix = RANDOM_ATTR_PREFIX_PREFIX + rnd.nextInt(1000);
                DOMUtil.setNamespaceDeclaration(definitionElement, prefix, namespaceUri);
            }
        }
        return prefix;
    }

    public static boolean isNamespaceDefinition(Attr attr) {
        if (W3C_XML_SCHEMA_XMLNS_URI.equals(attr.getNamespaceURI())) {
            return true;
        }
        return attr.getName().startsWith("xmlns:") || W3C_XML_SCHEMA_XMLNS_PREFIX.equals(attr.getName());
    }

    public static void setNamespaceDeclaration(Element element, String prefix, String namespaceUri) {
        Document doc = element.getOwnerDocument();
        NamedNodeMap attributes = element.getAttributes();
        Attr attr = prefix == null || prefix.isEmpty() ? doc.createAttributeNS(W3C_XML_SCHEMA_XMLNS_URI, W3C_XML_SCHEMA_XMLNS_PREFIX) : doc.createAttributeNS(W3C_XML_SCHEMA_XMLNS_URI, "xmlns:" + prefix);
        attr.setValue(namespaceUri);
        attributes.setNamedItem(attr);
    }

    public static Map<String, String> getNamespaceDeclarations(Element element) {
        HashMap<String, String> nsDeclMap = new HashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            if (DOMUtil.isNamespaceDefinition(attr)) {
                String prefix = DOMUtil.getNamespaceDeclarationPrefix(attr);
                String namespace = DOMUtil.getNamespaceDeclarationNamespace(attr);
                nsDeclMap.put(prefix, namespace);
            }
            ++i;
        }
        return nsDeclMap;
    }

    public static void setNamespaceDeclarations(Element element, Map<String, String> rootNamespaceDeclarations) {
        for (Map.Entry<String, String> entry : rootNamespaceDeclarations.entrySet()) {
            DOMUtil.setNamespaceDeclaration(element, entry.getKey(), entry.getValue());
        }
    }

    public static void fixNamespaceDeclarations(Element element) {
        DOMUtil.fixNamespaceDeclarations(element, element);
    }

    private static void fixNamespaceDeclarations(Element targetElement, Element currentElement) {
        NamedNodeMap attributes = currentElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            if (DOMUtil.isNamespaceDefinition(attr)) {
                String prefix = DOMUtil.getNamespaceDeclarationPrefix(attr);
                DOMUtil.getNamespaceDeclarationNamespace(attr);
                if (DOMUtil.hasNamespaceDeclarationForPrefix(targetElement, prefix)) {
                    if (targetElement != currentElement) {
                        // empty if block
                    }
                } else {
                    DOMUtil.setNamespaceDeclaration(targetElement, prefix, DOMUtil.getNamespaceDeclarationNamespace(attr));
                }
            }
            ++i;
        }
        Node parentNode = currentElement.getParentNode();
        if (parentNode instanceof Element) {
            DOMUtil.fixNamespaceDeclarations(targetElement, (Element)parentNode);
        }
    }

    public static boolean isPrefixUsed(Element targetElement, String prefix) {
        if (DOMUtil.comparePrefix(prefix, targetElement.getPrefix())) {
            return true;
        }
        NamedNodeMap attributes = targetElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            if (DOMUtil.comparePrefix(prefix, attr.getPrefix())) {
                return true;
            }
            ++i;
        }
        NodeList childNodes = targetElement.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Element element;
            Node node = childNodes.item(i2);
            if (node instanceof Element && DOMUtil.isPrefixUsed(element = (Element)node, prefix)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static boolean hasNamespaceDeclarationForPrefix(Element targetElement, String prefix) {
        return DOMUtil.getNamespaceDeclarationForPrefix(targetElement, prefix) != null;
    }

    public static String getNamespaceDeclarationForPrefix(Element targetElement, String prefix) {
        NamedNodeMap attributes = targetElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String thisPrefix;
            Attr attr = (Attr)attributes.item(i);
            if (DOMUtil.isNamespaceDefinition(attr) && DOMUtil.comparePrefix(prefix, thisPrefix = DOMUtil.getNamespaceDeclarationPrefix(attr))) {
                return DOMUtil.getNamespaceDeclarationNamespace(attr);
            }
            ++i;
        }
        return null;
    }

    public static String getNamespaceDeclarationPrefix(Attr attr) {
        if (!W3C_XML_SCHEMA_XMLNS_URI.equals(attr.getNamespaceURI())) {
            throw new IllegalStateException("Attempt to get prefix from a attribute that is not a namespace declaration, it has namespace " + attr.getNamespaceURI());
        }
        String attrName = attr.getName();
        if (attrName.startsWith("xmlns:")) {
            return attrName.substring(6);
        }
        if (W3C_XML_SCHEMA_XMLNS_PREFIX.equals(attrName)) {
            return null;
        }
        throw new IllegalStateException("Attempt to get prefix from a attribute that is not a namespace declaration, it is " + attrName);
    }

    public static String getNamespaceDeclarationNamespace(Attr attr) {
        if (!W3C_XML_SCHEMA_XMLNS_URI.equals(attr.getNamespaceURI())) {
            throw new IllegalStateException("Attempt to get namespace from a attribute that is not a namespace declaration, it has namespace " + attr.getNamespaceURI());
        }
        String attrName = attr.getName();
        if (!attrName.startsWith("xmlns:") && !W3C_XML_SCHEMA_XMLNS_PREFIX.equals(attr.getName())) {
            throw new IllegalStateException("Attempt to get namespace from a attribute that is not a namespace declaration, it is " + attrName);
        }
        return attr.getValue();
    }

    private static boolean comparePrefix(String prefixA, String prefixB) {
        if (StringUtils.isBlank((String)prefixA) && StringUtils.isBlank((String)prefixB)) {
            return true;
        }
        if (StringUtils.isBlank((String)prefixA) || StringUtils.isBlank((String)prefixB)) {
            return false;
        }
        return prefixA.equals(prefixB);
    }

    public static Element getChildElement(Element element, QName qname) {
        for (Element subelement : DOMUtil.listChildElements(element)) {
            if (!qname.equals(DOMUtil.getQName(subelement))) continue;
            return subelement;
        }
        return null;
    }

    public static Element getChildElement(Element element, String localPart) {
        for (Element subelement : DOMUtil.listChildElements(element)) {
            if (!subelement.getLocalName().equals(localPart)) continue;
            return subelement;
        }
        return null;
    }

    public static Element getOrCreateAsFirstElement(Element parentElement, QName elementQName) {
        Element element = DOMUtil.getChildElement(parentElement, elementQName);
        if (element != null) {
            return element;
        }
        Document doc = parentElement.getOwnerDocument();
        element = doc.createElementNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        parentElement.insertBefore(element, DOMUtil.getFirstChildElement(parentElement));
        return element;
    }

    public static QName getQName(Node node) {
        if (node.getLocalName() == null) {
            return null;
        }
        if (node.getPrefix() == null) {
            return new QName(node.getNamespaceURI(), node.getLocalName());
        }
        return new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
    }

    public static QName getQNameValue(Element element) {
        return DOMUtil.resolveQName(element, element.getTextContent());
    }

    public static QName getQNameAttribute(Element element, String attributeName) {
        String attrContent = element.getAttribute(attributeName);
        if (StringUtils.isBlank((String)attrContent)) {
            return null;
        }
        return DOMUtil.resolveQName(element, attrContent);
    }

    public static QName getQNameAttribute(Element element, QName attributeName) {
        String attrContent = element.getAttributeNS(attributeName.getNamespaceURI(), attributeName.getLocalPart());
        if (StringUtils.isBlank((String)attrContent)) {
            return null;
        }
        return DOMUtil.resolveQName(element, attrContent);
    }

    public static Integer getIntegerValue(Element element) {
        if (element == null) {
            return null;
        }
        String textContent = element.getTextContent();
        if (StringUtils.isBlank((String)textContent)) {
            return null;
        }
        return Integer.valueOf(textContent);
    }

    public static void copyContent(Element source, Element destination) {
        NamedNodeMap attributes = source.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            destination.setAttributeNode(attr);
            ++i;
        }
        NodeList childNodes = source.getChildNodes();
        int i2 = 0;
        while (i2 < childNodes.getLength()) {
            Node item = childNodes.item(i2);
            destination.appendChild(item);
            ++i2;
        }
    }

    public static Element createElement(Document document, QName qname) {
        Element element = document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (qname.getPrefix() != null) {
            element.setPrefix(qname.getPrefix());
        }
        return element;
    }

    public static Element createElement(Document document, QName qname, Element parentElement, Element definitionElement) {
        DOMUtil.lookupOrCreateNamespaceDeclaration(parentElement, qname.getNamespaceURI(), qname.getPrefix(), definitionElement);
        return DOMUtil.createElement(document, qname);
    }

    public static Element createSubElement(Element parent, QName subElementQName) {
        Document doc = parent.getOwnerDocument();
        Element subElement = DOMUtil.createElement(doc, subElementQName);
        parent.appendChild(subElement);
        return subElement;
    }

    public static boolean compareElement(Element a, Element b, boolean considerNamespacePrefixes) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (!DOMUtil.getQName(a).equals(DOMUtil.getQName(b))) {
            return false;
        }
        if (!DOMUtil.compareAttributes(a.getAttributes(), b.getAttributes(), considerNamespacePrefixes)) {
            return false;
        }
        return DOMUtil.compareNodeList(a.getChildNodes(), b.getChildNodes(), considerNamespacePrefixes);
    }

    private static boolean compareAttributes(NamedNodeMap a, NamedNodeMap b, boolean considerNamespacePrefixes) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return DOMUtil.compareAttributesIsSubset(a, b, considerNamespacePrefixes) && DOMUtil.compareAttributesIsSubset(b, a, considerNamespacePrefixes);
    }

    private static boolean compareAttributesIsSubset(NamedNodeMap subset, NamedNodeMap superset, boolean considerNamespacePrefixes) {
        int i = 0;
        while (i < subset.getLength()) {
            Node aItem = subset.item(i);
            Attr aAttr = (Attr)aItem;
            if (!(!considerNamespacePrefixes && DOMUtil.isNamespaceDefinition(aAttr) || StringUtils.isBlank((String)aAttr.getLocalName()))) {
                QName aQname = new QName(aAttr.getNamespaceURI(), aAttr.getLocalName());
                Attr bAttr = DOMUtil.findAttributeByQName(superset, aQname);
                if (bAttr == null) {
                    return false;
                }
                if (!StringUtils.equals((String)aAttr.getTextContent(), (String)bAttr.getTextContent())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static Attr findAttributeByQName(NamedNodeMap attrs, QName qname) {
        int i = 0;
        while (i < attrs.getLength()) {
            QName aQname;
            Node aItem = attrs.item(i);
            Attr aAttr = (Attr)aItem;
            if (aAttr.getLocalName() != null && (aQname = new QName(aAttr.getNamespaceURI(), aAttr.getLocalName())).equals(qname)) {
                return aAttr;
            }
            ++i;
        }
        return null;
    }

    private static boolean compareNodeList(NodeList a, NodeList b, boolean considerNamespacePrefixes) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        List<Node> aList = DOMUtil.canonizeNodeList(a);
        List<Node> bList = DOMUtil.canonizeNodeList(b);
        if (aList.size() != bList.size()) {
            return false;
        }
        Iterator<Node> aIterator = aList.iterator();
        Iterator<Node> bIterator = bList.iterator();
        while (aIterator.hasNext()) {
            Node aItem = aIterator.next();
            Node bItem = bIterator.next();
            if (aItem.getNodeType() != bItem.getNodeType()) {
                return false;
            }
            if (!(aItem.getNodeType() == 1 ? !DOMUtil.compareElement((Element)aItem, (Element)bItem, considerNamespacePrefixes) : aItem.getNodeType() == 3 && !DOMUtil.compareTextNodeValues(aItem.getTextContent(), bItem.getTextContent()))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareTextNodeValues(String a, String b) {
        if (StringUtils.equals((String)a, (String)b)) {
            return true;
        }
        return StringUtils.isBlank((String)a) && StringUtils.isBlank((String)b);
    }

    private static List<Node> canonizeNodeList(NodeList nodelist) {
        ArrayList<Node> list = new ArrayList<Node>(nodelist.getLength());
        int i = 0;
        while (i < nodelist.getLength()) {
            Node aItem = nodelist.item(i);
            if (!(aItem.getNodeType() == 8 || aItem.getNodeType() == 3 && aItem.getTextContent().matches("\\s*"))) {
                list.add(aItem);
            }
            ++i;
        }
        return list;
    }

    public static boolean isJunk(Node node) {
        if (node.getNodeType() == 8) {
            return true;
        }
        if (node.getNodeType() == 7) {
            return true;
        }
        if (node.getNodeType() == 3) {
            Text text = (Text)node;
            return text.getTextContent().matches("^\\s*$");
        }
        return false;
    }

    public static void validateNonEmptyQName(QName qname, String shortDescription) {
        if (qname == null) {
            throw new IllegalArgumentException("null" + shortDescription);
        }
        if (StringUtils.isEmpty((String)qname.getNamespaceURI())) {
            throw new IllegalArgumentException("Missing namespace" + shortDescription);
        }
        if (StringUtils.isEmpty((String)qname.getLocalPart())) {
            throw new IllegalArgumentException("Missing local part" + shortDescription);
        }
    }

    public static Element findElementRecursive(Element element, QName elementQName) {
        if (elementQName.equals(DOMUtil.getQName(element))) {
            return element;
        }
        for (Element subElement : DOMUtil.listChildElements(element)) {
            Element foundElement = DOMUtil.findElementRecursive(subElement, elementQName);
            if (foundElement == null) continue;
            return foundElement;
        }
        return null;
    }

    public static QName getQNameWithoutPrefix(Node node) {
        QName qname = DOMUtil.getQName(node);
        return new QName(qname.getNamespaceURI(), qname.getLocalPart());
    }

    public static boolean isElementName(Element element, QName name) {
        return name.equals(DOMUtil.getQNameWithoutPrefix(element));
    }
}

