/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression;

import com.evolveum.midpoint.common.expression.Expression;
import com.evolveum.midpoint.common.expression.ExpressionEvaluator;
import com.evolveum.midpoint.common.expression.MidPointFunctions;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ExpressionFactory {
    public static String DEFAULT_LANGUAGE = "http://www.w3.org/TR/xpath/";
    private Map<String, ExpressionEvaluator> evaluators;
    private ObjectResolver objectResolver;
    private PrismContext prismContext;
    private MidPointFunctions functionLibrary;

    public ExpressionFactory(PrismContext prismContext) {
        this.prismContext = prismContext;
        this.evaluators = new HashMap<String, ExpressionEvaluator>();
        this.functionLibrary = new MidPointFunctions(prismContext);
    }

    @Deprecated
    public static ExpressionFactory createExpressionFactory(PrismContext prismContext, Map<String, ExpressionEvaluator> evaluators) {
        ExpressionFactory expressionFactory = new ExpressionFactory(prismContext);
        for (Map.Entry<String, ExpressionEvaluator> entry : evaluators.entrySet()) {
            expressionFactory.registerEvaluator(entry.getKey(), entry.getValue());
        }
        return expressionFactory;
    }

    public static ExpressionFactory createExpressionFactory(PrismContext prismContext, Collection<ExpressionEvaluator> evaluators) {
        ExpressionFactory expressionFactory = new ExpressionFactory(prismContext);
        for (ExpressionEvaluator evaluator : evaluators) {
            expressionFactory.registerEvaluator(evaluator.getLanguageUrl(), evaluator);
        }
        return expressionFactory;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver objectResolver) {
        this.objectResolver = objectResolver;
    }

    public Map<String, ExpressionEvaluator> getEvaluators() {
        return this.evaluators;
    }

    public Expression createExpression(ExpressionType expressionType, String shortDesc) throws ExpressionEvaluationException {
        Expression expression = new Expression(this.getEvaluator(this.getLanguage(expressionType), shortDesc), expressionType, shortDesc);
        expression.setObjectResolver(this.objectResolver);
        expression.setReturnType(expressionType.getReturnType());
        expression.setFunctionLibrary(this.functionLibrary);
        return expression;
    }

    public void registerEvaluator(String language, ExpressionEvaluator evaluator) {
        if (this.evaluators.containsKey(language)) {
            throw new IllegalArgumentException("Evaluator for language " + language + " already registered");
        }
        this.evaluators.put(language, evaluator);
    }

    private ExpressionEvaluator getEvaluator(String language, String shortDesc) throws ExpressionEvaluationException {
        ExpressionEvaluator evaluator = this.evaluators.get(language);
        if (evaluator == null) {
            throw new ExpressionEvaluationException("Language " + language + " used in expression " + shortDesc + " is not supported");
        }
        return evaluator;
    }

    private String getLanguage(ExpressionType expressionType) {
        if (expressionType.getLanguage() != null) {
            return expressionType.getLanguage();
        }
        return DEFAULT_LANGUAGE;
    }
}

