/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.execution;

import com.evolveum.midpoint.repo.cache.RepositoryCache;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskExecutionStatus;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskRecurrence;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.task.api.UseThreadInterrupt;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.TaskQuartzImpl;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ThreadStopActionType;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;

@DisallowConcurrentExecution
public class JobExecutor
implements InterruptableJob {
    private static TaskManagerQuartzImpl taskManagerImpl;
    private static final transient Trace LOGGER;
    private static final long WATCHFUL_SLEEP_INCREMENT = 500L;
    private volatile TaskQuartzImpl task;
    private volatile Thread executingThread;

    static {
        LOGGER = TraceManager.getTrace(JobExecutor.class);
    }

    public static void setTaskManagerQuartzImpl(TaskManagerQuartzImpl tmqi) {
        taskManagerImpl = tmqi;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        OperationResult executionResult = this.createOperationResult("execute");
        if (taskManagerImpl == null) {
            LOGGER.error("TaskManager not correctly set for JobExecutor, exiting the execution routine.");
            return;
        }
        String oid = context.getJobDetail().getKey().getName();
        try {
            this.task = (TaskQuartzImpl)taskManagerImpl.getTask(oid, executionResult);
        }
        catch (ObjectNotFoundException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Task with OID {} no longer exists, removing Quartz job and exiting the execution routine.", (Throwable)e, (Object[])new Object[]{oid});
            taskManagerImpl.getExecutionManager().removeTaskFromQuartz(oid, executionResult);
            return;
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Task with OID {} cannot be retrieved because of schema exception. Please correct the problem or resynchronize midPoint repository with Quartz job store using 'xxxxxxx' function. Now exiting the execution routine.", (Throwable)e, (Object[])new Object[]{oid});
            return;
        }
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Task with OID {} could not be retrieved, exiting the execution routine.", (Throwable)e, (Object[])new Object[]{oid});
            return;
        }
        if (this.task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
            LOGGER.warn("Task is not in RUNNABLE state (its state is {}), exiting its execution and removing its Quartz trigger. Task = {}", (Object)this.task.getExecutionStatus(), (Object)this.task);
            try {
                context.getScheduler().unscheduleJob(context.getTrigger().getKey());
            }
            catch (SchedulerException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot unschedule job for a non-RUNNABLE task {}", (Throwable)e, (Object[])new Object[]{this.task});
            }
            return;
        }
        if (context.isRecovering() && !this.processTaskRecovery(executionResult)) {
            return;
        }
        this.executingThread = Thread.currentThread();
        LOGGER.trace("execute called; task = " + this.task + ", thread = " + this.executingThread);
        this.logRunStart();
        try {
            TaskHandler handler = taskManagerImpl.getHandler(this.task.getHandlerUri());
            if (handler == null) {
                LOGGER.error("No handler for URI {}, task {} - closing it.", (Object)this.task.getHandlerUri(), (Object)this.task);
                this.closeFlawedTask(this.task, executionResult);
                throw new JobExecutionException("No handler for URI " + this.task.getHandlerUri());
            }
            if (this.task.isCycle()) {
                if (this.task.getHandlersCount() > 1) {
                    LOGGER.error("Recurrent tasks cannot have more than one task handler; task = {} - closing it.", (Object)this.task);
                    this.closeFlawedTask(this.task, executionResult);
                    throw new JobExecutionException("Recurrent tasks cannot have more than one task handler; task = " + this.task);
                }
                this.executeRecurrentTask(handler, executionResult);
            } else if (this.task.isSingle()) {
                this.executeSingleTask(handler, executionResult);
            } else {
                LOGGER.error("Tasks must be either recurrent or single-run. This one is neither. Sorry.");
                this.closeFlawedTask(this.task, executionResult);
            }
        }
        finally {
            this.executingThread = null;
            if (!this.task.canRun()) {
                this.processTaskStop(executionResult);
            }
            this.logRunFinish();
        }
    }

    private boolean processTaskRecovery(OperationResult executionResult) {
        if (this.task.getThreadStopAction() == ThreadStopActionType.CLOSE) {
            LOGGER.info("Closing recovered non-resilient task {}", (Object)this.task);
            this.closeTask(this.task, executionResult);
            return false;
        }
        if (this.task.getThreadStopAction() == ThreadStopActionType.SUSPEND) {
            LOGGER.info("Suspending recovered non-resilient task {}", (Object)this.task);
            taskManagerImpl.suspendTask(this.task, 0L, true, executionResult);
            return false;
        }
        if (this.task.getThreadStopAction() == null || this.task.getThreadStopAction() == ThreadStopActionType.RESTART) {
            LOGGER.info("Recovering resilient task {}", (Object)this.task);
            return true;
        }
        if (this.task.getThreadStopAction() == ThreadStopActionType.RESCHEDULE) {
            if (this.task.getRecurrenceStatus() == TaskRecurrence.RECURRING && this.task.isLooselyBound()) {
                LOGGER.info("Recovering resilient task with RESCHEDULE thread stop action - exiting the execution, the task will be rescheduled; task = {}", (Object)this.task);
                return false;
            }
            LOGGER.info("Recovering resilient task {}", (Object)this.task);
            return true;
        }
        throw new SystemException("Unknown value of ThreadStopAction: " + this.task.getThreadStopAction() + " for task " + this.task);
    }

    private void processTaskStop(OperationResult executionResult) {
        try {
            this.task.refresh(executionResult);
        }
        catch (ObjectNotFoundException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)("ThreadStopAction cannot be applied, because the task no longer exists: " + this.task), (Throwable)e, (Object[])new Object[0]);
            return;
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)("ThreadStopAction cannot be applied, because of schema exception. Task = " + this.task), (Throwable)e, (Object[])new Object[0]);
            return;
        }
        if (this.task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
            LOGGER.trace("processTaskStop: task execution status is not RUNNABLE (it is " + this.task.getExecutionStatus() + "), so ThreadStopAction does not apply; task = " + this.task);
            return;
        }
        if (this.task.getThreadStopAction() == ThreadStopActionType.CLOSE) {
            LOGGER.info("Closing non-resilient task on node shutdown; task = {}", (Object)this.task);
            this.closeTask(this.task, executionResult);
        } else if (this.task.getThreadStopAction() == ThreadStopActionType.SUSPEND) {
            LOGGER.info("Suspending non-resilient task on node shutdown; task = {}", (Object)this.task);
            taskManagerImpl.suspendTask(this.task, 0L, true, executionResult);
        } else if (this.task.getThreadStopAction() == null || this.task.getThreadStopAction() == ThreadStopActionType.RESTART) {
            LOGGER.info("Node going down: Rescheduling resilient task to run immediately; task = {}", (Object)this.task);
            taskManagerImpl.scheduleTaskNow(this.task, executionResult);
        } else if (this.task.getThreadStopAction() == ThreadStopActionType.RESCHEDULE) {
            if (this.task.getRecurrenceStatus() != TaskRecurrence.RECURRING || !this.task.isLooselyBound()) {
                taskManagerImpl.scheduleTaskNow(this.task, executionResult);
            }
        } else {
            throw new SystemException("Unknown value of ThreadStopAction: " + this.task.getThreadStopAction() + " for task " + this.task);
        }
    }

    private void closeFlawedTask(TaskQuartzImpl task, OperationResult result) {
        LOGGER.info("Closing flawed task {}", (Object)task);
        this.closeTask(task, result);
    }

    private void closeTask(TaskQuartzImpl task, OperationResult result) {
        try {
            taskManagerImpl.closeTask(task, result);
        }
        catch (ObjectNotFoundException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close task {}, because it does not exist in repository.", (Throwable)e, (Object[])new Object[]{task});
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close task {} due to schema exception", (Throwable)e, (Object[])new Object[]{task});
        }
        catch (SystemException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot close task {} due to system exception", (Throwable)e, (Object[])new Object[]{task});
        }
    }

    private void executeSingleTask(TaskHandler handler, OperationResult executionResult) throws JobExecutionException {
        try {
            try {
                RepositoryCache.enter();
                TaskRunResult runResult = null;
                this.recordCycleRunStart(executionResult);
                while (handler != null && this.task.canRun()) {
                    runResult = this.executeHandler(handler);
                    this.task.refresh(executionResult);
                    if (this.task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
                        LOGGER.info("Task not in the RUNNABLE state, exiting the execution routing. State = {}, Task = {}", (Object)this.task.getExecutionStatus(), (Object)this.task);
                        break;
                    }
                    if (!this.task.canRun()) break;
                    this.task.finishHandler(executionResult);
                    if (runResult.getOperationResult().isError()) break;
                    handler = taskManagerImpl.getHandler(this.task.getHandlerUri());
                }
                this.recordCycleRunFinish(runResult, executionResult);
            }
            catch (Throwable t) {
                LoggingUtils.logException((Trace)LOGGER, (String)"An exception occurred during processing of task {}", (Throwable)t, (Object[])new Object[]{this.task});
                throw new JobExecutionException("An exception occurred during processing of task " + this.task, t);
            }
        }
        finally {
            RepositoryCache.exit();
        }
    }

    private void executeRecurrentTask(TaskHandler handler, OperationResult executionResult) throws JobExecutionException {
        block19: {
            try {
                while (this.task.canRun()) {
                    Integer interval;
                    if (!this.task.stillCanStart()) {
                        LOGGER.trace("CycleRunner loop: task latest start time ({}) has elapsed, exiting the execution cycle. Task = {}", (Object)this.task.getSchedule().getLatestStartTime(), (Object)this.task);
                        break;
                    }
                    LOGGER.trace("CycleRunner loop: start");
                    RepositoryCache.enter();
                    this.recordCycleRunStart(executionResult);
                    TaskRunResult runResult = this.executeHandler(handler);
                    boolean canContinue = this.recordCycleRunFinish(runResult, executionResult);
                    RepositoryCache.exit();
                    if (!canContinue) break;
                    if (this.task.isLooselyBound()) {
                        LOGGER.trace("CycleRunner loop: task is loosely bound, exiting the execution cycle");
                        break;
                    }
                    if (!this.task.canRun()) break;
                    LOGGER.trace("CycleRunner loop: refreshing task after one iteration, task = {}", (Object)this.task);
                    try {
                        this.task.refresh(executionResult);
                    }
                    catch (ObjectNotFoundException ex) {
                        LOGGER.error("Error refreshing task " + this.task + ": Object not found: " + ex.getMessage(), (Throwable)ex);
                        return;
                    }
                    if (this.task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
                        LOGGER.info("Task not in the RUNNABLE state, exiting the execution routing. State = {}, Task = {}", (Object)this.task.getExecutionStatus(), (Object)this.task);
                        break;
                    }
                    Integer n = interval = this.task.getSchedule() != null ? this.task.getSchedule().getInterval() : null;
                    if (interval == null) {
                        LOGGER.error("Tightly bound task " + this.task + " has no scheduling interval specified.");
                        break;
                    }
                    long sleepFor = this.task.getLastRunStartTimestamp() + (long)(interval * 1000) - System.currentTimeMillis();
                    if (sleepFor < 0L) {
                        sleepFor = 0L;
                    }
                    LOGGER.trace("CycleRunner loop: sleep ({})", (Object)sleepFor);
                    long time = 0L;
                    while (time < sleepFor + 500L) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (!this.task.canRun()) {
                            LOGGER.trace("CycleRunner loop: sleep interrupted, task.canRun == false");
                            break block19;
                        }
                        time += 500L;
                    }
                    LOGGER.trace("CycleRunner loop: refreshing task after sleep, task = {}", (Object)this.task);
                    try {
                        this.task.refresh(executionResult);
                    }
                    catch (ObjectNotFoundException ex) {
                        LOGGER.error("Error refreshing task " + this.task + ": Object not found: " + ex.getMessage(), (Throwable)ex);
                        return;
                    }
                    if (this.task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
                        LOGGER.info("Task not in the RUNNABLE state, exiting the execution routine. State = {}, Task = {}", (Object)this.task.getExecutionStatus(), (Object)this.task);
                        break;
                    }
                    LOGGER.trace("CycleRunner loop: end");
                }
            }
            catch (Throwable t) {
                if (this.task.canRun()) {
                    LOGGER.error("CycleRunner got unexpected exception: {}: {}", new Object[]{t.getClass().getName(), t.getMessage(), t});
                } else {
                    LOGGER.debug("CycleRunner got unexpected exception while shutting down: {}: {}", new Object[]{t.getClass().getName(), t.getMessage()});
                    LOGGER.trace("CycleRunner got unexpected exception while shutting down: {}: {}", new Object[]{t.getClass().getName(), t.getMessage(), t});
                }
                throw new JobExecutionException("An exception occurred during processing of task " + this.task, t);
            }
        }
    }

    private TaskRunResult executeHandler(TaskHandler handler) {
        try {
            TaskRunResult runResult = handler.run((Task)this.task);
            if (runResult == null) {
                LOGGER.error("Unable to record run finish: task returned null result");
                runResult = new TaskRunResult();
                OperationResult dummyResult = this.createOperationResult("error");
                dummyResult.recordFatalError("Unable to record run finish: task returned null result");
                runResult.setOperationResult(dummyResult);
                runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            }
            return runResult;
        }
        catch (Throwable t) {
            LOGGER.error("Task handler threw unexpected exception: {}: {}", new Object[]{t.getClass().getName(), t.getMessage(), t});
            TaskRunResult runResult = new TaskRunResult();
            OperationResult dummyResult = this.createOperationResult("error");
            dummyResult.recordFatalError("Task handler threw unexpected exception: " + t.getMessage(), t);
            runResult.setOperationResult(dummyResult);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
    }

    private OperationResult createOperationResult(String methodName) {
        return new OperationResult(String.valueOf(JobExecutor.class.getName()) + "." + methodName);
    }

    private void logRunStart() {
        LOGGER.info("Task thread run STARTING " + this.task);
    }

    private void logRunFinish() {
        LOGGER.info("Task thread run FINISHED " + this.task);
    }

    private void recordCycleRunStart(OperationResult result) {
        LOGGER.debug("Task cycle run STARTING " + this.task);
        try {
            this.task.setLastRunStartTimestamp(System.currentTimeMillis());
            if (this.task.getCategory() == null) {
                this.task.setCategory(this.task.getCategoryFromHandler());
            }
            this.task.setNode(taskManagerImpl.getNodeId());
            this.task.savePendingModifications(result);
        }
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot record run start for task {}", (Throwable)e, (Object[])new Object[]{this.task});
        }
    }

    private boolean recordCycleRunFinish(TaskRunResult runResult, OperationResult result) {
        LOGGER.debug("Task cycle run FINISHED " + this.task);
        try {
            this.task.setProgress(runResult.getProgress());
            this.task.setLastRunFinishTimestamp(System.currentTimeMillis());
            this.task.setResult(runResult.getOperationResult());
            this.task.setNode(null);
            this.task.savePendingModifications(result);
            return true;
        }
        catch (ObjectNotFoundException ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot record run finish for task {}", (Throwable)ex, (Object[])new Object[]{this.task});
            return false;
        }
        catch (ObjectAlreadyExistsException ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot record run finish for task {}", (Throwable)ex, (Object[])new Object[]{this.task});
            return true;
        }
        catch (SchemaException ex) {
            LOGGER.error("Unable to record run finish and close the task: {}", (Object)ex.getMessage(), (Object)ex);
            return true;
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOGGER.trace("Trying to shut down the task " + this.task + ", executing in thread " + this.executingThread);
        if (this.task != null) {
            this.task.signalShutdown();
            if (taskManagerImpl.getConfiguration().getUseThreadInterrupt() == UseThreadInterrupt.ALWAYS) {
                this.sendThreadInterrupt();
            }
        }
    }

    public void sendThreadInterrupt() {
        if (this.executingThread != null) {
            LOGGER.trace("Calling Thread.interrupt on thread {}.", (Object)this.executingThread);
            this.executingThread.interrupt();
            LOGGER.trace("Thread.interrupt was called on thread {}.", (Object)this.executingThread);
        }
    }
}

