/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.scripting;

import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.scripting.ScriptBindingsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptingEngines {
    private static Logger log = Logger.getLogger(ScriptingEngines.class.getName());
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    private final ScriptEngineManager scriptEngineManager;
    protected ScriptBindingsFactory scriptBindingsFactory;

    public ScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        this(new ScriptEngineManager());
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptingEngines(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    public ScriptingEngines addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
        return this;
    }

    public void setScriptEngineFactories(List<ScriptEngineFactory> scriptEngineFactories) {
        if (scriptEngineFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
                this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
            }
        }
    }

    public Object evaluate(String script, String language, VariableScope variableScope) {
        Bindings bindings = this.createBindings(variableScope);
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(language);
        if (scriptEngine == null) {
            scriptEngine = this.checkForOSGiEngine(language);
        }
        if (scriptEngine == null) {
            throw new ActivitiException("Can't find scripting engine for '" + language + "'");
        }
        try {
            return scriptEngine.eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new ActivitiException("problem evaluating script: " + e.getMessage(), e);
        }
    }

    private ScriptEngine checkForOSGiEngine(String language) {
        log.info("No script engine found for " + language + " using standard javax.script auto-registration. Checking OSGi registry...");
        try {
            Class<?> c = Class.forName("org.activiti.osgi.Extender");
            Method mth = c.getDeclaredMethod("getBundleContext", new Class[0]);
            Object ctx = mth.invoke(null, new Object[0]);
            log.info("Found OSGi BundleContext " + ctx);
            if (ctx != null) {
                Method resolveScriptEngine = c.getDeclaredMethod("resolveScriptEngine", String.class);
                return (ScriptEngine)resolveScriptEngine.invoke(null, language);
            }
        }
        catch (Throwable t) {
            log.log(Level.INFO, "Unable to load OSGi, script engine cannot be found", t);
        }
        return null;
    }

    protected Bindings createBindings(VariableScope variableScope) {
        return this.scriptBindingsFactory.createBindings(variableScope);
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }
}

