/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.form.AbstractFormType;
import org.activiti.engine.impl.form.FormDataImpl;
import org.activiti.engine.impl.form.FormHandler;
import org.activiti.engine.impl.form.FormPropertyHandler;
import org.activiti.engine.impl.form.FormTypes;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.xml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormHandler
implements FormHandler {
    protected String formKey;
    protected String deploymentId;
    protected List<FormPropertyHandler> formPropertyHandlers = new ArrayList<FormPropertyHandler>();

    @Override
    public void parseConfiguration(Element activityElement, DeploymentEntity deployment, ProcessDefinitionEntity processDefinition, BpmnParse bpmnParse) {
        this.deploymentId = deployment.getId();
        this.formKey = activityElement.attributeNS("http://activiti.org/bpmn", "formKey");
        Element extensionElement = activityElement.element("extensionElements");
        if (extensionElement != null) {
            ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
            FormTypes formTypes = Context.getProcessEngineConfiguration().getFormTypes();
            List<Element> formPropertyElements = extensionElement.elementsNS("http://activiti.org/bpmn", "formProperty");
            for (Element formPropertyElement : formPropertyElements) {
                String defaultExpressionText;
                FormPropertyHandler formPropertyHandler = new FormPropertyHandler();
                String id = formPropertyElement.attribute("id");
                if (id == null) {
                    bpmnParse.addError("attribute 'id' is required", formPropertyElement);
                }
                formPropertyHandler.setId(id);
                String name = formPropertyElement.attribute("name");
                formPropertyHandler.setName(name);
                AbstractFormType type = formTypes.parseFormPropertyType(formPropertyElement, bpmnParse);
                formPropertyHandler.setType(type);
                String requiredText = formPropertyElement.attribute("required", "false");
                Boolean required = bpmnParse.parseBooleanAttribute(requiredText);
                if (required != null) {
                    formPropertyHandler.setRequired(required);
                } else {
                    bpmnParse.addError("attribute 'required' must be one of {on|yes|true|enabled|active|off|no|false|disabled|inactive}", formPropertyElement);
                }
                String readableText = formPropertyElement.attribute("readable", "true");
                Boolean readable = bpmnParse.parseBooleanAttribute(readableText);
                if (readable != null) {
                    formPropertyHandler.setReadable(readable);
                } else {
                    bpmnParse.addError("attribute 'readable' must be one of {on|yes|true|enabled|active|off|no|false|disabled|inactive}", formPropertyElement);
                }
                String writableText = formPropertyElement.attribute("writable", "true");
                Boolean writable = bpmnParse.parseBooleanAttribute(writableText);
                if (writable != null) {
                    formPropertyHandler.setWritable(writable);
                } else {
                    bpmnParse.addError("attribute 'writable' must be one of {on|yes|true|enabled|active|off|no|false|disabled|inactive}", formPropertyElement);
                }
                String variableName = formPropertyElement.attribute("variable");
                formPropertyHandler.setVariableName(variableName);
                String expressionText = formPropertyElement.attribute("expression");
                if (expressionText != null) {
                    Expression expression = expressionManager.createExpression(expressionText);
                    formPropertyHandler.setVariableExpression(expression);
                }
                if ((defaultExpressionText = formPropertyElement.attribute("default")) != null) {
                    Expression defaultExpression = expressionManager.createExpression(defaultExpressionText);
                    formPropertyHandler.setDefaultExpression(defaultExpression);
                }
                this.formPropertyHandlers.add(formPropertyHandler);
            }
        }
    }

    protected void initializeFormProperties(FormDataImpl formData, ExecutionEntity execution) {
        ArrayList<FormProperty> formProperties = new ArrayList<FormProperty>();
        for (FormPropertyHandler formPropertyHandler : this.formPropertyHandlers) {
            if (!formPropertyHandler.isReadable()) continue;
            FormProperty formProperty = formPropertyHandler.createFormProperty(execution);
            formProperties.add(formProperty);
        }
        formData.setFormProperties(formProperties);
    }

    @Override
    public void submitFormProperties(Map<String, String> properties, ExecutionEntity execution) {
        HashMap<String, String> propertiesCopy = new HashMap<String, String>(properties);
        for (FormPropertyHandler formPropertyHandler : this.formPropertyHandlers) {
            formPropertyHandler.submitFormProperty(execution, propertiesCopy);
        }
        for (String propertyId : propertiesCopy.keySet()) {
            execution.setVariable(propertyId, propertiesCopy.get(propertyId));
        }
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public List<FormPropertyHandler> getFormPropertyHandlers() {
        return this.formPropertyHandlers;
    }

    public void setFormPropertyHandlers(List<FormPropertyHandler> formPropertyHandlers) {
        this.formPropertyHandlers = formPropertyHandlers;
    }
}

