/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.constants;

import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.GenericObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordPolicyType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;

public enum ObjectTypes {
    ACCOUNT("schema.objectTypes.account", SchemaConstants.I_ACCOUNT_SHADOW_TYPE, SchemaConstants.I_ACCOUNT, AccountShadowType.class, true),
    CONNECTOR("schema.objectTypes.connector", SchemaConstants.I_CONNECTOR_TYPE, SchemaConstants.I_CONNECTOR, ConnectorType.class, true),
    CONNECTOR_HOST("schema.objectTypes.connectorHost", SchemaConstants.I_CONNECTOR_HOST_TYPE, SchemaConstants.I_CONNECTOR_HOST, ConnectorHostType.class, true),
    GENERIC_OBJECT("schema.objectTypes.genericObject", SchemaConstants.I_GENERIC_OBJECT_TYPE, SchemaConstants.I_GENERIC_OBJECT, GenericObjectType.class, false),
    RESOURCE("schema.objectTypes.resource", SchemaConstants.I_RESOURCE_TYPE, SchemaConstants.I_RESOURCE, ResourceType.class, true),
    USER("schema.objectTypes.user", SchemaConstants.I_USER_TYPE, SchemaConstants.I_USER, UserType.class, false),
    USER_TEMPLATE("schema.objectTypes.userTemplate", SchemaConstants.I_USER_TEMPLATE_TYPE, SchemaConstants.I_USER_TEMPLATE, UserTemplateType.class, false),
    SYSTEM_CONFIGURATION("schema.objectTypes.systemConfiguration", SchemaConstants.I_SYSTEM_CONFIGURATION_TYPE, SchemaConstants.I_SYSTEM_CONFIGURATION, SystemConfigurationType.class, false),
    TASK("schema.objectTypes.task", SchemaConstants.C_TASK_TYPE, SchemaConstants.C_TASK, TaskType.class, false),
    RESOURCE_OBJECT_SHADOW("schema.objectTypes.resourceObject", SchemaConstants.I_RESOURCE_OBJECT_SHADOW_TYPE, SchemaConstants.I_RESOURCE_OBJECT_SHADOW, ResourceObjectShadowType.class, true),
    OBJECT("schema.objectTypes.object", SchemaConstants.C_OBJECT_TYPE, SchemaConstants.C_OBJECT, ObjectType.class, false),
    ROLE("schema.objectTypes.role", RoleType.COMPLEX_TYPE, SchemaConstantsGenerated.C_ROLE, RoleType.class, false),
    PASSWORD_POLICY("schema.objectTypes.passwordPolicy", PasswordPolicyType.COMPLEX_TYPE, SchemaConstantsGenerated.C_PASSWORD_POLICY, PasswordPolicyType.class, false),
    NODE("schema.objectTypes.node", NodeType.COMPLEX_TYPE, SchemaConstantsGenerated.C_NODE, NodeType.class, false);

    private String localizationKey;
    private QName type;
    private QName name;
    private Class<? extends ObjectType> classDefinition;
    private boolean managedByProvisioning;

    private ObjectTypes(String key, QName type, QName name, Class<? extends ObjectType> classDefinition, boolean managedByProvisioning) {
        this.localizationKey = key;
        this.type = type;
        this.name = name;
        this.classDefinition = classDefinition;
        this.managedByProvisioning = managedByProvisioning;
    }

    public boolean isManagedByProvisioning() {
        return this.managedByProvisioning;
    }

    public String getLocalizationKey() {
        return this.localizationKey;
    }

    public String getValue() {
        return this.type.getLocalPart();
    }

    public QName getQName() {
        return this.name;
    }

    public QName getTypeQName() {
        return this.type;
    }

    public Class<? extends ObjectType> getClassDefinition() {
        return this.classDefinition;
    }

    public String getObjectTypeUri() {
        return QNameUtil.qNameToUri((QName)this.getTypeQName());
    }

    public static ObjectTypes getObjectType(String objectType) {
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getValue().equals(objectType)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported object type " + objectType);
    }

    public static ObjectTypes getObjectTypeFromTypeQName(QName typeQName) {
        if (typeQName.getNamespaceURI() == null || typeQName.getNamespaceURI().isEmpty()) {
            typeQName = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", typeQName.getLocalPart());
        }
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getTypeQName().equals(typeQName)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported object type qname " + typeQName);
    }

    public static ObjectTypes getObjectTypeFromUri(String objectTypeUri) {
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getObjectTypeUri().equals(objectTypeUri)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported object type uri " + objectTypeUri);
    }

    public static String getObjectTypeUri(String objectType) {
        return ObjectTypes.getObjectType(objectType).getObjectTypeUri();
    }

    public static Class<? extends ObjectType> getObjectTypeClass(String objectType) {
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getValue().equals(objectType)) {
                return type.getClassDefinition();
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported object type " + objectType);
    }

    public static ObjectTypes getObjectType(Class<? extends ObjectType> objectType) {
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getClassDefinition().equals(objectType)) {
                return type;
            }
            ++n2;
        }
        Class<? extends ObjectType> superclass = objectType.getSuperclass();
        if (superclass != null && !superclass.equals(ObjectType.class)) {
            return ObjectTypes.getObjectType(superclass);
        }
        throw new IllegalArgumentException("Unsupported object type " + objectType);
    }

    public static boolean isManagedByProvisioning(ObjectType object) {
        Validate.notNull((Object)object, (String)"Object must not be null.");
        return ObjectTypes.isClassManagedByProvisioning(object.getClass());
    }

    public static boolean isClassManagedByProvisioning(Class<? extends ObjectType> clazz) {
        Validate.notNull(clazz, (String)"Class must not be null.");
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getClassDefinition().isAssignableFrom(clazz)) {
                return type.isManagedByProvisioning();
            }
            ++n2;
        }
        return false;
    }

    public static boolean isObjectTypeManagedByProvisioning(Class<? extends ObjectType> objectType) {
        Validate.notNull(objectType, (String)"Object type must not be null.");
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getClassDefinition().equals(objectType)) {
                return type.isManagedByProvisioning();
            }
            ++n2;
        }
        return false;
    }

    public static boolean isObjectTypeManagedByProvisioning(String objectType) {
        Validate.notEmpty((String)objectType, (String)"Object type must not be null.");
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (type.getTypeQName().getLocalPart().equals(objectType)) {
                return type.isManagedByProvisioning();
            }
            ++n2;
        }
        return false;
    }
}

