/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.TimestampType;
import org.hibernate.usertype.UserType;

public class XMLGregorianCalendarType
implements UserType {
    private static final AbstractSingleColumnStandardBasicType HIBERNATE_TYPE = TimestampType.INSTANCE;
    private static DatatypeFactory df = null;

    static {
        try {
            df = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalStateException("Exception while obtaining Datatype Factory instance", dce);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        long date = (Long)cached;
        return XMLGregorianCalendarType.asXMLGregorianCalendar(new Date(date));
    }

    public int[] sqlTypes() {
        return new int[]{HIBERNATE_TYPE.sqlType()};
    }

    public Class returnedClass() {
        return Date.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == null ? y == null : x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x == null) {
            return 0;
        }
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Date date = (Date)HIBERNATE_TYPE.nullSafeGet(rs, names[0], session);
        if (date == null) {
            return null;
        }
        return XMLGregorianCalendarType.asXMLGregorianCalendar(date);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)value;
        Date date = null;
        if (calendar != null) {
            date = XMLGregorianCalendarType.asDate(calendar);
        }
        HIBERNATE_TYPE.nullSafeSet(st, (Object)date, index, session);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)value;
        return XMLGregorianCalendarType.asXMLGregorianCalendar(XMLGregorianCalendarType.asDate(calendar));
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        XMLGregorianCalendar calendar = (XMLGregorianCalendar)value;
        return Long.valueOf(XMLGregorianCalendarType.asDate(calendar).getTime());
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(date.getTime());
        return df.newXMLGregorianCalendar(gc);
    }

    public static Date asDate(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        return xgc.toGregorianCalendar().getTime();
    }
}

