/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.dom.ElementPrismPropertyImpl;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;

public class PrismPropertyValue<T>
extends PrismValue
implements Dumpable,
DebugDumpable,
Serializable {
    private T value;
    private Object rawElement;

    public PrismPropertyValue(T value) {
        this(value, null, null);
    }

    public PrismPropertyValue(T value, SourceType type, Objectable source) {
        super(type, source);
        if (value instanceof PrismPropertyValue) {
            throw new IllegalArgumentException("Probably problem somewhere, encapsulating property value object to another property value.");
        }
        this.value = value;
    }

    public void setValue(T value) {
        this.value = value;
        this.clearDomElement();
    }

    public T getValue() {
        if (this.rawElement != null) {
            ItemDefinition def = null;
            Itemable parent = this.getParent();
            if (parent != null && parent.getDefinition() != null) {
                def = this.getParent().getDefinition();
            }
            if (def == null) {
                if (parent != null && parent.getPrismContext() != null) {
                    def = SchemaRegistry.createDefaultItemDefinition(parent.getName(), parent.getPrismContext());
                } else if (this.rawElement instanceof Element) {
                    this.value = ((Element)this.rawElement).getTextContent();
                } else {
                    throw new IllegalStateException("No parent or prism context in property value " + this + ", cannot create default definition." + "The element is also not a DOM element but it is " + this.rawElement.getClass() + ". Epic fail.");
                }
            }
            if (def != null) {
                try {
                    this.applyDefinition(def);
                }
                catch (SchemaException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
        return this.value;
    }

    public Object getRawElement() {
        return this.rawElement;
    }

    public void setRawElement(Object rawElement) {
        this.rawElement = rawElement;
    }

    @Override
    public boolean isRaw() {
        return this.rawElement != null;
    }

    @Override
    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        if (definition != null && this.rawElement != null) {
            this.value = this.parseRawElementToNewRealValue(this, (PrismPropertyDefinition)definition);
            this.rawElement = null;
        }
    }

    @Override
    public void applyDefinition(ItemDefinition definition, boolean force) throws SchemaException {
        this.applyDefinition(definition);
    }

    @Override
    protected Element createDomElement() {
        return new ElementPrismPropertyImpl(this);
    }

    @Override
    public void checkConsistenceInternal(Itemable rootItem, PropertyPath parentPath) {
        PropertyPath myPath = this.getParent().getPath(parentPath);
        if (this.value == null && this.rawElement == null) {
            throw new IllegalStateException("Neither value nor raw element specified in property value " + this + " (" + myPath + " in " + rootItem + ")");
        }
        if (this.value != null && this.rawElement != null) {
            throw new IllegalStateException("Both value and raw element specified in property value " + this + " (" + myPath + " in " + rootItem + ")");
        }
    }

    @Override
    public PrismPropertyValue<T> clone() {
        PrismPropertyValue<Object> clone = new PrismPropertyValue<Object>(null, this.getType(), this.getSource());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PrismPropertyValue clone) {
        super.copyValues(clone);
        clone.value = this.value;
        clone.rawElement = this.rawElement;
    }

    public static boolean containsRealValue(Collection<PrismPropertyValue<?>> collection, PrismPropertyValue<?> value) {
        for (PrismPropertyValue<?> colVal : collection) {
            if (!value.equalsRealValue(colVal)) continue;
            return true;
        }
        return false;
    }

    public static <T> Collection<PrismPropertyValue<T>> createCollection(Collection<T> realValueCollection) {
        ArrayList<PrismPropertyValue<T>> pvalCol = new ArrayList<PrismPropertyValue<T>>(realValueCollection.size());
        for (T realValue : realValueCollection) {
            PrismPropertyValue<T> pval = new PrismPropertyValue<T>(realValue);
            pvalCol.add(pval);
        }
        return pvalCol;
    }

    public static <T> Collection<PrismPropertyValue<T>> createCollection(T[] realValueArray) {
        ArrayList<PrismPropertyValue<T>> pvalCol = new ArrayList<PrismPropertyValue<T>>(realValueArray.length);
        T[] TArray = realValueArray;
        int n = realValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            T realValue = TArray[n2];
            PrismPropertyValue<T> pval = new PrismPropertyValue<T>(realValue);
            pvalCol.add(pval);
            ++n2;
        }
        return pvalCol;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.value == null || !(this.value instanceof Element)) {
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        }
        return result;
    }

    @Override
    public boolean equals(PrismValue otherValue, boolean ignoreMetadata) {
        PrismPropertyValue<T> thisValue = this;
        if (otherValue instanceof PrismPropertyValue) {
            PrismPropertyValue otherPropertyValue = otherValue;
            if (this.rawElement != null || otherPropertyValue.rawElement != null) {
                try {
                    if (this.rawElement == null) {
                        otherValue = this.parseRawElementToNewValue(otherPropertyValue, this);
                    } else if (otherPropertyValue.rawElement == null) {
                        thisValue = this.parseRawElementToNewValue(this, otherPropertyValue);
                    }
                }
                catch (SchemaException e) {
                    throw new IllegalArgumentException("Error parsing the value of property " + this.getParent() + " using the 'other' definition " + "during a compare: " + e.getMessage(), e);
                }
            }
        }
        return super.equals((PrismValue)thisValue, (PrismValue)otherValue, ignoreMetadata);
    }

    private PrismPropertyValue<T> parseRawElementToNewValue(PrismPropertyValue<T> origValue, PrismPropertyValue<T> definitionSource) throws SchemaException {
        if (definitionSource.getParent() != null && definitionSource.getParent().getDefinition() != null) {
            T parsedRealValue = this.parseRawElementToNewRealValue(origValue, (PrismPropertyDefinition)definitionSource.getParent().getDefinition());
            PrismPropertyValue<T> newPVal = new PrismPropertyValue<T>(parsedRealValue);
            return newPVal;
        }
        throw new IllegalArgumentException("Attempt to use property " + origValue.getParent() + " values in a raw parsing state (raw elements) with parsed value that has no definition");
    }

    private T parseRawElementToNewRealValue(PrismPropertyValue<T> prismPropertyValue, PrismPropertyDefinition definition) throws SchemaException {
        PrismDomProcessor domProcessor = definition.getPrismContext().getPrismDomProcessor();
        return domProcessor.parsePrismPropertyRealValue(prismPropertyValue.rawElement, definition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismPropertyValue other = (PrismPropertyValue)obj;
        return this.equals(this, other);
    }

    @Override
    public boolean equals(PrismValue thisValue, PrismValue otherValue) {
        if (thisValue instanceof PrismPropertyValue && otherValue instanceof PrismPropertyValue) {
            return this.equals((PrismPropertyValue)thisValue, (PrismPropertyValue)otherValue);
        }
        return false;
    }

    public boolean equals(PrismPropertyValue<T> thisValue, PrismPropertyValue<T> otherValue) {
        return !(thisValue.value == null ? otherValue.value != null : !this.compareRealValues(thisValue.value, otherValue.value));
    }

    private boolean compareRealValues(T thisValue, Object otherValue) {
        if (thisValue instanceof Element && otherValue instanceof Element) {
            return DOMUtil.compareElement((Element)((Element)thisValue), (Element)((Element)otherValue), (boolean)false);
        }
        return thisValue.equals(otherValue);
    }

    @Override
    public boolean equalsRealValue(PrismValue thisValue, PrismValue otherValue) {
        if (otherValue instanceof PrismPropertyValue && thisValue instanceof PrismPropertyValue) {
            return this.equalsRealValue((PrismPropertyValue)thisValue, (PrismPropertyValue)otherValue);
        }
        return false;
    }

    public boolean equalsRealValue(PrismPropertyValue<T> thisValue, PrismPropertyValue<T> otherValue) {
        if (otherValue == null) {
            return false;
        }
        if (thisValue.rawElement != null && otherValue.rawElement != null) {
            return this.equalsRawElements(otherValue);
        }
        T otherRealValue = otherValue.getValue();
        if (otherRealValue == null && this.getValue() == null) {
            return true;
        }
        if (otherRealValue == null || this.getValue() == null) {
            return false;
        }
        return this.compareRealValues(this.getValue(), otherRealValue);
    }

    private boolean equalsRawElements(PrismPropertyValue<T> other) {
        if (this.rawElement instanceof Element && other.rawElement instanceof Element) {
            return DOMUtil.compareElement((Element)((Element)this.rawElement), (Element)((Element)other.rawElement), (boolean)false);
        }
        return this.rawElement.equals(other.rawElement);
    }

    public String debugDump() {
        return this.toString();
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append("PPV(");
        this.dumpSuffix(sb);
        sb.append("):");
        if (this.value != null) {
            sb.append(this.value.getClass().getSimpleName()).append(":");
            if (this.value instanceof DebugDumpable) {
                sb.append("\n");
                sb.append(((DebugDumpable)this.value).debugDump(indent + 1));
            } else {
                sb.append(DebugUtil.prettyPrint(this.value));
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public String dump() {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PPV(");
        if (this.value != null) {
            builder.append(this.value.getClass().getSimpleName()).append(":");
            builder.append(DebugUtil.prettyPrint(this.value));
        } else {
            builder.append("null");
        }
        this.dumpSuffix(builder);
        builder.append(")");
        return builder.toString();
    }

    private void dumpSuffix(StringBuilder builder) {
        if (this.getType() != null) {
            builder.append(", type: ");
            builder.append((Object)this.getType());
        }
        if (this.getSource() != null) {
            builder.append(", source: ");
            builder.append(this.getSource());
        }
        if (this.getRawElement() != null) {
            builder.append(", raw element: ");
            builder.append(DebugUtil.prettyPrint((Object)this.getRawElement()));
        }
    }

    public Object getHumanReadableDump() {
        return DebugUtil.prettyPrint(this.value);
    }
}

