/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.util.DebugUtil;
import java.io.Serializable;
import javax.xml.namespace.QName;

public abstract class ItemDefinition
extends Definition
implements Serializable {
    private static final long serialVersionUID = -2643332934312107274L;
    protected QName name;
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private boolean dynamic;

    ItemDefinition(QName name, QName defaultName, QName typeName, PrismContext prismContext) {
        super(defaultName, typeName, prismContext);
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public QName getDefaultName() {
        return this.getName();
    }

    public QName getNameOrDefaultName() {
        if (this.name != null) {
            return this.name;
        }
        return this.defaultName;
    }

    public String getNamespace() {
        return this.getNameOrDefaultName().getNamespaceURI();
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public boolean isSingleValue() {
        return this.getMaxOccurs() >= 0 && this.getMaxOccurs() <= 1;
    }

    public boolean isMultiValue() {
        return this.getMaxOccurs() < 0 || this.getMaxOccurs() > 1;
    }

    public boolean isMandatory() {
        return this.getMinOccurs() > 0;
    }

    public boolean isOptional() {
        return this.getMinOccurs() == 0;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isValidFor(QName elementQName, Class<? extends ItemDefinition> clazz) {
        if (!clazz.isAssignableFrom(this.getClass())) {
            return false;
        }
        return elementQName.equals(this.getName());
    }

    public abstract Item instantiate();

    public abstract Item instantiate(QName var1);

    <T extends ItemDefinition> T findItemDefinition(PropertyPath path, Class<T> clazz) {
        if (path.isEmpty() && clazz.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new IllegalArgumentException("No definition for path " + path + " in " + this);
    }

    public abstract ItemDefinition clone();

    protected void copyDefinitionData(ItemDefinition clone) {
        super.copyDefinitionData(clone);
        clone.name = this.name;
        clone.minOccurs = this.minOccurs;
        clone.maxOccurs = this.maxOccurs;
        clone.dynamic = this.dynamic;
    }

    @Override
    void revive(PrismContext prismContext) {
        if (this.prismContext != null) {
            return;
        }
        this.prismContext = prismContext;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.maxOccurs;
        result = 31 * result + this.minOccurs;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemDefinition other = (ItemDefinition)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.maxOccurs != other.maxOccurs) {
            return false;
        }
        return this.minOccurs == other.minOccurs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDebugDumpClassName());
        sb.append(":");
        sb.append(DebugUtil.prettyPrint((QName)this.getName()));
        sb.append(" (");
        sb.append(DebugUtil.prettyPrint((QName)this.getTypeName()));
        sb.append(")[");
        sb.append(this.minOccurs);
        sb.append(",");
        sb.append(this.maxOccurs);
        sb.append("]");
        if (this.isIgnored()) {
            sb.append(",ignored");
        }
        if (this.isDynamic()) {
            sb.append(",dyn");
        }
        this.extendToString(sb);
        return sb.toString();
    }

    protected void extendToString(StringBuilder sb) {
    }
}

