/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.index.IndexToken;
import org.basex.index.ValuesToken;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Context;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.expr.Range;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.SeqType;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisPath;
import org.basex.query.path.AxisStep;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class CmpG
extends Cmp {
    protected Op op;
    private IndexAccess[] iacc = new IndexAccess[0];
    private boolean atomic;

    public CmpG(InputInfo ii, Expr e1, Expr e2, Op o) {
        super(ii, e1, e2);
        this.op = o;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        super.comp(ctx);
        if (this.swap()) {
            this.op = this.op.swap();
            ctx.compInfo("operands swapped: %", this);
        }
        int e = 0;
        while (e != this.expr.length) {
            this.expr[e] = this.expr[e].addText(ctx);
            ++e;
        }
        Expr e1 = this.expr[0];
        Expr e2 = this.expr[1];
        Expr e3 = this;
        if (this.oneEmpty()) {
            e3 = this.optPre(Bln.FALSE, ctx);
        } else if (this.values()) {
            e3 = this.preEval(ctx);
        } else if (e1.isFun(Function.COUNT)) {
            e3 = this.compCount(this.op.op);
            if (e3 != this) {
                ctx.compInfo(e3 instanceof Bln ? "pre-evaluating %" : "rewriting %", this);
            }
        } else if (e1.isFun(Function.POS)) {
            long[] rng;
            e3 = e2 instanceof Range && this.op.op == CmpV.Op.EQ ? ((rng = ((Range)e2).range(ctx)) == null ? this : Pos.get(rng[0], rng[1], this.input)) : Pos.get(this.op.op, e2, e3, this.input);
            if (e3 != this) {
                ctx.compInfo("rewriting %", this);
            }
        } else if (e1.type().eq(SeqType.BLN) && (this.op == Op.EQ && e2 == Bln.FALSE || this.op == Op.NE && e2 == Bln.TRUE)) {
            e3 = Function.NOT.get(this.input, e1);
        } else {
            e3 = CmpR.get(this);
            if (e3 != this) {
                ctx.compInfo("rewriting %", this);
            }
        }
        this.atomic = e1.type().zeroOrOne() && e2.type().zeroOrOne();
        this.type = SeqType.BLN;
        return e3;
    }

    @Override
    public Expr compEbv(QueryContext ctx) {
        return (this.op == Op.EQ && this.expr[1] == Bln.TRUE || this.op == Op.NE && this.expr[1] == Bln.FALSE) && this.expr[0].type().eq(SeqType.BLN) ? this.expr[0] : this;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it2;
        Item it1;
        boolean s2;
        boolean s1;
        if (this.atomic) {
            Item it12 = this.expr[0].item(ctx, this.input);
            if (it12 == null) {
                return Bln.FALSE;
            }
            Item it22 = this.expr[1].item(ctx, this.input);
            if (it22 == null) {
                return Bln.FALSE;
            }
            return Bln.get(this.eval(it12, it22));
        }
        Iter ir1 = ctx.iter(this.expr[0]);
        long is1 = ir1.size();
        if (is1 == 0L) {
            return Bln.FALSE;
        }
        boolean bl = s1 = is1 == 1L;
        if (s1 && this.expr[1].size() == 1L) {
            return Bln.get(this.eval(ir1.next(), this.expr[1].item(ctx, this.input)));
        }
        Iter ir2 = ctx.iter(this.expr[1]);
        long is2 = ir2.size();
        if (is2 == 0L) {
            return Bln.FALSE;
        }
        boolean bl2 = s2 = is2 == 1L;
        if (s1 && s2) {
            return Bln.get(this.eval(ir1.next(), ir2.next()));
        }
        if (s2) {
            Item it13;
            Item it23 = ir2.next();
            while ((it13 = ir1.next()) != null) {
                if (!this.eval(it13, it23)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        if (!ir2.reset()) {
            ItemCache ic = new ItemCache();
            it1 = ir1.next();
            if (it1 != null) {
                while ((it2 = ir2.next()) != null) {
                    if (this.eval(it1, it2)) {
                        return Bln.TRUE;
                    }
                    ic.add(it2);
                }
            }
            ir2 = ic;
        }
        while ((it1 = ir1.next()) != null) {
            ir2.reset();
            while ((it2 = ir2.next()) != null) {
                if (!this.eval(it1, it2)) continue;
                return Bln.TRUE;
            }
        }
        return Bln.FALSE;
    }

    private boolean eval(Item a, Item b) throws QueryException {
        if (!(a.type == b.type || (a.unt() || b.unt() || a.str() && b.str() || a.num() && b.num() || a.func() || b.func()) && a.type != AtomType.QNM && b.type != AtomType.QNM)) {
            Err.XPTYPECMP.thrw(this.input, a.type, b.type);
        }
        return this.op.op.e(this.input, a, b);
    }

    @Override
    public CmpG invert() {
        return this.expr[0].size() != 1L || this.expr[1].size() != 1L ? this : new CmpG(this.input, this.expr[0], this.expr[1], this.op.invert());
    }

    boolean union(CmpG g, QueryContext ctx) throws QueryException {
        if (this.op != g.op || !this.expr[0].sameAs(g.expr[0])) {
            return false;
        }
        this.expr[1] = new List(this.input, this.expr[1], g.expr[1]).comp(ctx);
        this.atomic = this.atomic && this.expr[1].type().zeroOrOne();
        return true;
    }

    @Override
    public boolean indexAccessible(IndexContext ic) throws QueryException {
        Item it;
        boolean attr;
        AxisStep s;
        if (this.op != Op.EQ) {
            return false;
        }
        AxisStep axisStep = s = this.expr[0] instanceof Context ? ic.step : CmpG.indexStep(this.expr[0]);
        if (s == null) {
            return false;
        }
        boolean text = s.test.type == NodeType.TXT && ic.data.meta.textindex;
        boolean bl = attr = s.test.type == NodeType.ATT && ic.data.meta.attrindex;
        if (!text && !attr) {
            return false;
        }
        IndexToken.IndexType ind = text ? IndexToken.IndexType.TEXT : IndexToken.IndexType.ATTRIBUTE;
        Expr arg = this.expr[1];
        if (!arg.value()) {
            SeqType t = arg.type();
            if (arg.uses(Expr.Use.CTX) || !t.type.str() && !t.type.node()) {
                return false;
            }
            ic.addCosts(ic.data.meta.size / 10);
            this.iacc = Array.add(this.iacc, new IndexAccess(this.input, arg, ind, ic));
            return true;
        }
        Iter ir = arg.iter(ic.ctx);
        ic.costs(0);
        while ((it = ir.next()) != null) {
            SeqType t = it.type();
            if (!t.type.str() && !t.type.node()) {
                return false;
            }
            int is = ic.data.nrIDs(new ValuesToken(ind, it.atom(this.input)));
            if (is == 0) continue;
            this.iacc = Array.add(this.iacc, new IndexAccess(this.input, it, ind, ic));
            ic.addCosts(is);
        }
        return true;
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) {
        boolean text = this.iacc[0].itype == IndexToken.IndexType.TEXT;
        ic.ctx.compInfo(text ? "applying text index" : "applying attribute index", new Object[0]);
        ParseExpr root = this.iacc.length == 1 ? this.iacc[0] : new Union(this.input, this.iacc);
        return ic.invert(this.expr[0], root, text);
    }

    public static AxisStep indexStep(Expr expr) {
        if (!(expr instanceof AxisPath)) {
            return null;
        }
        AxisPath path = (AxisPath)expr;
        return path.root != null ? null : path.step(path.step.length - 1);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{QueryText.OP, Token.token(this.op.name)});
        Expr[] exprArray = this.expr;
        int n = this.expr.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            e.plan(ser);
            ++n2;
        }
        ser.closeElement();
    }

    @Override
    public String desc() {
        return "'" + (Object)((Object)this.op) + "' expression";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + " ");
    }

    public static enum Op {
        LE("<=", CmpV.Op.LE){

            @Override
            public Op swap() {
                return GE;
            }

            @Override
            public Op invert() {
                return LT;
            }
        }
        ,
        LT("<", CmpV.Op.LT){

            @Override
            public Op swap() {
                return GT;
            }

            @Override
            public Op invert() {
                return GE;
            }
        }
        ,
        GE(">=", CmpV.Op.GE){

            @Override
            public Op swap() {
                return LE;
            }

            @Override
            public Op invert() {
                return LT;
            }
        }
        ,
        GT(">", CmpV.Op.GT){

            @Override
            public Op swap() {
                return LT;
            }

            @Override
            public Op invert() {
                return LE;
            }
        }
        ,
        EQ("=", CmpV.Op.EQ){

            @Override
            public Op swap() {
                return EQ;
            }

            @Override
            public Op invert() {
                return NE;
            }
        }
        ,
        NE("!=", CmpV.Op.NE){

            @Override
            public Op swap() {
                return NE;
            }

            @Override
            public Op invert() {
                return EQ;
            }
        };

        public final String name;
        final CmpV.Op op;

        private Op(String n2, CmpV.Op c) {
            this.name = n2;
            this.op = c;
        }

        public abstract Op swap();

        public abstract Op invert();

        public String toString() {
            return this.name;
        }
    }
}

