/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.random;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.basex.data.MetaData;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.io.random.Buffer;
import org.basex.io.random.Buffers;
import org.basex.io.random.TableAccess;
import org.basex.util.Array;
import org.basex.util.BitArray;
import org.basex.util.Util;

public final class TableDiskAccess
extends TableAccess {
    private final Buffers bm = new Buffers();
    private final RandomAccessFile file;
    protected final String pref;
    private int[] fpres;
    private int[] pages;
    private BitArray pagemap;
    private int fpre = -1;
    private int npre = -1;
    private int allBlocks;
    private int blocks;
    private int index = -1;

    public TableDiskAccess(MetaData md, String pf) throws IOException {
        super(md);
        this.pref = pf;
        DataInput in = new DataInput(this.meta.dbfile(String.valueOf(pf) + 'i'));
        this.allBlocks = in.readNum();
        this.blocks = in.readNum();
        this.fpres = in.readNums();
        this.pages = in.readNums();
        int psize = in.readNum();
        if (psize == 0) {
            this.pagemap = new BitArray(this.allBlocks);
            int[] nArray = this.pages;
            int n = this.pages.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                this.pagemap.set(p);
                ++n2;
            }
            this.dirty = true;
        } else {
            this.pagemap = new BitArray(in.readLongs(psize), this.allBlocks);
        }
        in.close();
        this.file = new RandomAccessFile(this.meta.dbfile(pf), "rw");
        this.readIndex(0);
    }

    @Override
    public synchronized void flush() throws IOException {
        Buffer[] bufferArray = this.bm.all();
        int n = bufferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer b = bufferArray[n2];
            if (b.dirty) {
                this.writeBlock(b);
            }
            ++n2;
        }
        if (!this.dirty) {
            return;
        }
        DataOutput out = new DataOutput(this.meta.dbfile(String.valueOf(this.pref) + 'i'));
        out.writeNum(this.allBlocks);
        out.writeNum(this.blocks);
        out.writeNums(this.fpres);
        out.writeNums(this.pages);
        out.writeLongs(this.pagemap.toArray());
        out.close();
        this.dirty = false;
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.file.close();
    }

    @Override
    public synchronized int read1(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return b[o] & 0xFF;
    }

    @Override
    public synchronized int read2(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return ((b[o] & 0xFF) << 8) + (b[o + 1] & 0xFF);
    }

    @Override
    public synchronized int read4(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return ((b[o] & 0xFF) << 24) + ((b[o + 1] & 0xFF) << 16) + ((b[o + 2] & 0xFF) << 8) + (b[o + 3] & 0xFF);
    }

    @Override
    public synchronized long read5(int pre, int off) {
        int o = off + this.cursor(pre);
        byte[] b = this.bm.current().data;
        return ((long)(b[o] & 0xFF) << 32) + ((long)(b[o + 1] & 0xFF) << 24) + (long)((b[o + 2] & 0xFF) << 16) + (long)((b[o + 3] & 0xFF) << 8) + (long)(b[o + 4] & 0xFF);
    }

    @Override
    public void write1(int pre, int off, int v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)v;
        bf.dirty = true;
    }

    @Override
    public void write2(int pre, int off, int v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)(v >>> 8);
        b[o + 1] = (byte)v;
        bf.dirty = true;
    }

    @Override
    public void write4(int pre, int off, int v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)(v >>> 24);
        b[o + 1] = (byte)(v >>> 16);
        b[o + 2] = (byte)(v >>> 8);
        b[o + 3] = (byte)v;
        bf.dirty = true;
    }

    @Override
    public void write5(int pre, int off, long v) {
        int o = off + this.cursor(pre);
        Buffer bf = this.bm.current();
        byte[] b = bf.data;
        b[o] = (byte)(v >>> 32);
        b[o + 1] = (byte)(v >>> 24);
        b[o + 2] = (byte)(v >>> 16);
        b[o + 3] = (byte)(v >>> 8);
        b[o + 4] = (byte)v;
        bf.dirty = true;
    }

    @Override
    protected void copy(byte[] entries, int pre, int last) {
        int o = 0;
        int i = pre;
        while (i < last) {
            int off = this.cursor(i);
            Buffer bf = this.bm.current();
            System.arraycopy(entries, o, bf.data, off, 16);
            bf.dirty = true;
            ++i;
            o += 16;
        }
    }

    @Override
    public void delete(int pre, int nr) {
        if (nr == 0) {
            return;
        }
        this.dirty = true;
        this.cursor(pre);
        int from = pre - this.fpre;
        int last = pre + nr;
        if (last - 1 < this.npre) {
            Buffer bf = this.bm.current();
            this.copy(bf.data, from + nr, bf.data, from, this.npre - last);
            this.updatePre(nr);
            if (this.npre == this.fpre) {
                this.pagemap.clear(this.pages[this.index]);
                Array.move(this.fpres, this.index + 1, -1, this.blocks - this.index - 1);
                Array.move(this.pages, this.index + 1, -1, this.blocks - this.index - 1);
                --this.blocks;
                this.readIndex(this.index);
            }
            return;
        }
        int unused = 0;
        while (this.npre < last) {
            if (from == 0) {
                ++unused;
                this.pagemap.clear(this.pages[this.index]);
            }
            this.readIndex(this.index + 1);
            from = 0;
        }
        Buffer bf = this.bm.current();
        if (this.npre == last) {
            this.pagemap.clear((int)bf.pos);
            ++unused;
            if (this.index < this.blocks - 1) {
                this.readIndex(this.index + 1);
            } else {
                ++this.index;
            }
        } else {
            this.copy(bf.data, last - this.fpre, bf.data, 0, this.npre - last);
        }
        if (unused > 0) {
            Array.move(this.fpres, this.index, -unused, this.blocks - this.index);
            Array.move(this.pages, this.index, -unused, this.blocks - this.index);
            this.blocks -= unused;
            this.index -= unused;
        }
        this.fpres[this.index] = pre;
        this.fpre = pre;
        this.updatePre(nr);
    }

    @Override
    public void insert(int pre, byte[] entries) {
        int newBlocks;
        if (entries.length == 0) {
            return;
        }
        this.dirty = true;
        int split = this.cursor(pre - 1) + 16;
        int nr = entries.length >>> 4;
        int nold = this.npre - this.fpre << 4;
        int moved = nold - split;
        Buffer bf = this.bm.current();
        if (nold + entries.length <= 4096) {
            System.arraycopy(bf.data, split, bf.data, split + entries.length, moved);
            System.arraycopy(entries, 0, bf.data, split, entries.length);
            bf.dirty = true;
            int i = this.index + 1;
            while (i < this.blocks) {
                int n = i++;
                this.fpres[n] = this.fpres[n] + nr;
            }
            this.npre += nr;
            this.meta.size += nr;
            return;
        }
        byte[] all = new byte[entries.length + moved];
        System.arraycopy(entries, 0, all, 0, entries.length);
        System.arraycopy(bf.data, split, all, entries.length, moved);
        int n = bf.data.length - split;
        if (n > 0) {
            System.arraycopy(all, 0, bf.data, split, n);
            bf.dirty = true;
        }
        int neededBlocks = (all.length - n) / 4096;
        int remain = (all.length - n) % 4096;
        if (remain > 0) {
            if (this.index + 1 < this.blocks) {
                int o = this.occSpace(this.index + 1) << 4;
                if (remain <= 4096 - o) {
                    this.readIndex(this.index + 1);
                    bf = this.bm.current();
                    System.arraycopy(bf.data, 0, bf.data, remain, o);
                    System.arraycopy(all, all.length - remain, bf.data, 0, remain);
                    bf.dirty = true;
                    int n2 = this.index;
                    this.fpres[n2] = this.fpres[n2] - (remain >>> 4);
                    this.readIndex(this.index - 1);
                } else {
                    ++neededBlocks;
                }
            } else {
                ++neededBlocks;
            }
        }
        if ((newBlocks = neededBlocks - (this.allBlocks - this.blocks)) > 0) {
            this.fpres = Arrays.copyOf(this.fpres, this.fpres.length + newBlocks);
            this.pages = Arrays.copyOf(this.pages, this.pages.length + newBlocks);
        }
        Array.move(this.fpres, this.index + 1, neededBlocks, this.blocks - this.index - 1);
        Array.move(this.pages, this.index + 1, neededBlocks, this.blocks - this.index - 1);
        while (neededBlocks-- > 0) {
            this.freeBlock();
            n += this.write(all, n);
            this.fpres[this.index] = this.fpres[this.index - 1] + 256;
            this.pages[this.index] = (int)this.bm.current().pos;
        }
        int i = this.index + 1;
        while (i < this.blocks) {
            int n3 = i++;
            this.fpres[n3] = this.fpres[n3] + nr;
        }
        this.meta.size += nr;
        this.fpre = this.fpres[this.index];
        this.npre = this.index + 1 < this.blocks && this.fpres[this.index + 1] < this.meta.size ? this.fpres[this.index + 1] : this.meta.size;
    }

    private int cursor(int pre) {
        int fp = this.fpre;
        int np = this.npre;
        if (pre < fp || pre >= np) {
            int last = this.blocks - 1;
            int l = 0;
            int h = last;
            int m = this.index;
            while (l <= h) {
                if (pre < fp) {
                    h = m - 1;
                } else {
                    if (pre < np) break;
                    l = m + 1;
                }
                m = h + l >>> 1;
                fp = this.fpres[m];
                int n = np = m == last ? this.meta.size : this.fpres[m + 1];
            }
            if (l > h) {
                Util.notexpected("Data Access out of bounds [pre:" + pre + ", indexSize:" + this.blocks + ", access:" + l + " > " + h + "]");
            }
            this.readIndex(m);
        }
        return pre - this.fpre << 4;
    }

    private void readIndex(int i) {
        this.index = i;
        this.fpre = this.fpres[i];
        this.npre = i + 1 >= this.blocks ? this.meta.size : this.fpres[i + 1];
        this.readBlock(this.pages[i]);
    }

    private void readBlock(int b) {
        if (!this.bm.cursor(b)) {
            return;
        }
        Buffer bf = this.bm.current();
        try {
            if (bf.dirty) {
                this.writeBlock(bf);
            }
            bf.pos = b;
            if (b >= this.allBlocks) {
                this.allBlocks = b + 1;
            } else {
                this.file.seek(bf.pos * 4096L);
                this.file.readFully(bf.data);
            }
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    private void freeBlock() {
        int b = this.pagemap.nextClearBit(0);
        this.pagemap.set(b);
        this.readBlock(b);
        ++this.blocks;
        ++this.index;
    }

    private void writeBlock(Buffer bf) throws IOException {
        this.file.seek(bf.pos * 4096L);
        this.file.write(bf.data);
        bf.dirty = false;
    }

    private void updatePre(int nr) {
        int i = this.index + 1;
        while (i < this.blocks) {
            int n = i++;
            this.fpres[n] = this.fpres[n] - nr;
        }
        this.meta.size -= nr;
        this.npre = this.index + 1 < this.blocks && this.fpres[this.index + 1] < this.meta.size ? this.fpres[this.index + 1] : this.meta.size;
    }

    private void copy(byte[] s, int sp, byte[] d, int dp, int l) {
        System.arraycopy(s, sp << 4, d, dp << 4, l << 4);
        this.bm.current().dirty = true;
    }

    private int write(byte[] s, int o) {
        Buffer bf = this.bm.current();
        int len = Math.min(bf.data.length, s.length - o);
        System.arraycopy(s, o, bf.data, 0, len);
        bf.dirty = true;
        return len;
    }

    private int occSpace(int i) {
        return (i + 1 < this.blocks ? this.fpres[i + 1] : this.meta.size) - this.fpres[i];
    }
}

