/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync.action;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.ChangeExecutor;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.controller.ModelController;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.SynchronizationException;
import com.evolveum.midpoint.model.sync.action.ActivationDecision;
import com.evolveum.midpoint.model.synchronizer.UserSynchronizer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectSynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;

public abstract class BaseAction
implements Action {
    private static final Trace LOGGER = TraceManager.getTrace(BaseAction.class);
    private UserSynchronizer synchronizer;
    private ChangeExecutor executor;
    private ModelController model;
    private List<Object> parameters;
    private PrismContext prismContext;
    private AuditService auditService;

    public AuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    @Override
    public List<Object> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    @Override
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    protected Element getParameterElement(QName qname) {
        Validate.notNull((Object)qname, (String)"QName must not be null.");
        List<Object> parameters = this.getParameters();
        Element element = null;
        for (Object object : parameters) {
            Element parameter;
            if (!(object instanceof Element) || !(parameter = (Element)object).getLocalName().equals(qname.getLocalPart()) || !qname.getNamespaceURI().equals(parameter.getNamespaceURI())) continue;
            element = parameter;
            break;
        }
        return element;
    }

    protected UserType getUser(String oid, OperationResult result) throws SynchronizationException {
        if (StringUtils.isEmpty((String)oid)) {
            return null;
        }
        try {
            return this.model.getObjectResolver().getObject(UserType.class, oid, result);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        catch (Exception ex) {
            throw new SynchronizationException("Can't get user with oid '" + oid + "'. Unknown error occurred.", ex);
        }
        return null;
    }

    @Override
    public String executeChanges(String userOid, ResourceObjectShadowChangeDescription change, SynchronizationSituationType situation, AuditEventRecord auditRecord, Task task, OperationResult result) throws SynchronizationException {
        Validate.notNull((Object)change, (String)"Resource object change description must not be null.");
        Validate.notNull((Object)situation, (String)"Synchronization situation must not be null.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        return null;
    }

    public void setModel(ModelController model) {
        this.model = model;
    }

    protected ModelController getModel() {
        return this.model;
    }

    public void setSynchronizer(UserSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public ChangeExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ChangeExecutor executor) {
        this.executor = executor;
    }

    protected AccountSyncContext createAccountSyncContext(SyncContext context, ResourceObjectShadowChangeDescription change, PolicyDecision policyDecision, ActivationDecision activationDecision) throws SchemaException {
        LOGGER.debug("Creating account context for sync change.");
        ResourceType resource = (ResourceType)change.getResource().asObjectable();
        String accountType = this.getAccountTypeFromChange(change);
        ResourceAccountType resourceAccount = new ResourceAccountType(resource.getOid(), accountType);
        AccountSyncContext accountContext = context.createAccountSyncContext(resourceAccount);
        accountContext.setResource(resource);
        accountContext.setOid(this.getOidFromChange(change));
        ObjectDelta delta = change.getObjectDelta();
        if (delta != null && AccountShadowType.class.isAssignableFrom(delta.getObjectTypeClass())) {
            accountContext.setAccountSyncDelta((ObjectDelta<AccountShadowType>)delta);
        }
        accountContext.setAccountOld(this.getAccountObject(change));
        accountContext.setPolicyDecision(policyDecision);
        if (activationDecision != null) {
            this.updateAccountActivation(accountContext, activationDecision);
        }
        boolean doReconciliation = this.determineAttributeReconciliation(change);
        accountContext.setDoReconciliation(doReconciliation);
        LOGGER.debug("Setting account context policy decision ({}), activation decision ({}), do reconciliation ({})", new Object[]{policyDecision, activationDecision, doReconciliation});
        return accountContext;
    }

    private void updateAccountActivation(AccountSyncContext accContext, ActivationDecision activationDecision) throws SchemaException {
        PrismPropertyValue value;
        PrismObject<AccountShadowType> object = accContext.getAccountOld();
        if (object == null) {
            LOGGER.debug("Account object is null, skipping activation property check/update.");
            return;
        }
        PrismProperty enable = object.findOrCreateProperty(SchemaConstants.PATH_ACTIVATION_ENABLE);
        LOGGER.debug("Account activation defined, activation property found {}", (Object)enable);
        ObjectDelta accDelta = accContext.getAccountSecondaryDelta();
        if (accDelta == null) {
            accDelta = new ObjectDelta(AccountShadowType.class, ChangeType.MODIFY);
            accDelta.setOid(accContext.getOid());
            accContext.setAccountSecondaryDelta((ObjectDelta<AccountShadowType>)accDelta);
        }
        if ((value = enable.getValue(Boolean.class)) != null) {
            Boolean isEnabled = (Boolean)value.getValue();
            if (isEnabled == null) {
                this.createActivationPropertyDelta(accDelta, activationDecision, null);
            }
            if (isEnabled.booleanValue() && ActivationDecision.DISABLE.equals((Object)activationDecision) || !isEnabled.booleanValue() && ActivationDecision.ENABLE.equals((Object)activationDecision)) {
                this.createActivationPropertyDelta(accDelta, activationDecision, isEnabled);
            }
        } else {
            this.createActivationPropertyDelta(accDelta, activationDecision, null);
        }
    }

    private boolean determineAttributeReconciliation(ResourceObjectShadowChangeDescription change) {
        ObjectSynchronizationType synchronization = ResourceTypeUtil.determineSynchronization((ResourceType)((ResourceType)change.getResource().asObjectable()), UserType.class);
        Boolean reconcileAttributes = synchronization.isReconcileAttributes();
        if (reconcileAttributes == null) {
            reconcileAttributes = change.getCurrentShadow() != null;
            LOGGER.trace("Attribute reconciliation automatic mode: {}", (Object)reconcileAttributes);
        } else {
            LOGGER.trace("Attribute reconciliation manual mode: {}", (Object)reconcileAttributes);
        }
        return reconcileAttributes;
    }

    private PrismObject<AccountShadowType> getAccountObject(ResourceObjectShadowChangeDescription change) throws SchemaException {
        AccountShadowType account = this.getAccountShadowFromChange(change);
        if (account == null) {
            return null;
        }
        RefinedResourceSchema.getRefinedSchema((ResourceType)((ResourceType)change.getResource().asObjectable()), (PrismContext)this.getPrismContext()).getObjectDefinition(account);
        return account.asPrismObject();
    }

    protected AccountShadowType getAccountShadowFromChange(ResourceObjectShadowChangeDescription change) {
        if (change.getCurrentShadow() != null) {
            return (AccountShadowType)change.getCurrentShadow().asObjectable();
        }
        if (change.getOldShadow() != null) {
            return (AccountShadowType)change.getOldShadow().asObjectable();
        }
        return null;
    }

    private String getAccountTypeFromChange(ResourceObjectShadowChangeDescription change) {
        AccountShadowType account = this.getAccountShadowFromChange(change);
        if (account != null) {
            return account.getAccountType();
        }
        LOGGER.warn("Can't get account type from change (resource {}), because current and old shadow are null. Therefore we can't create account sync context.", (Object)change.getResource().getName());
        return null;
    }

    private String getOidFromChange(ResourceObjectShadowChangeDescription change) {
        if (change.getObjectDelta() != null) {
            return change.getObjectDelta().getOid();
        }
        return change.getCurrentShadow().getOid();
    }

    protected void synchronizeUser(SyncContext context, OperationResult result) throws SynchronizationException {
        try {
            Validate.notNull((Object)context, (String)"Sync context must not be null.");
            Validate.notNull((Object)result, (String)"Operation result must not be null.");
            this.synchronizer.synchronizeUser(context, result);
        }
        catch (Exception ex) {
            throw new SynchronizationException("Couldn't synchronize user, reason: " + ex.getMessage(), ex);
        }
    }

    protected void executeChanges(SyncContext context, OperationResult result) throws SynchronizationException {
        try {
            Validate.notNull((Object)context, (String)"Sync context must not be null.");
            this.getExecutor().executeChanges(context, result);
        }
        catch (Exception ex) {
            throw new SynchronizationException("Couldn't execute changes from context, reason: " + ex.getMessage(), ex);
        }
    }

    protected void createActivationPropertyDelta(ObjectDelta<?> objectDelta, ActivationDecision activationDecision, Boolean oldValue) {
        LOGGER.debug("Updating activation for {}, activation decision {}, old value was {}", new Object[]{objectDelta.getClass().getSimpleName(), activationDecision, oldValue});
        PropertyDelta delta = objectDelta.findPropertyDelta(SchemaConstants.PATH_ACTIVATION_ENABLE);
        if (delta == null) {
            delta = PropertyDelta.createDelta((PropertyPath)SchemaConstants.PATH_ACTIVATION_ENABLE, ResourceObjectShadowType.class, (PrismContext)this.getPrismContext());
            objectDelta.addModification((ItemDelta)delta);
        }
        delta.clear();
        Boolean newValue = ActivationDecision.ENABLE.equals((Object)activationDecision) ? Boolean.TRUE : Boolean.FALSE;
        PrismPropertyValue value = new PrismPropertyValue((Object)newValue, SourceType.SYNC_ACTION, null);
        if (oldValue == null) {
            delta.addValueToAdd((PrismValue)value);
        } else {
            ArrayList<PrismPropertyValue> values = new ArrayList<PrismPropertyValue>();
            values.add(value);
            delta.setValuesToReplace(values);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} activation property delta: {}", new Object[]{objectDelta.getClass().getSimpleName(), delta.debugDump()});
        }
    }
}

