/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync;

import com.evolveum.midpoint.model.ChangeExecutor;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.api.PolicyViolationException;
import com.evolveum.midpoint.model.synchronizer.UserSynchronizer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecomputeTaskHandler
implements TaskHandler {
    public static final String HANDLER_URI = "http://midpoint.evolveum.com/model/sync/recompute-handler-1";
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private UserSynchronizer userSynchronizer;
    @Autowired
    private ChangeExecutor changeExecutor;
    private static final transient Trace LOGGER = TraceManager.getTrace(RecomputeTaskHandler.class);
    private static final int SEARCH_MAX_SIZE = 100;

    @PostConstruct
    private void initialize() {
        this.taskManager.registerHandler(HANDLER_URI, (TaskHandler)this);
    }

    public TaskRunResult run(Task task) {
        LOGGER.trace("RecomputeTaskHandler.run starting");
        long progress = task.getProgress();
        OperationResult opResult = new OperationResult("com.evolveum.midpoint.common.operation.reconciliation");
        TaskRunResult runResult = new TaskRunResult();
        runResult.setOperationResult(opResult);
        try {
            this.performUserRecompute(task, opResult);
        }
        catch (ObjectNotFoundException ex) {
            LOGGER.error("Recompute: Object does not exist: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Object does not exist: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (ObjectAlreadyExistsException ex) {
            LOGGER.error("Recompute: Object already exist: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Object already exist: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (CommunicationException ex) {
            LOGGER.error("Recompute: Communication error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordPartialError("Communication error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (SchemaException ex) {
            LOGGER.error("Recompute: Error dealing with schema: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Error dealing with schema: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (PolicyViolationException ex) {
            LOGGER.error("Recompute: Policy violation: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Policy violation: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (ExpressionEvaluationException ex) {
            LOGGER.error("Recompute: Error evaluating expression: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Error evaluating expression: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (RuntimeException ex) {
            LOGGER.error("Recompute: Internal Error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Internal Error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Recompute: Configuration error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (SecurityViolationException ex) {
            LOGGER.error("Recompute: Security violation: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Security violation: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        opResult.computeStatus("Recompute run has failed");
        runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        runResult.setProgress(progress);
        LOGGER.trace("Recompute.run stopping");
        return runResult;
    }

    private void performUserRecompute(Task task, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException, CommunicationException, ObjectAlreadyExistsException, ConfigurationException, PolicyViolationException, SecurityViolationException {
        PagingType paging = new PagingType();
        int offset = 0;
        while (true) {
            paging.setOffset(Integer.valueOf(offset));
            paging.setMaxSize(Integer.valueOf(100));
            List users = this.repositoryService.listObjects(UserType.class, paging, result);
            if (users == null || users.isEmpty()) break;
            for (PrismObject user : users) {
                OperationResult subResult = result.createSubresult("com.evolveum.midpoint.common.operation.reconciliation.user");
                subResult.addContext("object", (Object)user);
                this.recomputeUser((PrismObject<UserType>)user, subResult);
            }
            offset += 100;
        }
    }

    private void recomputeUser(PrismObject<UserType> user, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException, CommunicationException, ObjectAlreadyExistsException, ConfigurationException, PolicyViolationException, SecurityViolationException {
        LOGGER.trace("Reconciling user {}", user);
        SyncContext syncContext = new SyncContext(this.prismContext);
        syncContext.setUserOld(user);
        syncContext.setUserOid(user.getOid());
        syncContext.setChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_RECON));
        syncContext.setDoReconciliationForAllAccounts(true);
        this.userSynchronizer.synchronizeUser(syncContext, result);
        LOGGER.trace("Reconciling of user {}: context:\n{}", user, (Object)syncContext.dump());
        this.changeExecutor.executeChanges(syncContext, result);
        LOGGER.trace("Reconciling of user {}: {}", user, (Object)result.getStatus());
    }

    public Long heartbeat(Task task) {
        return 0L;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "UserRecomputation";
    }

    public List<String> getCategoryNames() {
        return null;
    }
}

