/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema.util;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ImportOptionsType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CachingMetadataType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;

public class MiscSchemaUtil {
    private static Random rnd = new Random();

    public static ObjectListType toObjectListType(List<PrismObject<? extends ObjectType>> list) {
        ObjectListType listType = new ObjectListType();
        for (PrismObject<? extends ObjectType> o : list) {
            listType.getObject().add((ObjectType)o.asObjectable());
        }
        return listType;
    }

    public static <T extends ObjectType> List<PrismObject<T>> toList(Class<T> type, ObjectListType listType) {
        ArrayList<PrismObject<T>> list = new ArrayList<PrismObject<T>>();
        for (ObjectType o : listType.getObject()) {
            list.add(o.asPrismObject());
        }
        return list;
    }

    public static ImportOptionsType getDefaultImportOptions() {
        ImportOptionsType options = new ImportOptionsType();
        options.setOverwrite(false);
        options.setValidateStaticSchema(true);
        options.setValidateDynamicSchema(true);
        options.setEncryptProtectedValues(true);
        options.setFetchResourceSchema(false);
        options.setSummarizeErrors(true);
        options.setSummarizeSucceses(true);
        return options;
    }

    public static CachingMetadataType generateCachingMetadata() {
        CachingMetadataType cmd = new CachingMetadataType();
        XMLGregorianCalendar xmlGregorianCalendarNow = XmlTypeConverter.createXMLGregorianCalendar((long)System.currentTimeMillis());
        cmd.setRetrievalTimestamp(xmlGregorianCalendarNow);
        cmd.setSerialNumber(MiscSchemaUtil.generateSerialNumber());
        return cmd;
    }

    private static String generateSerialNumber() {
        return String.valueOf(Long.toHexString(rnd.nextLong())) + "-" + Long.toHexString(rnd.nextLong());
    }

    public static boolean isNullOrEmpty(ProtectedStringType ps) {
        return ps == null || ps.getClearValue() == null && ps.getEncryptedData() == null;
    }

    public static void setPassword(CredentialsType credentials, ProtectedStringType password) {
        PasswordType credPass = credentials.getPassword();
        if (credPass == null) {
            credPass = new PasswordType();
            credentials.setPassword(credPass);
        }
        credPass.setProtectedString(password);
    }

    public static Collection<String> toCollection(String entry) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(entry);
        return list;
    }

    public static Collection<PropertyPath> itemReferenceListTypeToItemPathList(PropertyReferenceListType resolve) {
        ArrayList<PropertyPath> itemPathList = new ArrayList<PropertyPath>(resolve.getProperty().size());
        for (Element itemXPathElement : resolve.getProperty()) {
            XPathHolder itemXPath = new XPathHolder(itemXPathElement);
            itemPathList.add(itemXPath.toPropertyPath());
        }
        return itemPathList;
    }
}

