/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAttachmentContentCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public GetAttachmentContentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        AttachmentEntity attachment = dbSqlSession.selectById(AttachmentEntity.class, this.attachmentId);
        String contentId = attachment.getContentId();
        if (contentId == null) {
            return null;
        }
        ByteArrayEntity byteArray = dbSqlSession.selectById(ByteArrayEntity.class, contentId);
        byte[] bytes = byteArray.getBytes();
        return new ByteArrayInputStream(bytes);
    }
}

