/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.repo.sql.data.common.RValueType;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Columns;

@MappedSuperclass
public abstract class RValue<T> {
    private boolean dynamic;
    private QName name;
    private QName type;
    private RValueType valueType;

    @Columns(columns={@Column(name="name_namespace"), @Column(name="name_localPart")})
    public QName getName() {
        return this.name;
    }

    @Columns(columns={@Column(name="type_namespace"), @Column(name="type_localPart")})
    public QName getType() {
        return this.type;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public RValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(RValueType valueType) {
        this.valueType = valueType;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setType(QName type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RValue rValue = (RValue)o;
        if (this.dynamic != rValue.dynamic) {
            return false;
        }
        if (this.name != null ? !this.name.equals(rValue.name) : rValue.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(rValue.type) : rValue.type != null) {
            return false;
        }
        return this.valueType == rValue.valueType;
    }

    public int hashCode() {
        int result = this.dynamic ? 1 : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @Transient
    public abstract T getValue();

    @Column(name="dynamicDef")
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }
}

