/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.execution;

import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.NodeErrorStatus;
import com.evolveum.midpoint.task.api.NodeExecutionStatus;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskManagerException;
import com.evolveum.midpoint.task.api.TaskManagerInitializationException;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerConfiguration;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.TaskQuartzImplUtil;
import com.evolveum.midpoint.task.quartzimpl.execution.ExecutionManager;
import com.evolveum.midpoint.task.quartzimpl.execution.JobExecutor;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;

public class LocalNodeManager {
    private static final transient Trace LOGGER = TraceManager.getTrace(LocalNodeManager.class);
    private TaskManagerQuartzImpl taskManager;

    public LocalNodeManager(TaskManagerQuartzImpl taskManager) {
        this.taskManager = taskManager;
    }

    void initializeScheduler() throws TaskManagerInitializationException {
        TaskManagerConfiguration configuration = this.taskManager.getConfiguration();
        Properties quartzProperties = new Properties();
        if (configuration.isJdbcJobStore()) {
            quartzProperties.put("org.quartz.jobStore.class", "org.quartz.impl.jdbcjobstore.JobStoreTX");
            quartzProperties.put("org.quartz.jobStore.driverDelegateClass", configuration.getJdbcDriverDelegateClass());
            quartzProperties.put("org.quartz.jobStore.dataSource", "myDS");
            this.createQuartzDbSchema();
            quartzProperties.put("org.quartz.dataSource.myDS.driver", configuration.getJdbcDriver());
            quartzProperties.put("org.quartz.dataSource.myDS.URL", configuration.getJdbcUrl());
            quartzProperties.put("org.quartz.dataSource.myDS.user", configuration.getJdbcUser());
            quartzProperties.put("org.quartz.dataSource.myDS.password", configuration.getJdbcPassword());
            quartzProperties.put("org.quartz.jobStore.isClustered", configuration.isClustered() ? "true" : "false");
        } else {
            quartzProperties.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        }
        quartzProperties.put("org.quartz.scheduler.instanceName", "midPointScheduler");
        quartzProperties.put("org.quartz.scheduler.instanceId", this.taskManager.getNodeId());
        quartzProperties.put("org.quartz.scheduler.skipUpdateCheck", "true");
        quartzProperties.put("org.quartz.threadPool.threadCount", Integer.toString(configuration.getThreads()));
        int schedulerLoopTime = configuration.isTestMode() ? (configuration.isJdbcJobStore() ? 5000 : 2000) : 10000;
        quartzProperties.put("org.quartz.scheduler.idleWaitTime", Integer.toString(schedulerLoopTime));
        quartzProperties.put("org.quartz.scheduler.jmx.export", "true");
        if (configuration.isTestMode()) {
            LOGGER.info("ReusableQuartzScheduler is set: the task manager threads will NOT be stopped on shutdown. Also, scheduler threads will run as daemon ones.");
            quartzProperties.put("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            quartzProperties.put("org.quartz.threadPool.makeThreadsDaemons", "true");
        }
        try {
            LOGGER.trace("Quartz scheduler properties: {}", (Object)quartzProperties);
            StdSchedulerFactory sf = new StdSchedulerFactory();
            sf.initialize(quartzProperties);
            this.getGlobalExecutionManager().setQuartzScheduler(sf.getScheduler());
        }
        catch (SchedulerException e) {
            throw new TaskManagerInitializationException("Cannot initialize the Quartz scheduler", (Throwable)e);
        }
    }

    private void createQuartzDbSchema() throws TaskManagerInitializationException {
        TaskManagerConfiguration configuration = this.taskManager.getConfiguration();
        try {
            Class.forName(configuration.getJdbcDriver());
        }
        catch (ClassNotFoundException e) {
            throw new TaskManagerInitializationException("Could not locate database driver class " + configuration.getJdbcDriver(), (Throwable)e);
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(configuration.getJdbcUrl(), configuration.getJdbcUser(), configuration.getJdbcPassword());
        }
        catch (SQLException e) {
            throw new TaskManagerInitializationException("Cannot create JDBC connection to Quartz Job Store", (Throwable)e);
        }
        try {
            try {
                connection.prepareStatement("SELECT count(*) FROM qrtz_job_details").executeQuery().close();
            }
            catch (SQLException sQLException) {
                try {
                    connection.prepareStatement(this.getResource(configuration.getSqlSchemaFile())).executeUpdate();
                }
                catch (IOException ex) {
                    throw new TaskManagerInitializationException("Could not read Quartz database schema file: " + configuration.getSqlSchemaFile(), (Throwable)ex);
                }
                catch (SQLException e) {
                    throw new TaskManagerInitializationException("Could not create Quartz JDBC Job Store tables from " + configuration.getSqlSchemaFile(), (Throwable)e);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {}
    }

    private String getResource(String name) throws IOException, TaskManagerInitializationException {
        int i;
        InputStream stream = this.getClass().getResourceAsStream(name);
        if (stream == null) {
            throw new TaskManagerInitializationException("Quartz DB schema (" + name + ") cannot be found.");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuffer sb = new StringBuffer();
        while ((i = br.read()) != -1) {
            sb.append((char)i);
        }
        return sb.toString();
    }

    void pauseScheduler(OperationResult result) {
        LOGGER.info("Putting Quartz scheduler into standby mode");
        try {
            this.getQuartzScheduler().standby();
            result.recordSuccess();
        }
        catch (SchedulerException e1) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't put local Quartz scheduler into standby mode", (Throwable)e1, (Object[])new Object[0]);
            result.recordFatalError("Couldn't put local Quartz scheduler into standby mode", (Throwable)e1);
        }
    }

    void shutdownScheduler() throws TaskManagerException {
        LOGGER.info("Shutting down Quartz scheduler");
        try {
            if (this.getQuartzScheduler() != null && !this.getQuartzScheduler().isShutdown()) {
                this.getQuartzScheduler().shutdown(true);
            }
            LOGGER.info("Quartz scheduler was shut down");
        }
        catch (SchedulerException e) {
            throw new TaskManagerException("Cannot shutdown Quartz scheduler", (Throwable)e);
        }
    }

    private Scheduler getQuartzScheduler() {
        return this.getGlobalExecutionManager().getQuartzScheduler();
    }

    boolean stopSchedulerAndTasks(long timeToWait, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(LocalNodeManager.class.getName()) + ".stopSchedulerAndTasks");
        result.addParam("timeToWait", (Object)timeToWait);
        this.pauseScheduler(result);
        boolean tasksStopped = this.getGlobalExecutionManager().stopAllTasksOnThisNodeAndWait(timeToWait, result);
        LOGGER.info("Scheduler stopped; " + (tasksStopped ? "all task threads have been stopped as well." : "some task threads may still run."));
        result.recordSuccessIfUnknown();
        return tasksStopped;
    }

    void stopScheduler(OperationResult result) {
        this.pauseScheduler(result);
    }

    void startScheduler(OperationResult result) {
        if (this.taskManager.isInErrorState()) {
            String message = "Cannot start the scheduler, because Task Manager is in error state (" + this.taskManager.getLocalNodeErrorStatus() + ")";
            LOGGER.error(message);
            result.recordFatalError(message);
            return;
        }
        try {
            LOGGER.info("Starting the Quartz scheduler");
            this.getQuartzScheduler().start();
            LOGGER.debug("Quartz scheduler started.");
            result.recordSuccess();
        }
        catch (SchedulerException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot (re)start Quartz scheduler.", (Throwable)e, (Object[])new Object[0]);
            result.recordFatalError("Cannot (re)start Quartz scheduler.", (Throwable)e);
        }
    }

    public NodeExecutionStatus getLocalNodeExecutionStatus() {
        boolean quartzRunning;
        if (this.taskManager.getLocalNodeErrorStatus() != NodeErrorStatus.OK) {
            return NodeExecutionStatus.ERROR;
        }
        Scheduler quartzScheduler = this.getGlobalExecutionManager().getQuartzScheduler();
        if (quartzScheduler == null) {
            return NodeExecutionStatus.COMMUNICATION_ERROR;
        }
        try {
            quartzRunning = quartzScheduler.isStarted() && !quartzScheduler.isInStandbyMode() && !quartzScheduler.isShutdown();
        }
        catch (SchedulerException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot determine Quartz scheduler state", (Throwable)e, (Object[])new Object[0]);
            return NodeExecutionStatus.COMMUNICATION_ERROR;
        }
        return quartzRunning ? NodeExecutionStatus.RUNNING : NodeExecutionStatus.PAUSED;
    }

    void stopLocalTaskRun(String oid, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(LocalNodeManager.class.getName()) + ".stopLocalTaskRun");
        result.addParam("task", (Object)oid);
        LOGGER.info("Stopping local task " + oid + " run");
        try {
            this.getQuartzScheduler().interrupt(TaskQuartzImplUtil.createJobKeyForTaskOid(oid));
            result.recordSuccess();
        }
        catch (UnableToInterruptJobException e) {
            String message = "Unable to interrupt the task " + oid;
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            result.recordFatalError(message, (Throwable)e);
        }
    }

    void interruptLocalTaskThread(String oid) {
        LOGGER.trace("Trying to find and interrupt a local execution thread for task {} (if it exists).", (Object)oid);
        try {
            List jecs = this.getQuartzScheduler().getCurrentlyExecutingJobs();
            for (JobExecutionContext jec : jecs) {
                String oid1 = jec.getJobDetail().getKey().getName();
                if (!oid.equals(oid1)) continue;
                Job job = jec.getJobInstance();
                if (job instanceof JobExecutor) {
                    JobExecutor jobExecutor = (JobExecutor)job;
                    jobExecutor.sendThreadInterrupt();
                }
                break;
            }
        }
        catch (SchedulerException e1) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot find the currently executing job for the task {}", (Throwable)e1, (Object[])new Object[]{oid});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isTaskThreadActiveLocally(String oid) {
        try {
            JobExecutionContext jec;
            Iterator iterator = this.getQuartzScheduler().getCurrentlyExecutingJobs().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!oid.equals((jec = (JobExecutionContext)iterator.next()).getJobDetail().getKey().getName()));
            return true;
        }
        catch (SchedulerException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get the list of currently executing jobs", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
    }

    Set<Task> getLocallyRunningTasks(OperationResult parentResult) {
        List jecs;
        OperationResult result = parentResult.createSubresult(String.valueOf(LocalNodeManager.class.getName()) + ".getLocallyRunningTasks");
        HashSet<Task> retval = new HashSet<Task>();
        try {
            jecs = this.getQuartzScheduler().getCurrentlyExecutingJobs();
        }
        catch (SchedulerException e1) {
            String message = "Cannot get the list of currently executing jobs on local node.";
            result.recordFatalError(message, (Throwable)e1);
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e1, (Object[])new Object[0]);
            return retval;
        }
        for (JobExecutionContext jec : jecs) {
            String oid = jec.getJobDetail().getKey().getName();
            try {
                retval.add(this.taskManager.getTask(oid, result));
            }
            catch (ObjectNotFoundException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get the task with OID {} as it no longer exists", (Throwable)e, (Object[])new Object[]{oid});
            }
            catch (SchemaException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get the task with OID {} due to schema problems", (Throwable)e, (Object[])new Object[]{oid});
            }
        }
        result.computeStatus();
        return retval;
    }

    private OperationResult createOperationResult(String methodName) {
        return new OperationResult(String.valueOf(LocalNodeManager.class.getName()) + "." + methodName);
    }

    public ExecutionManager getGlobalExecutionManager() {
        return this.taskManager.getExecutionManager();
    }
}

