/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.lang;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumeratedType
extends StringValue {
    private static final long serialVersionUID = 1L;
    private static final Map<String, List<EnumeratedType>> valueListByClass = Generics.newConcurrentHashMap();

    public EnumeratedType(String name) {
        super(name);
        EnumeratedType.getValues(this.getClass()).add(this);
    }

    public static List<EnumeratedType> getValues(Class<? extends EnumeratedType> c) {
        List<EnumeratedType> valueList = valueListByClass.get(c.getName());
        if (valueList == null) {
            valueList = new ArrayList<EnumeratedType>();
            valueListByClass.put(c.getName(), valueList);
        }
        return valueList;
    }

    public Object readResolve() throws ObjectStreamException {
        EnumeratedType result = this;
        List<EnumeratedType> values = EnumeratedType.getValues(this.getClass());
        for (EnumeratedType value : values) {
            if (value.toString() == null || !value.toString().equals(this.toString())) continue;
            result = value;
            break;
        }
        return result;
    }
}

