/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.PropertyPathSegment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class PropertyPath
implements Serializable {
    public static final PropertyPath EMPTY_PATH = new PropertyPath();
    private List<PropertyPathSegment> segments;

    public PropertyPath() {
        this.segments = new ArrayList<PropertyPathSegment>(0);
    }

    public PropertyPath(QName ... qnames) {
        this.segments = new ArrayList<PropertyPathSegment>(qnames.length);
        QName[] qNameArray = qnames;
        int n = qnames.length;
        int n2 = 0;
        while (n2 < n) {
            QName qname = qNameArray[n2];
            this.add(qname);
            ++n2;
        }
    }

    public PropertyPath(PropertyPath parentPath, QName subName) {
        this.segments = new ArrayList<PropertyPathSegment>(parentPath.segments.size() + 1);
        this.segments.addAll(parentPath.segments);
        this.add(subName);
    }

    public PropertyPath(List<PropertyPathSegment> segments) {
        this.segments = new ArrayList<PropertyPathSegment>(segments.size());
        this.segments.addAll(segments);
    }

    public PropertyPath(List<PropertyPathSegment> segments, PropertyPathSegment subSegment) {
        this.segments = new ArrayList<PropertyPathSegment>(segments.size() + 1);
        this.segments.addAll(segments);
        this.segments.add(subSegment);
    }

    public PropertyPath(List<PropertyPathSegment> segments, QName subName) {
        this.segments = new ArrayList<PropertyPathSegment>(segments.size() + 1);
        this.segments.addAll(segments);
        this.add(subName);
    }

    public PropertyPath(PropertyPathSegment ... segments) {
        this.segments = new ArrayList<PropertyPathSegment>(segments.length);
        PropertyPathSegment[] propertyPathSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyPathSegment seg = propertyPathSegmentArray[n2];
            this.segments.add(seg);
            ++n2;
        }
    }

    public PropertyPath(PropertyPath parentPath, PropertyPathSegment subSegment) {
        this.segments = new ArrayList<PropertyPathSegment>(parentPath.segments.size() + 1);
        this.segments.addAll(parentPath.segments);
        this.segments.add(subSegment);
    }

    public PropertyPath subPath(QName subName) {
        return new PropertyPath(this.segments, subName);
    }

    public PropertyPath subPath(PropertyPathSegment subSegment) {
        return new PropertyPath(this.segments, subSegment);
    }

    private void add(QName qname) {
        this.segments.add(new PropertyPathSegment(qname));
    }

    public List<PropertyPathSegment> getSegments() {
        return this.segments;
    }

    public PropertyPathSegment first() {
        if (this.segments.size() == 0) {
            return null;
        }
        return this.segments.get(0);
    }

    public PropertyPath rest() {
        if (this.segments.size() == 0) {
            return EMPTY_PATH;
        }
        return new PropertyPath(this.segments.subList(1, this.segments.size()));
    }

    public PropertyPathSegment last() {
        if (this.segments.size() == 0) {
            return null;
        }
        return this.segments.get(this.segments.size() - 1);
    }

    public PropertyPath allExceptLast() {
        if (this.segments.size() == 0) {
            return EMPTY_PATH;
        }
        return new PropertyPath(this.segments.subList(0, this.segments.size() - 1));
    }

    public int size() {
        return this.segments.size();
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<PropertyPathSegment> iterator = this.segments.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyPath other = (PropertyPath)obj;
        return !(this.segments == null ? other.segments != null : !this.segments.equals(other.segments));
    }
}

