/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.plot;

import java.util.Arrays;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.data.StatsKey;
import org.basex.gui.view.plot.PlotAxis;
import org.basex.index.Names;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class PlotData {
    final Context context;
    final PlotAxis xAxis;
    final PlotAxis yAxis;
    int[] pres;
    byte[] item = Token.EMPTY;

    PlotData(Context ctx) {
        this.xAxis = new PlotAxis(this);
        this.yAxis = new PlotAxis(this);
        this.pres = new int[0];
        this.context = ctx;
    }

    TokenList getItems() {
        Data data = this.context.data;
        TokenList tl = new TokenList();
        if (data.meta.pathindex) {
            for (byte[] k : data.pthindex.desc(Token.EMPTY, data, true, true)) {
                if (this.getCategories(k).size() <= 1) continue;
                tl.add(k);
            }
        }
        return tl;
    }

    TokenList getCategories(byte[] it) {
        Data data = this.context.data;
        TokenList tl = new TokenList();
        if (data.meta.pathindex) {
            for (byte[] k : data.pthindex.desc(it, data, true, false)) {
                Names index;
                Names names = index = Token.startsWith(k, 64) ? data.atnindex : data.tagindex;
                if (index.stat((int)index.id((byte[])Token.delete((byte[])k, (int)64))).kind == StatsKey.Kind.NONE) continue;
                tl.add(k);
            }
        }
        return tl;
    }

    boolean setItem(String newItem) {
        if (newItem == null) {
            return false;
        }
        byte[] b = Token.token(newItem);
        if (Token.eq(b, this.item)) {
            return false;
        }
        this.item = b;
        this.refreshItems(this.context.current, true);
        return true;
    }

    void refreshItems(Nodes nodes, boolean sub) {
        int[] contextPres;
        Data data = this.context.data;
        IntList tmpPres = new IntList();
        int itmID = data.tagindex.id(this.item);
        if (!sub) {
            this.pres = nodes.list;
            Arrays.sort(this.pres);
            return;
        }
        int[] nArray = contextPres = nodes.list;
        int n = contextPres.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            int nl = p + data.size(p, 1);
            while (p < nl) {
                int kind = data.kind(p);
                if (kind == 1) {
                    if (data.name(p) == itmID) {
                        tmpPres.add(p);
                    }
                    p += data.attSize(p, kind);
                    continue;
                }
                ++p;
            }
            ++n2;
        }
        this.pres = tmpPres.toArray();
        Arrays.sort(this.pres);
    }

    int findPre(int pre) {
        return Arrays.binarySearch(this.pres, pre);
    }
}

