/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesAccessor {
    final Set<Attribute> _attrs;
    final Map<String, Attribute> _attrMap;

    public AttributesAccessor(Set<Attribute> attrs) {
        this._attrs = attrs;
        this._attrMap = AttributeUtil.toMap(attrs);
    }

    public Attribute find(String name) {
        return this._attrMap.get(name);
    }

    public Name getName() {
        return (Name)this.find(Name.NAME);
    }

    public Uid getUid() {
        return (Uid)this.find(Uid.NAME);
    }

    public boolean getEnabled(boolean dflt) {
        boolean e = dflt;
        Attribute enable = this.find(OperationalAttributes.ENABLE_NAME);
        if (enable != null) {
            e = AttributeUtil.getBooleanValue(enable);
        }
        return e;
    }

    public GuardedString getPassword() {
        Attribute a = this.find(OperationalAttributes.PASSWORD_NAME);
        return a == null ? null : AttributeUtil.getGuardedStringValue(a);
    }

    public List<Object> findList(String name) {
        Attribute a = this.find(name);
        return a == null ? null : a.getValue();
    }

    public List<String> findStringList(String name) {
        List<Object> l = this.findList(name);
        if (l != null) {
            ArrayList<String> ret = new ArrayList<String>(l.size());
            for (Object o : l) {
                ret.add((String)o);
            }
            return ret;
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.find(name) != null;
    }

    public String findString(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getStringValue(a);
    }

    public Integer findInteger(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getIntegerValue(a);
    }

    public Long findLong(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getLongValue(a);
    }

    public Date findDate(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getDateValue(a);
    }

    public Double findDouble(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getDoubleValue(a);
    }

    public BigDecimal findBigDecimal(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getBigDecimalValue(a);
    }

    public Boolean findBoolean(String name) {
        Attribute a = this.find(name);
        return a == null ? null : AttributeUtil.getBooleanValue(a);
    }
}

