/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.workqueue;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.management.JMException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueImplMBeanWrapper;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.workqueue.WorkQueueManagerImpl;

public class AutomaticWorkQueueImpl
extends ThreadPoolExecutor
implements AutomaticWorkQueue {
    static final int DEFAULT_MAX_QUEUE_SIZE = 256;
    private static final Logger LOG = LogUtils.getL7dLogger(AutomaticWorkQueueImpl.class);
    int maxQueueSize;
    DelayQueue<DelayedTaskWrapper> delayQueue = new DelayQueue();
    WatchDog watchDog = new WatchDog(this.delayQueue);
    WorkQueueManagerImpl manager;
    String name = "default";
    final int corePoolSize;
    final int maxPoolSize;
    final ReentrantLock mainLock;

    public AutomaticWorkQueueImpl() {
        this(256);
    }

    public AutomaticWorkQueueImpl(String name) {
        this(256, name);
    }

    public AutomaticWorkQueueImpl(int max) {
        this(max, "default");
    }

    public AutomaticWorkQueueImpl(int max, String name) {
        this(max, 0, 25, 5, 120000L, name);
    }

    public AutomaticWorkQueueImpl(int mqs, int initialThreads, int highWaterMark, int lowWaterMark, long dequeueTimeout) {
        this(mqs, initialThreads, highWaterMark, lowWaterMark, dequeueTimeout, "default");
    }

    public AutomaticWorkQueueImpl(int mqs, int initialThreads, int highWaterMark, int lowWaterMark, long dequeueTimeout, String name) {
        super(-1 == lowWaterMark ? Integer.MAX_VALUE : lowWaterMark, -1 == highWaterMark ? Integer.MAX_VALUE : highWaterMark, TimeUnit.MILLISECONDS.toMillis(dequeueTimeout), TimeUnit.MILLISECONDS, mqs == -1 ? new LinkedBlockingQueue<Runnable>(256) : new LinkedBlockingQueue(mqs), AutomaticWorkQueueImpl.createThreadFactory(name));
        this.maxQueueSize = mqs == -1 ? 256 : mqs;
        lowWaterMark = -1 == lowWaterMark ? Integer.MAX_VALUE : lowWaterMark;
        highWaterMark = -1 == highWaterMark ? Integer.MAX_VALUE : highWaterMark;
        StringBuilder buf = new StringBuilder();
        buf.append("Constructing automatic work queue with:\n");
        buf.append("max queue size: " + this.maxQueueSize + "\n");
        buf.append("initialThreads: " + initialThreads + "\n");
        buf.append("lowWaterMark: " + lowWaterMark + "\n");
        buf.append("highWaterMark: " + highWaterMark + "\n");
        LOG.fine(buf.toString());
        if (initialThreads > highWaterMark) {
            initialThreads = highWaterMark;
        }
        if (initialThreads < Integer.MAX_VALUE && initialThreads > 0) {
            this.setCorePoolSize(initialThreads);
            int started = this.prestartAllCoreThreads();
            if (started < initialThreads) {
                LOG.log(Level.WARNING, "THREAD_START_FAILURE_MSG", new Object[]{started, initialThreads});
            }
            this.setCorePoolSize(lowWaterMark);
        }
        this.watchDog.setDaemon(true);
        this.watchDog.start();
        this.corePoolSize = this.getCorePoolSize();
        this.maxPoolSize = this.getMaximumPoolSize();
        ReentrantLock l = null;
        try {
            Field f = ThreadPoolExecutor.class.getDeclaredField("mainLock");
            f.setAccessible(true);
            l = (ReentrantLock)f.get(this);
        }
        catch (Throwable t) {
            l = new ReentrantLock();
        }
        this.mainLock = l;
    }

    private static ThreadFactory createThreadFactory(final String name) {
        ThreadGroup group;
        try {
            group = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup group;
                    try {
                        for (ThreadGroup parent = group = Thread.currentThread().getThreadGroup(); parent != null; parent = parent.getParent()) {
                            group = parent;
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new ThreadGroup(group, name + "-workqueue");
                }
            });
        }
        catch (SecurityException e) {
            group = new ThreadGroup(name + "-workqueue");
        }
        return new AWQThreadFactory(group, name);
    }

    @Resource(name="org.apache.cxf.workqueue.WorkQueueManager")
    public void setManager(WorkQueueManager mgr) {
        this.manager = (WorkQueueManagerImpl)mgr;
    }

    public WorkQueueManager getManager() {
        return this.manager;
    }

    public void setName(String s) {
        this.name = s;
        ThreadFactory factory = this.getThreadFactory();
        if (factory instanceof AWQThreadFactory) {
            ((AWQThreadFactory)factory).setName(s);
        }
    }

    public String getName() {
        return this.name;
    }

    @PostConstruct
    public void register() {
        if (this.manager != null) {
            this.manager.addNamedWorkQueue(this.name, this);
            InstrumentationManager imanager = (InstrumentationManager)this.manager.getBus().getExtension(InstrumentationManager.class);
            if (null != imanager) {
                try {
                    imanager.register((ManagedComponent)new WorkQueueImplMBeanWrapper(this));
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, jmex.getMessage(), jmex);
                }
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append(" [queue size: ");
        buf.append(this.getSize());
        buf.append(", max size: ");
        buf.append(this.maxQueueSize);
        buf.append(", threads: ");
        buf.append(this.getPoolSize());
        buf.append(", active threads: ");
        buf.append(this.getActiveCount());
        buf.append(", low water mark: ");
        buf.append(this.getLowWaterMark());
        buf.append(", high water mark: ");
        buf.append(this.getHighWaterMark());
        buf.append("]");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable command) {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ClassLoader orig = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(loader);
                    command.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(orig);
                }
            }
        };
        super.execute(r);
        if (!this.getQueue().isEmpty() && this.getPoolSize() < this.maxPoolSize) {
            this.mainLock.lock();
            try {
                int ps = this.getPoolSize();
                int sz = this.getQueue().size();
                int sz2 = this.getActiveCount();
                if (sz + sz2 > ps) {
                    Method m = ThreadPoolExecutor.class.getDeclaredMethod("addIfUnderMaximumPoolSize", Runnable.class);
                    m.setAccessible(true);
                    m.invoke((Object)this, new Object[1]);
                }
            }
            catch (Exception ex) {
            }
            finally {
                this.mainLock.unlock();
            }
        }
    }

    public void execute(Runnable work, long timeout) {
        try {
            this.execute(work);
        }
        catch (RejectedExecutionException ree) {
            try {
                this.getQueue().offer(work, timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                throw new RejectedExecutionException(ie);
            }
        }
    }

    public void schedule(Runnable work, long delay) {
        this.delayQueue.put(new DelayedTaskWrapper(work, delay));
    }

    public void shutdown(boolean processRemainingWorkItems) {
        if (!processRemainingWorkItems) {
            this.getQueue().clear();
        }
        this.shutdown();
    }

    protected void terminated() {
        ThreadFactory f = this.getThreadFactory();
        if (f instanceof AWQThreadFactory) {
            ((AWQThreadFactory)f).shutdown();
        }
        this.watchDog.shutdown();
    }

    public long getMaxSize() {
        return this.maxQueueSize;
    }

    public long getSize() {
        return this.getQueue().size();
    }

    public boolean isEmpty() {
        return this.getQueue().size() == 0;
    }

    boolean isFull() {
        return this.getQueue().remainingCapacity() == 0;
    }

    public int getHighWaterMark() {
        int hwm = this.getMaximumPoolSize();
        return hwm == Integer.MAX_VALUE ? -1 : hwm;
    }

    public int getLowWaterMark() {
        int lwm = this.getCorePoolSize();
        return lwm == Integer.MAX_VALUE ? -1 : lwm;
    }

    public void setHighWaterMark(int hwm) {
        this.setMaximumPoolSize(hwm < 0 ? Integer.MAX_VALUE : hwm);
    }

    public void setLowWaterMark(int lwm) {
        this.setCorePoolSize(lwm < 0 ? 0 : lwm);
    }

    static class AWQThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        ThreadGroup group;
        String name;
        ClassLoader loader;

        AWQThreadFactory(ThreadGroup gp, String nm) {
            this.group = gp;
            this.name = nm;
            this.loader = AutomaticWorkQueueImpl.class.getClassLoader();
        }

        public Thread newThread(Runnable r) {
            if (this.group.isDestroyed()) {
                this.group = new ThreadGroup(this.group.getParent(), this.name + "-workqueue");
            }
            Thread t = new Thread(this.group, r, this.name + "-workqueue-" + this.threadNumber.getAndIncrement(), 0L);
            t.setContextClassLoader(this.loader);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }

        public void setName(String s) {
            this.name = s;
        }

        public void shutdown() {
            if (!this.group.isDestroyed()) {
                try {
                    this.group.destroy();
                    this.group.setDaemon(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WatchDog
    extends Thread {
        DelayQueue<DelayedTaskWrapper> delayQueue;
        AtomicBoolean shutdown = new AtomicBoolean(false);

        WatchDog(DelayQueue<DelayedTaskWrapper> queue) {
            this.delayQueue = queue;
        }

        public void shutdown() {
            this.shutdown.set(true);
            this.interrupt();
        }

        @Override
        public void run() {
            block5: {
                try {
                    while (!this.shutdown.get()) {
                        DelayedTaskWrapper task = (DelayedTaskWrapper)this.delayQueue.take();
                        if (task == null) continue;
                        try {
                            AutomaticWorkQueueImpl.this.execute(task);
                        }
                        catch (Exception ex) {
                            LOG.warning("Executing the task from DelayQueue with exception: " + ex);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.finer("The DelayQueue watchdog Task is stopping");
                }
            }
        }
    }

    static class DelayedTaskWrapper
    implements Delayed,
    Runnable {
        long trigger;
        Runnable work;

        DelayedTaskWrapper(Runnable work, long delay) {
            this.work = work;
            this.trigger = System.currentTimeMillis() + delay;
        }

        public long getDelay(TimeUnit unit) {
            long n = this.trigger - System.currentTimeMillis();
            return unit.convert(n, TimeUnit.MILLISECONDS);
        }

        public int compareTo(Delayed delayed) {
            long other = ((DelayedTaskWrapper)delayed).trigger;
            int returnValue = this.trigger < other ? -1 : (this.trigger > other ? 1 : 0);
            return returnValue;
        }

        public void run() {
            this.work.run();
        }
    }
}

