/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.prism.delta.ReferenceDelta;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.util.PrismAsserts;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class ObjectDelta<T extends Objectable>
implements Dumpable,
DebugDumpable,
Serializable {
    private ChangeType changeType;
    private String oid;
    private PrismObject<T> objectToAdd;
    private Collection<? extends ItemDelta> modifications;
    private Class<T> objectTypeClass;

    public ObjectDelta(Class<T> objectTypeClass, ChangeType changeType) {
        this.changeType = changeType;
        this.objectTypeClass = objectTypeClass;
        this.objectToAdd = null;
        this.modifications = this.createEmptyModifications();
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public static boolean isAdd(ObjectDelta<?> objectDelta) {
        if (objectDelta == null) {
            return false;
        }
        return objectDelta.isAdd();
    }

    public boolean isAdd() {
        return this.changeType == ChangeType.ADD;
    }

    public static boolean isDelete(ObjectDelta<?> objectDelta) {
        if (objectDelta == null) {
            return false;
        }
        return objectDelta.isDelete();
    }

    public boolean isDelete() {
        return this.changeType == ChangeType.DELETE;
    }

    public static boolean isModify(ObjectDelta<?> objectDelta) {
        if (objectDelta == null) {
            return false;
        }
        return objectDelta.isModify();
    }

    public boolean isModify() {
        return this.changeType == ChangeType.MODIFY;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public PrismObject<T> getObjectToAdd() {
        return this.objectToAdd;
    }

    public void setObjectToAdd(PrismObject<T> objectToAdd) {
        if (this.getChangeType() != ChangeType.ADD) {
            throw new IllegalStateException("Cannot set object to " + (Object)((Object)this.getChangeType()) + " delta");
        }
        this.objectToAdd = objectToAdd;
        if (objectToAdd != null) {
            this.objectTypeClass = objectToAdd.getCompileTimeClass();
        }
    }

    public Collection<? extends ItemDelta> getModifications() {
        return this.modifications;
    }

    public void addModification(ItemDelta itemDelta) {
        if (this.getChangeType() != ChangeType.MODIFY) {
            throw new IllegalStateException("Cannot add modifications to " + (Object)((Object)this.getChangeType()) + " delta");
        }
        this.modifications.add(itemDelta);
    }

    public void addModifications(Collection<? extends ItemDelta> itemDeltas) {
        for (ItemDelta itemDelta : itemDeltas) {
            this.addModification(itemDelta);
        }
    }

    public void addModifications(ItemDelta<?> ... itemDeltas) {
        ItemDelta<?>[] itemDeltaArray = itemDeltas;
        int n = itemDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDelta<?> modDelta = itemDeltaArray[n2];
            this.addModification(modDelta);
            ++n2;
        }
    }

    public ItemDelta<?> findItemDelta(PropertyPath propertyPath) {
        return this.findItemDelta(propertyPath, ItemDelta.class, Item.class);
    }

    private <D extends ItemDelta, I extends Item> D findItemDelta(PropertyPath propertyPath, Class<D> deltaType, Class<I> itemType) {
        if (this.changeType == ChangeType.ADD) {
            I item = this.objectToAdd.findItem(propertyPath, itemType);
            if (item == null) {
                return null;
            }
            D itemDelta = this.createEmptyDelta(propertyPath, ((Item)item).getDefinition(), deltaType, item.getClass());
            ((ItemDelta)itemDelta).addValuesToAdd(((Item)item).getClonedValues());
            return itemDelta;
        }
        if (this.changeType == ChangeType.MODIFY) {
            return this.findModification(propertyPath, deltaType);
        }
        return null;
    }

    public boolean hasItemDelta(PropertyPath propertyPath) {
        if (this.changeType == ChangeType.ADD) {
            Item item = this.objectToAdd.findItem(propertyPath, Item.class);
            return item != null;
        }
        if (this.changeType == ChangeType.MODIFY) {
            ItemDelta modification = this.findModification(propertyPath, ItemDelta.class);
            return modification != null;
        }
        return false;
    }

    private <D extends ItemDelta, I extends Item> D createEmptyDelta(PropertyPath propertyPath, ItemDefinition itemDef, Class<D> deltaType, Class<I> itemType) {
        if (PrismProperty.class.isAssignableFrom(itemType)) {
            return (D)new PropertyDelta(propertyPath, (PrismPropertyDefinition)itemDef);
        }
        if (PrismContainer.class.isAssignableFrom(itemType)) {
            return (D)new ContainerDelta(propertyPath, (PrismContainerDefinition)itemDef);
        }
        if (PrismReference.class.isAssignableFrom(itemType)) {
            return (D)new ReferenceDelta(propertyPath, (PrismReferenceDefinition)itemDef);
        }
        throw new IllegalArgumentException("Unknown item type " + itemType);
    }

    public Class<T> getObjectTypeClass() {
        return this.objectTypeClass;
    }

    public void setObjectTypeClass(Class<T> objectTypeClass) {
        this.objectTypeClass = objectTypeClass;
    }

    public PropertyDelta findPropertyDelta(QName propertyName) {
        return this.findPropertyDelta(new PropertyPath(propertyName));
    }

    public PropertyDelta findPropertyDelta(PropertyPath parentPath, QName propertyName) {
        return this.findPropertyDelta(new PropertyPath(parentPath, propertyName));
    }

    public PropertyDelta findPropertyDelta(PropertyPath propertyPath) {
        return this.findItemDelta(propertyPath, PropertyDelta.class, PrismProperty.class);
    }

    public <X extends Containerable> ContainerDelta<X> findContainerDelta(PropertyPath propertyPath) {
        return this.findItemDelta(propertyPath, ContainerDelta.class, PrismContainer.class);
    }

    public <X extends Containerable> ContainerDelta<X> findContainerDelta(QName name) {
        return this.findContainerDelta(new PropertyPath(name));
    }

    private <D extends ItemDelta> D findModification(PropertyPath propertyPath, Class<D> deltaType) {
        if (this.modifications == null) {
            return null;
        }
        for (ItemDelta itemDelta : this.modifications) {
            if (!deltaType.isAssignableFrom(itemDelta.getClass()) || !itemDelta.getPath().equals(propertyPath)) continue;
            return (D)itemDelta;
        }
        return null;
    }

    private <D extends ItemDelta> D findModification(QName itemName, Class<D> deltaType) {
        return this.findModification(new PropertyPath(itemName), deltaType);
    }

    public ReferenceDelta findReferenceModification(QName itemName) {
        return this.findModification(itemName, ReferenceDelta.class);
    }

    public boolean isEmpty() {
        if (this.getChangeType() == ChangeType.DELETE) {
            return false;
        }
        if (this.getChangeType() == ChangeType.ADD) {
            return this.objectToAdd == null || this.objectToAdd.isEmpty();
        }
        if (this.modifications == null || this.modifications.isEmpty()) {
            return true;
        }
        for (ItemDelta itemDelta : this.modifications) {
            if (itemDelta.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void applyDefinition(PrismObjectDefinition<T> definition) throws SchemaException {
        if (this.objectToAdd != null) {
            this.objectToAdd.applyDefinition(definition);
        }
        ItemDelta.applyDefinition(this.getModifications(), definition);
    }

    public ObjectDelta<T> clone() {
        ObjectDelta<T> clone = new ObjectDelta<T>(this.objectTypeClass, this.changeType);
        clone.oid = this.oid;
        clone.modifications = this.createEmptyModifications();
        clone.modifications.addAll(this.modifications);
        clone.objectToAdd = this.objectToAdd == null ? null : this.objectToAdd.clone();
        return clone;
    }

    public void merge(ObjectDelta<T> deltaToMerge) throws SchemaException {
        if (this.changeType == ChangeType.ADD) {
            if (deltaToMerge.changeType == ChangeType.ADD) {
                throw new IllegalArgumentException("Cannot merge two ADD deltas: " + this + ", " + deltaToMerge);
            }
            if (deltaToMerge.changeType == ChangeType.MODIFY) {
                if (this.objectToAdd == null) {
                    throw new IllegalStateException("objectToAdd is null");
                }
                deltaToMerge.applyTo(this.objectToAdd);
            } else if (deltaToMerge.changeType == ChangeType.DELETE) {
                this.changeType = ChangeType.DELETE;
            }
        } else if (this.changeType == ChangeType.MODIFY) {
            if (deltaToMerge.changeType == ChangeType.ADD) {
                throw new IllegalArgumentException("Cannot merge 'add' delta to a 'modify' object delta");
            }
            if (deltaToMerge.changeType == ChangeType.MODIFY) {
                throw new UnsupportedOperationException();
            }
            if (deltaToMerge.changeType == ChangeType.DELETE) {
                this.changeType = ChangeType.DELETE;
            }
        } else if (deltaToMerge.changeType == ChangeType.ADD) {
            this.changeType = ChangeType.ADD;
            this.objectToAdd = deltaToMerge.objectToAdd;
        } else if (deltaToMerge.changeType != ChangeType.MODIFY) {
            ChangeType cfr_ignored_0 = deltaToMerge.changeType;
        }
    }

    public static <T extends Objectable> ObjectDelta<T> union(ObjectDelta<T> ... deltas) throws SchemaException {
        ArrayList<ObjectDelta<T>> modifyDeltas = new ArrayList<ObjectDelta<T>>(deltas.length);
        ObjectDelta<T> addDelta = null;
        ObjectDelta<T> deleteDelta = null;
        ObjectDelta<T>[] objectDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectDelta<T> delta = objectDeltaArray[n2];
            if (delta != null) {
                if (delta.changeType == ChangeType.MODIFY) {
                    modifyDeltas.add(delta);
                } else if (delta.changeType == ChangeType.ADD) {
                    if (addDelta != null) {
                        throw new IllegalArgumentException("Cannot merge two add deltas: " + addDelta + ", " + delta);
                    }
                    addDelta = delta;
                } else if (delta.changeType == ChangeType.DELETE) {
                    deleteDelta = delta;
                }
            }
            ++n2;
        }
        if (deleteDelta != null && addDelta == null) {
            return deleteDelta.clone();
        }
        if (deleteDelta != null && addDelta != null) {
            throw new IllegalArgumentException("Cannot merge add and delete deltas: " + addDelta + ", " + deleteDelta);
        }
        if (addDelta != null) {
            return ObjectDelta.mergeToDelta(addDelta, modifyDeltas);
        }
        if (modifyDeltas.size() == 0) {
            return null;
        }
        if (modifyDeltas.size() == 1) {
            return (ObjectDelta)modifyDeltas.get(0);
        }
        return ObjectDelta.mergeToDelta((ObjectDelta)modifyDeltas.get(0), modifyDeltas.subList(1, modifyDeltas.size()));
    }

    private static <T extends Objectable> ObjectDelta<T> mergeToDelta(ObjectDelta<T> firstDelta, List<ObjectDelta<T>> modifyDeltas) throws SchemaException {
        if (modifyDeltas.size() == 0) {
            return firstDelta;
        }
        Object delta = firstDelta.clone();
        for (ObjectDelta<T> modifyDelta : modifyDeltas) {
            if (modifyDelta == null) continue;
            if (modifyDelta.changeType != ChangeType.MODIFY) {
                throw new IllegalArgumentException("Can only merge MODIFY changes, got " + (Object)((Object)modifyDelta.changeType));
            }
            super.mergeModifications(modifyDelta.modifications);
        }
        return delta;
    }

    private void mergeModifications(Collection<? extends ItemDelta> modificationsToMerge) throws SchemaException {
        for (ItemDelta itemDelta : modificationsToMerge) {
            if (this.changeType == ChangeType.ADD) {
                itemDelta.applyTo(this.objectToAdd);
                continue;
            }
            if (this.changeType != ChangeType.MODIFY) continue;
            ItemDelta myDelta = this.findModification(itemDelta.getPath(), ItemDelta.class);
            if (myDelta == null) {
                this.modifications.add(itemDelta);
                continue;
            }
            myDelta.merge(itemDelta);
        }
    }

    public void applyTo(PrismObject<T> targetObject) throws SchemaException {
        if (this.isEmpty()) {
            return;
        }
        if (this.changeType != ChangeType.MODIFY) {
            throw new IllegalStateException("Can apply only MODIFY delta to object, got " + (Object)((Object)this.changeType) + " delta");
        }
        for (ItemDelta itemDelta : this.modifications) {
            itemDelta.applyTo(targetObject);
        }
    }

    public PrismObject<T> computeChangedObject(PrismObject<T> objectOld) throws SchemaException {
        if (objectOld == null) {
            if (this.getChangeType() == ChangeType.ADD) {
                objectOld = this.getObjectToAdd();
            } else {
                return null;
            }
        }
        if (this.getChangeType() == ChangeType.DELETE) {
            return null;
        }
        PrismContainer objectNew = objectOld.clone();
        for (ItemDelta itemDelta : this.modifications) {
            itemDelta.applyTo(objectNew);
        }
        return objectNew;
    }

    public void swallow(ItemDelta<?> newItemDelta) throws SchemaException {
        if (this.changeType == ChangeType.MODIFY) {
            this.addModification(newItemDelta);
        } else if (this.changeType == ChangeType.ADD) {
            PrismProperty property = this.objectToAdd.findOrCreateProperty(new PropertyPath(newItemDelta.getParentPath(), newItemDelta.getName()));
            newItemDelta.applyTo(property);
        }
    }

    private Collection<? extends ItemDelta> createEmptyModifications() {
        return new ArrayList();
    }

    public <X> PropertyDelta<X> createPropertyModification(QName name, PrismPropertyDefinition propertyDefinition) {
        PropertyDelta propertyDelta = new PropertyDelta(name, propertyDefinition);
        this.addModification(propertyDelta);
        return propertyDelta;
    }

    public <X> PropertyDelta<X> createPropertyModification(PropertyPath path, PrismPropertyDefinition propertyDefinition) {
        PropertyDelta propertyDelta = new PropertyDelta(path, propertyDefinition);
        this.addModification(propertyDelta);
        return propertyDelta;
    }

    public ReferenceDelta createReferenceModification(QName name, PrismReferenceDefinition referenceDefinition) {
        ReferenceDelta referenceDelta = new ReferenceDelta(name, referenceDefinition);
        this.addModification(referenceDelta);
        return referenceDelta;
    }

    public static <O extends Objectable, X> ObjectDelta<O> createModificationReplaceProperty(Class<O> type, String oid, QName propertyName, PrismContext prismContext, X ... propertyValues) {
        PropertyPath propertyPath = new PropertyPath(propertyName);
        return ObjectDelta.createModificationReplaceProperty(type, oid, propertyPath, prismContext, propertyValues);
    }

    public static <O extends Objectable, X> ObjectDelta<O> createModificationReplaceProperty(Class<O> type, String oid, PropertyPath propertyPath, PrismContext prismContext, X ... propertyValues) {
        ObjectDelta<O> objectDelta = new ObjectDelta<O>(type, ChangeType.MODIFY);
        objectDelta.setOid(oid);
        PrismObjectDefinition<O> objDef = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        PrismPropertyDefinition propDef = objDef.findPropertyDefinition(propertyPath);
        PropertyDelta<X> propertyDelta = objectDelta.createPropertyModification(propertyPath, propDef);
        ArrayList<PrismPropertyValue<X>> valuesToReplace = new ArrayList<PrismPropertyValue<X>>(propertyValues.length);
        X[] XArray = propertyValues;
        int n = propertyValues.length;
        int n2 = 0;
        while (n2 < n) {
            PolyString polyStringVal;
            X val = XArray[n2];
            if (val instanceof PolyString && !(polyStringVal = (PolyString)val).isComputed()) {
                polyStringVal.recompute(prismContext.getDefaultPolyStringNormalizer());
            }
            PrismPropertyValue<X> pval = new PrismPropertyValue<X>(val);
            valuesToReplace.add(pval);
            ++n2;
        }
        propertyDelta.setValuesToReplace(valuesToReplace);
        return objectDelta;
    }

    public static <O extends Objectable> ObjectDelta<O> createModificationAddReference(Class<O> type, String oid, QName propertyName, PrismContext prismContext, PrismObject<?> ... referenceObjects) {
        ObjectDelta<O> objectDelta = new ObjectDelta<O>(type, ChangeType.MODIFY);
        objectDelta.setOid(oid);
        PrismObjectDefinition<O> objDef = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        PrismReferenceDefinition refDef = objDef.findReferenceDefinition(propertyName);
        ReferenceDelta referenceDelta = objectDelta.createReferenceModification(propertyName, refDef);
        ArrayList<PrismReferenceValue> valuesToReplace = new ArrayList<PrismReferenceValue>(referenceObjects.length);
        PrismObject<?>[] prismObjectArray = referenceObjects;
        int n = referenceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            PrismObject<?> refObject = prismObjectArray[n2];
            PrismReferenceValue refVal = new PrismReferenceValue();
            refVal.setObject(refObject);
            valuesToReplace.add(refVal);
            ++n2;
        }
        referenceDelta.setValuesToReplace(valuesToReplace);
        return objectDelta;
    }

    public static <T extends Objectable> ObjectDelta<T> createModifyDelta(String oid, Collection<? extends ItemDelta> modifications, Class<T> objectTypeClass) {
        ObjectDelta<T> objectDelta = new ObjectDelta<T>(objectTypeClass, ChangeType.MODIFY);
        objectDelta.addModifications(modifications);
        objectDelta.setOid(oid);
        return objectDelta;
    }

    public static <O extends Objectable> ObjectDelta<O> createEmptyAddDelta(Class<O> type, String oid, PrismContext prismContext) {
        ObjectDelta<O> objectDelta = ObjectDelta.createEmptyDelta(type, oid, prismContext, ChangeType.ADD);
        PrismObjectDefinition<O> objDef = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        PrismContainer objectToAdd = objDef.instantiate();
        objectDelta.setObjectToAdd((PrismObject<O>)objectToAdd);
        return objectDelta;
    }

    public static <O extends Objectable> ObjectDelta<O> createEmptyModifyDelta(Class<O> type, String oid, PrismContext prismContext) {
        return ObjectDelta.createEmptyDelta(type, oid, prismContext, ChangeType.MODIFY);
    }

    public static <O extends Objectable> ObjectDelta<O> createEmptyDeleteDelta(Class<O> type, String oid, PrismContext prismContext) {
        return ObjectDelta.createEmptyDelta(type, oid, prismContext, ChangeType.DELETE);
    }

    public static <O extends Objectable> ObjectDelta<O> createEmptyDelta(Class<O> type, String oid, PrismContext prismContext, ChangeType changeType) {
        ObjectDelta<O> objectDelta = new ObjectDelta<O>(type, changeType);
        objectDelta.setOid(oid);
        return objectDelta;
    }

    public static <O extends Objectable> ObjectDelta<O> createAddDelta(PrismObject<O> objectToAdd) {
        ObjectDelta objectDelta = new ObjectDelta(objectToAdd.getCompileTimeClass(), ChangeType.ADD);
        objectDelta.setOid(objectToAdd.getOid());
        objectDelta.setObjectToAdd(objectToAdd);
        return objectDelta;
    }

    public void checkConsistence() {
        this.checkConsistence(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkConsistence(boolean requireOid) {
        if (this.getChangeType() == ChangeType.ADD) {
            if (this.getModifications() != null && !this.getModifications().isEmpty()) {
                throw new IllegalStateException("Modifications present in ADD delta " + this);
            }
            if (this.getObjectToAdd() == null) throw new IllegalStateException("User primary delta is ADD, but there is not object to add in " + this);
            PrismAsserts.assertParentConsistency(this.getObjectToAdd());
            return;
        } else if (this.getChangeType() == ChangeType.MODIFY) {
            if (requireOid && this.getOid() == null) {
                throw new IllegalStateException("Null oid in delta " + this);
            }
            if (this.getObjectToAdd() != null) {
                throw new IllegalStateException("Object to add present in MODIFY delta " + this);
            }
            if (this.getModifications() == null) {
                throw new IllegalStateException("Null modification in MODIFY delta " + this);
            }
            ItemDelta.checkConsistence(this.getModifications());
            return;
        } else {
            if (this.getChangeType() != ChangeType.DELETE) throw new IllegalStateException("Unknown change type " + (Object)((Object)this.getChangeType()) + " in delta " + this);
            if (requireOid && this.getOid() == null) {
                throw new IllegalStateException("Null oid in delta " + this);
            }
            if (this.getObjectToAdd() != null) {
                throw new IllegalStateException("Object to add present in DELETE delta " + this);
            }
            if (this.getModifications() == null || this.getModifications().isEmpty()) return;
            throw new IllegalStateException("Modifications present in DELETE delta " + this);
        }
    }

    public void assertDefinitions() throws SchemaException {
        this.assertDefinitions("");
    }

    public void assertDefinitions(String sourceDescription) throws SchemaException {
        this.assertDefinitions(false, sourceDescription);
    }

    public void assertDefinitions(boolean tolerateRawElements) throws SchemaException {
        this.assertDefinitions(tolerateRawElements, "");
    }

    public void assertDefinitions(boolean tolerateRawElements, String sourceDescription) throws SchemaException {
        if (this.changeType == ChangeType.ADD) {
            this.objectToAdd.assertDefinitions("add delta in " + sourceDescription);
        }
        if (this.changeType == ChangeType.MODIFY) {
            for (ItemDelta itemDelta : this.modifications) {
                itemDelta.assertDefinitions(tolerateRawElements, "modify delta for " + this.getOid() + " in " + sourceDescription);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectDelta(oid=");
        sb.append(this.oid).append(",").append((Object)this.changeType).append(": ");
        if (this.changeType == ChangeType.ADD) {
            if (this.objectToAdd == null) {
                sb.append("null");
            } else {
                sb.append(this.objectToAdd.toString());
            }
        } else if (this.changeType == ChangeType.MODIFY) {
            Iterator<? extends ItemDelta> i = this.modifications.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("ObjectDelta<").append(this.objectTypeClass.getSimpleName()).append(">:");
        sb.append(this.oid).append(",").append((Object)this.changeType).append("):\n");
        if (this.objectToAdd == null) {
            if (this.changeType == ChangeType.ADD) {
                DebugUtil.indentDebugDump((StringBuilder)sb, (int)(indent + 1));
                sb.append("null");
            }
        } else {
            sb.append(this.objectToAdd.debugDump(indent + 1));
        }
        if (this.modifications != null) {
            Iterator<? extends ItemDelta> i = this.modifications.iterator();
            while (i.hasNext()) {
                sb.append(i.next().debugDump(indent + 1));
                if (!i.hasNext()) continue;
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String dump() {
        return this.debugDump(0);
    }
}

