/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.Protocol;
import org.apache.wicket.protocol.https.RequireHttps;
import org.apache.wicket.protocol.https.SwitchProtocolRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.IPageClassRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpsRequestChecker {
    HttpsRequestChecker() {
    }

    IRequestHandler checkSecureIncoming(IRequestHandler requestHandler, HttpsConfig httpsConfig) {
        IRequestHandler redirect;
        if (requestHandler instanceof SwitchProtocolRequestHandler) {
            return requestHandler;
        }
        Class<?> pageClass = this.getPageClass(requestHandler);
        if (pageClass != null && (redirect = this.hasSecureAnnotation(pageClass) ? SwitchProtocolRequestHandler.requireProtocol(Protocol.HTTPS, httpsConfig) : SwitchProtocolRequestHandler.requireProtocol(Protocol.HTTP, httpsConfig)) != null) {
            return redirect;
        }
        return requestHandler;
    }

    public Protocol getProtocol(IRequestHandler requestHandler) {
        Class<?> pageClass = this.getPageClass(requestHandler);
        if (pageClass != null) {
            if (this.hasSecureAnnotation(pageClass)) {
                return Protocol.HTTPS;
            }
            return Protocol.HTTP;
        }
        return Protocol.PRESERVE_CURRENT;
    }

    private boolean hasSecureAnnotation(Class<?> klass) {
        for (Class<?> c : klass.getInterfaces()) {
            if (!this.hasSecureAnnotation(c)) continue;
            return true;
        }
        if (klass.getAnnotation(RequireHttps.class) != null) {
            return true;
        }
        if (klass.getSuperclass() != null) {
            return this.hasSecureAnnotation(klass.getSuperclass());
        }
        return false;
    }

    private Class<?> getPageClass(IRequestHandler handler) {
        if (handler instanceof IPageClassRequestHandler) {
            return ((IPageClassRequestHandler)handler).getPageClass();
        }
        return null;
    }
}

