/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import javax.servlet.http.Cookie;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;

class HeaderBufferingWebResponse
extends WebResponse
implements IMetaDataBufferingWebResponse {
    private final WebResponse originalResponse;
    private final BufferedWebResponse bufferedResponse;
    private boolean bufferedWritten = false;
    private boolean flushed = false;

    public HeaderBufferingWebResponse(WebResponse originalResponse) {
        this.originalResponse = originalResponse;
        this.bufferedResponse = new BufferedWebResponse(originalResponse);
    }

    private void writeBuffered() {
        if (!this.bufferedWritten) {
            this.bufferedResponse.writeTo(this.originalResponse);
            this.bufferedWritten = true;
        }
    }

    private void checkHeader() {
        if (this.bufferedWritten) {
            throw new IllegalStateException("Header was already written to response!");
        }
    }

    public void addCookie(Cookie cookie) {
        this.checkHeader();
        this.bufferedResponse.addCookie(cookie);
    }

    public void clearCookie(Cookie cookie) {
        this.checkHeader();
        this.bufferedResponse.clearCookie(cookie);
    }

    public void flush() {
        if (!this.bufferedWritten) {
            this.bufferedResponse.writeTo(this.originalResponse);
            this.bufferedResponse.reset();
        }
        this.originalResponse.flush();
        this.flushed = true;
    }

    public boolean isRedirect() {
        return this.bufferedResponse.isRedirect();
    }

    public void sendError(int sc, String msg) {
        this.checkHeader();
        this.bufferedResponse.sendError(sc, msg);
    }

    public void sendRedirect(String url) {
        this.checkHeader();
        this.bufferedResponse.sendRedirect(url);
    }

    public void setContentLength(long length) {
        this.checkHeader();
        this.bufferedResponse.setContentLength(length);
    }

    public void setContentType(String mimeType) {
        this.checkHeader();
        this.bufferedResponse.setContentType(mimeType);
    }

    public void setDateHeader(String name, Time date) {
        Args.notNull((Object)date, (String)"date");
        this.checkHeader();
        this.bufferedResponse.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.checkHeader();
        this.bufferedResponse.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.checkHeader();
        this.bufferedResponse.addHeader(name, value);
    }

    public void setStatus(int sc) {
        this.bufferedResponse.setStatus(sc);
    }

    public String encodeURL(CharSequence url) {
        return this.originalResponse.encodeURL(url);
    }

    public String encodeRedirectURL(CharSequence url) {
        return this.originalResponse.encodeRedirectURL(url);
    }

    public void write(CharSequence sequence) {
        this.writeBuffered();
        this.originalResponse.write(sequence);
    }

    public void write(byte[] array) {
        this.writeBuffered();
        this.originalResponse.write(array);
    }

    public void write(byte[] array, int offset, int length) {
        this.writeBuffered();
        this.originalResponse.write(array, offset, length);
    }

    public void reset() {
        if (this.flushed) {
            throw new IllegalStateException("Response has already been flushed!");
        }
        this.bufferedResponse.reset();
        this.bufferedWritten = false;
    }

    public void writeMetaData(WebResponse webResponse) {
        this.bufferedResponse.writeMetaData(webResponse);
    }

    public Object getContainerResponse() {
        return this.originalResponse.getContainerResponse();
    }
}

